/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender;

import java.util.List;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LivingSkinRenderer<T extends LivingEntity, M extends IModel>
extends SkinRenderer<T, M> {
    protected LivingRenderer<T, ?> renderer;

    public LivingSkinRenderer(EntityProfile profile) {
        super(profile);
    }

    @Override
    protected void init(EntityRenderer<T> entityRenderer) {
        super.init(entityRenderer);
        if (entityRenderer instanceof LivingRenderer) {
            this.replace((LivingRenderer)entityRenderer);
        }
    }

    @Override
    public M getOverrideModel(M model) {
        return super.getOverrideModel(this.getResolvedModel(model));
    }

    @Override
    public int render(T entity, M model, BakedSkin bakedSkin, ColorScheme scheme, SkinRenderContext context) {
        return super.render(entity, this.getResolvedModel(model), bakedSkin, scheme, context);
    }

    public M getResolvedModel(M model) {
        if (model == null) {
            model = ModelHolder.of((Model)this.renderer.func_217764_d());
        }
        return model;
    }

    private void replace(LivingRenderer<T, EntityModel<T>> entityRenderer) {
        this.renderer = entityRenderer;
        SkinRendererManager.getInstance().applyPlugins(this, plugin -> {
            List layers = entityRenderer.field_177097_h;
            for (int index = 0; index < layers.size(); ++index) {
                LayerRenderer newValue = plugin.getOverrideLayer(entityRenderer, (LayerRenderer)layers.get(index));
                if (newValue == null) continue;
                layers.set(index, newValue);
            }
        });
    }

    public static interface Plugin<T extends LivingEntity, M extends IModel> {
        public LayerRenderer<T, EntityModel<T>> getOverrideLayer(LivingRenderer<T, EntityModel<T>> var1, LayerRenderer<T, EntityModel<T>> var2);
    }
}

