/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender;

import extensions.net.minecraft.world.entity.LivingEntity.AnimationModifier;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.client.model.IHumanoidModel;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.armature.Joints;
import moe.plushie.armourers_workshop.core.client.other.SkinModelTransformer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinVisibilityTransformer;
import moe.plushie.armourers_workshop.core.client.skinrender.LivingSkinRenderer;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ExtendedSkinRenderer<T extends LivingEntity, M extends IHumanoidModel>
extends LivingSkinRenderer<T, M> {
    public ExtendedSkinRenderer(EntityProfile profile) {
        super(profile);
    }

    @Override
    protected void init(SkinModelTransformer<T, M> transformer) {
        transformer.registerArmor(SkinPartTypes.BIPPED_HAT, Joints.BIPPED_HEAD);
        transformer.registerArmor(SkinPartTypes.BIPPED_HEAD, Joints.BIPPED_HEAD);
        transformer.registerArmor(SkinPartTypes.BIPPED_CHEST, Joints.BIPPED_CHEST);
        transformer.registerArmor(SkinPartTypes.BIPPED_LEFT_ARM, Joints.BIPPED_LEFT_ARM);
        transformer.registerArmor(SkinPartTypes.BIPPED_RIGHT_ARM, Joints.BIPPED_RIGHT_ARM);
        transformer.registerArmor(SkinPartTypes.BIPPED_LEFT_FOOT, Joints.BIPPED_LEFT_FOOT);
        transformer.registerArmor(SkinPartTypes.BIPPED_RIGHT_FOOT, Joints.BIPPED_RIGHT_FOOT);
        transformer.registerArmor(SkinPartTypes.BIPPED_LEFT_THIGH, Joints.BIPPED_LEFT_THIGH);
        transformer.registerArmor(SkinPartTypes.BIPPED_RIGHT_THIGH, Joints.BIPPED_RIGHT_THIGH);
        transformer.registerArmor(SkinPartTypes.BIPPED_SKIRT, Joints.BIPPED_SKIRT);
        transformer.registerArmor(SkinPartTypes.BIPPED_RIGHT_WING, this.sel(Joints.BIPPED_LEFT_WING, Joints.BIPPED_LEFT_PHALANX));
        transformer.registerArmor(SkinPartTypes.BIPPED_LEFT_WING, this.sel(Joints.BIPPED_RIGHT_WING, Joints.BIPPED_RIGHT_PHALANX));
        transformer.registerArmor(SkinPartTypes.BIPPED_RIGHT_PHALANX, Joints.BIPPED_LEFT_PHALANX);
        transformer.registerArmor(SkinPartTypes.BIPPED_LEFT_PHALANX, Joints.BIPPED_RIGHT_PHALANX);
        transformer.registerArmor(SkinPartTypes.BIPPED_TORSO, Joints.BIPPED_TORSO);
        transformer.registerArmor(SkinPartTypes.BIPPED_LEFT_HAND, Joints.BIPPED_LEFT_HAND);
        transformer.registerArmor(SkinPartTypes.BIPPED_RIGHT_HAND, Joints.BIPPED_RIGHT_HAND);
        transformer.registerArmor(SkinPartTypes.BIPPED_LEFT_LEG, Joints.BIPPED_LEFT_LEG);
        transformer.registerArmor(SkinPartTypes.BIPPED_RIGHT_LEG, Joints.BIPPED_RIGHT_LEG);
        transformer.registerItem(AbstractItemTransformType.NONE, SkinModelTransformer::fromModel);
        transformer.registerItem(AbstractItemTransformType.GUI, SkinModelTransformer::fromModel);
        transformer.registerItem(AbstractItemTransformType.FIXED, SkinModelTransformer::fromModel);
        transformer.registerItem(AbstractItemTransformType.GROUND, SkinModelTransformer::fromModel);
        transformer.registerItem(AbstractItemTransformType.THIRD_PERSON_LEFT_HAND, SkinModelTransformer::fromModel);
        transformer.registerItem(AbstractItemTransformType.THIRD_PERSON_RIGHT_HAND, SkinModelTransformer::fromModel);
        transformer.registerItem(AbstractItemTransformType.FIRST_PERSON_LEFT_HAND, SkinModelTransformer::fromModel);
        transformer.registerItem(AbstractItemTransformType.FIRST_PERSON_RIGHT_HAND, SkinModelTransformer::fromModel);
    }

    @Override
    protected void init(SkinVisibilityTransformer<M> transformer) {
        SkinVisibilityTransformer.setupHumanoidModel(transformer);
    }

    @Override
    public void willRender(T entity, M model, SkinRenderData renderData, SkinRenderContext context) {
        super.willRender(entity, model, renderData, context);
        renderData.getOverriddenManager().willRender((Entity)entity);
        if (renderData.isLimitLimbs()) {
            AnimationModifier.applyLimitLimbs(entity);
        }
    }

    @Override
    public void didRender(T entity, M model, SkinRenderData renderData, SkinRenderContext renderContext) {
        super.didRender(entity, model, renderData, renderContext);
        renderData.getOverriddenManager().didRender((Entity)entity);
    }

    protected SkinModelTransformer.Entry<T, M> sel(IJoint joint1, IJoint joint2) {
        return (poseStack, entity, model, bakedPart, bakedSkin, context) -> {
            if (bakedPart.getProperties().get(SkinProperty.WINGS_MATCHING_POSE).booleanValue()) {
                this.transformer.apply(poseStack, joint2, context);
            } else {
                this.transformer.apply(poseStack, joint1, context);
            }
        };
    }
}

