/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import java.util.Collection;
import java.util.HashMap;
import moe.plushie.armourers_workshop.core.client.shader.ShaderUniform;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL20;

@OnlyIn(value=Dist.CLIENT)
public class ShaderUniforms {
    private static ShaderUniforms INSTANCE = new ShaderUniforms();
    private final HashMap<Integer, HashMap<String, ShaderUniform>> changes = new HashMap();
    private final HashMap<Integer, Collection<ShaderUniform>> uniforms = new HashMap();

    public static ShaderUniforms getInstance() {
        return INSTANCE;
    }

    public static void begin() {
    }

    public static void end() {
        ShaderUniforms.getInstance().restoreUniforms();
    }

    public static void clear() {
        if (ShaderUniforms.getInstance().uniforms.isEmpty()) {
            return;
        }
        INSTANCE = new ShaderUniforms();
        ModLog.debug("reset all uniforms from shader changes", new Object[0]);
    }

    public void apply() {
        int programId = GL20.glGetInteger((int)35725);
        if (programId == 0) {
            return;
        }
        Collection uniforms = this.uniforms.computeIfAbsent(programId, this::getLocations);
        if (uniforms.isEmpty()) {
            return;
        }
        for (ShaderUniform uniform : uniforms) {
            this.saveUniform(uniform);
            uniform.apply();
        }
    }

    private void saveUniform(ShaderUniform uniform) {
        this.changes.computeIfAbsent(uniform.program, key -> new HashMap()).computeIfAbsent(uniform.name, key -> {
            uniform.push();
            return uniform;
        });
    }

    private void restoreUniforms() {
        if (this.changes.isEmpty()) {
            return;
        }
        int currentProgram = GL20.glGetInteger((int)35725);
        this.changes.forEach((program, uniforms) -> {
            if (currentProgram != program) {
                GL20.glUseProgram((int)program);
            }
            uniforms.forEach((name, uniform) -> uniform.pop());
            if (currentProgram != program) {
                GL20.glUseProgram((int)currentProgram);
            }
        });
        this.changes.clear();
    }

    private Collection<ShaderUniform> getLocations(int programId) {
        return new ShaderUniform.Loader((int)programId).uniforms;
    }
}

