/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShaderPreprocessor {
    public static final ImmutableList<String> PATCHED_VANILLA_SHADERS = new ImmutableList.Builder().add((Object)"rendertype_entity_solid").add((Object)"rendertype_entity_shadow").add((Object)"rendertype_entity_cutout").add((Object)"rendertype_energy_swirl").build();
    private final String prefix;

    public ShaderPreprocessor(String prefix) {
        this.prefix = prefix;
    }

    public String process(String source) {
        if (this.prefix.isEmpty()) {
            return this.processVanillaShader(new Builder(source));
        }
        if (this.prefix.equals("va")) {
            return this.processOptifineShader(new Builder(source));
        }
        if (this.prefix.equals("iris_")) {
            return this.processIrisShader(new Builder(source));
        }
        if (this.prefix.equals("frx_")) {
            return this.processCanvasShader(new Builder(source));
        }
        return source;
    }

    private String processIrisShader(Builder builder) {
        builder.uniform("mat4", "iris_TextureMat", "mat4", "aw_TextureMatrix", "($1 * $2)");
        builder.uniform("mat4", "iris_LightmapTextureMatrix", "mat4", "aw_LightmapTextureMatrix", "($1 * $2)");
        builder.attribute("vec3", "iris_Normal", "mat3", "aw_NormalMatrix", "($1 * $2)");
        builder.uniform("mat4", "iris_ModelViewMat", "mat4", "aw_ModelViewMat", "($1 * $2)");
        return this.build("iris", builder);
    }

    private String processOptifineShader(Builder builder) {
        builder.attribute("ivec2", "vaUV2", "mat4", "aw_LightmapTextureMatrix", "ivec2($2 * vec4($1, 1, 1))");
        builder.uniform("mat4", "textureMatrix", "mat4", "aw_TextureMatrix", "($1 * $2)");
        builder.attribute("vec3", "vaNormal", "mat3", "aw_NormalMatrix", "($1 * $2)");
        builder.uniform("mat4", "modelViewMatrix", "mat4", "aw_ModelViewMat", "($1 * $2)");
        return this.build("optifine", builder);
    }

    private String processCanvasShader(Builder builder) {
        return this.build("canvas", builder);
    }

    private String processVanillaShader(Builder builder) {
        builder.attribute("ivec2", "UV2", "mat4", "aw_LightmapTextureMatrix", "ivec2($2 * vec4($1, 1, 1))");
        builder.attribute("vec2", "UV0", "mat4", "aw_TextureMatrix", "vec2($2 * vec4($1, 1, 1))");
        builder.attribute("vec3", "Normal", "mat3", "aw_NormalMatrix", "($1 * $2)");
        builder.uniform("mat4", "ModelViewMat", "mat4", "aw_ModelViewMat", "($1 * $2)");
        return this.build("vanilla", builder);
    }

    private String build(String type, Builder builder) {
        String source = builder.build();
        if (ModConfig.Client.enableShaderDebug) {
            ModLog.info("process {} shader: \n{}", type, source);
        }
        return source;
    }

    public static class Builder {
        private String source;
        private final ArrayList<String> initializer1 = new ArrayList();
        private final ArrayList<String> initializer2 = new ArrayList();

        public Builder(String source) {
            this.source = source;
        }

        public Builder uniform(String varType, String var, String matrixType, String matrixVar, String expr) {
            this.source = this.register("uniform", this.source, varType, var, matrixType, matrixVar, expr);
            return this;
        }

        public Builder attribute(String varType, String var, String matrixType, String matrixVar, String expr) {
            this.source = this.register("in", this.source, varType, var, matrixType, matrixVar, expr);
            return this;
        }

        private String register(String category, String source, String varType, String var, String matrixType, String matrix, String expr) {
            int i;
            String[] texts = new String[]{"(${category}\\s+${varType}\\s+)(\\b${var}\\b)(.*?;)", "$1__awrt_${var}_awrt__$3", "\\b${var}\\b", "awrt_${var}", "(${category}\\s+${varType}\\s+)(\\b__awrt_${var}_awrt__)\\b(.*?;)", "uniform ${matrixType} ${matrix};\n${varType} awrt_${var};\n$1${var}$3"};
            String[] regexes = new String[texts.length];
            for (i = 0; i < texts.length; ++i) {
                String tmp = texts[i];
                tmp = tmp.replace("${category}", category);
                tmp = tmp.replace("${varType}", varType);
                tmp = tmp.replace("${var}", var);
                tmp = tmp.replace("${matrixType}", matrixType);
                regexes[i] = tmp = tmp.replace("${matrix}", matrix);
            }
            for (i = 0; i < regexes.length / 2; ++i) {
                String newValue = source.replaceAll(regexes[i * 2], regexes[i * 2 + 1]);
                if (i == 0 && newValue.equals(source)) {
                    return source;
                }
                source = newValue;
            }
            this.initializer1.add("awrt_" + var + " = " + var);
            this.initializer2.add("awrt_" + var + " = " + expr.replace("$1", var).replace("$2", matrix));
            return source;
        }

        public String build() {
            if (this.initializer1.isEmpty()) {
                return this.source;
            }
            SourceBuilder builder = new SourceBuilder();
            builder.append("#ifdef GL_ES\n");
            builder.append("uniform bool aw_MatrixFlags;\n");
            builder.append("#else\n");
            builder.append("uniform bool aw_MatrixFlags = false;\n");
            builder.append("#endif\n");
            builder.append("void awrt_main_pre() {\n");
            builder.append("    if (aw_MatrixFlags) {\n");
            builder.append("        ", this.initializer2, ";\n");
            builder.append("    } else {\n");
            builder.append("        ", this.initializer1, ";\n");
            builder.append("    }\n");
            builder.append("}\n");
            return this.source.replaceAll("(void\\s+main\\s*\\(\\)\\s*\\{)", builder.build() + "\n$1\n    awrt_main_pre();\n");
        }

        public String toString() {
            return this.build();
        }
    }

    public static class SourceBuilder {
        private final StringBuffer buffer = new StringBuffer();

        public void append(String value) {
            this.buffer.append(value);
        }

        public void append(String prefix, Collection<String> children, String suffix) {
            for (String content : children) {
                this.buffer.append(prefix);
                this.buffer.append(content);
                this.buffer.append(suffix);
            }
        }

        public String build() {
            return this.buffer.toString();
        }
    }
}

