/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import extensions.net.minecraft.client.renderer.block.model.ItemTransforms.TypeConverter;
import extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractItemStackRenderer;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.model.MannequinModel;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.item.MannequinItem;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinItemRenderer
extends AbstractItemStackRenderer {
    private static SkinItemRenderer INSTANCE;
    private ItemStack playerMannequinItem;
    private MannequinEntity entity;
    private MannequinModel<MannequinEntity> model;

    public static SkinItemRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SkinItemRenderer();
        }
        return INSTANCE;
    }

    @Override
    public void renderByItem(ItemStack itemStack, AbstractItemTransformType transformType, MatrixStack poseStack, IRenderTypeBuffer renderTypeBuffer, int light, int overlay) {
        if (itemStack.func_190926_b()) {
            return;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.INVENTORY);
        if (bakedSkin == null) {
            return;
        }
        IBakedModel bakedModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(itemStack);
        ItemTransformVec3f transform = bakedModel.func_177552_f().func_181688_b(TypeConverter.ofType(ItemCameraTransforms.class, transformType));
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.5, 0.5, 0.5);
        Vector3f rotation = new Vector3f(-transform.field_178364_b.func_195899_a(), -transform.field_178364_b.func_195900_b(), transform.field_178364_b.func_195902_c());
        Vector3f scale = Vector3f.ONE;
        SkinItemSource itemSource = SkinItemSource.create(itemStack);
        itemSource.setRotation(rotation);
        itemSource.setTransformType(transformType);
        ColorScheme scheme = descriptor.getColorScheme();
        ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, scale, 1.0f, 1.0f, 1.0f, 0.0f, light, itemSource, poseStack, renderTypeBuffer);
        poseStack.func_227865_b_();
    }

    public MannequinEntity getMannequinEntity() {
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (this.entity == null) {
            this.entity = new MannequinEntity((EntityType<? extends MannequinEntity>)((EntityType)((IEntityType)ModEntityTypes.MANNEQUIN.get()).get()), (World)level);
            this.entity.func_145769_d(-1021);
            this.entity.setExtraRenderer(false);
        }
        if (PropertyProvider.getLevel((Entity)this.entity) != level) {
            this.entity.changeLevel((World)level);
        }
        return this.entity;
    }

    public MannequinModel<?> getMannequinModel() {
        MannequinEntity entity = this.getMannequinEntity();
        if (this.model == null && entity != null) {
            this.model = new MannequinModel();
            this.model.field_217114_e = false;
            this.model.field_228270_o_ = false;
            this.model.field_217113_d = false;
            this.model.func_212843_a_((LivingEntity)entity, 0.0f, 0.0f, 0.0f);
            this.model.setupAnim(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        return this.model;
    }

    public ItemStack getPlayerMannequinItem() {
        if (this.playerMannequinItem == null) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return ItemStack.field_190927_a;
            }
            this.playerMannequinItem = MannequinItem.of((PlayerEntity)player, 1.0f);
        }
        return this.playerMannequinItem;
    }
}

