/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.matrix.MatrixStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractLivingEntityRenderer;
import moe.plushie.armourers_workshop.core.client.model.MannequinArmorModel;
import moe.plushie.armourers_workshop.core.client.model.MannequinModel;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.texture.BakedEntityTexture;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MannequinEntityRenderer<T extends MannequinEntity>
extends AbstractLivingEntityRenderer<T, MannequinModel<T>> {
    public static boolean enableLimitScale = false;
    public static boolean enableLimitYRot = false;
    private final AbstractEntityRendererProviderImpl.Context context;
    private final MannequinModel<T> normalModel;
    private final MannequinModel<T> slimModel;
    private MannequinEntityRenderer<T> mannequinRenderer;
    private ResourceLocation texture;
    private BakedEntityTexture bakedTexture;
    private boolean enableChildRenderer = false;

    public MannequinEntityRenderer(AbstractEntityRendererProviderImpl.Context context) {
        super(context, new MannequinModel(context, 0.0f, false), 0.0f);
        this.func_177094_a(this.getLayerProvider().createHumanoidArmorLayer(context, MannequinArmorModel.innerModel(context), MannequinArmorModel.outerModel(context)));
        this.func_177094_a(this.getLayerProvider().createItemInHandLayer(context));
        this.func_177094_a(this.getLayerProvider().createElytraLayer(context));
        this.func_177094_a(this.getLayerProvider().createCustomHeadLayer(context));
        this.normalModel = (MannequinModel)super.func_217764_d();
        this.slimModel = new MannequinModel(context, 0.0f, true);
        this.context = context;
    }

    public boolean shouldShowName(T entity) {
        return entity.func_145818_k_();
    }

    public void render(T entity, float f, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffers, int packedLightIn) {
        if (this.enableChildRenderer) {
            this.getChildRenderer().render(entity, f, partialTicks, poseStack, buffers, packedLightIn);
            return;
        }
        PlayerTextureLoader textureLoader = PlayerTextureLoader.getInstance();
        this.texture = textureLoader.getTextureLocation((Entity)entity);
        this.bakedTexture = textureLoader.getTextureModel(this.texture);
        this.setModel(this.getModel());
        ((MannequinModel)super.func_217764_d()).func_178719_a(((MannequinEntity)entity).isModelVisible());
        this.enableChildRenderer = true;
        super.func_225623_a_(entity, f, partialTicks, poseStack, buffers, packedLightIn);
        this.enableChildRenderer = false;
        if (ModDebugger.mannequinCulling) {
            poseStack.func_227860_a_();
            AxisAlignedBB box = ((MannequinEntity)entity).func_184177_bl();
            double tx = -box.field_72340_a - (box.field_72336_d - box.field_72340_a) / 2.0;
            double ty = -box.field_72338_b;
            double tz = -box.field_72339_c - (box.field_72334_f - box.field_72339_c) / 2.0;
            poseStack.func_227861_a_((double)((float)tx), (double)((float)ty), (double)((float)tz));
            ShapeTesselator.stroke(box, UIColor.YELLOW, poseStack, buffers);
            poseStack.func_227865_b_();
        }
    }

    public void scale(T entity, MatrixStack poseStack, float p_225620_3_) {
        float f = 0.9375f;
        if (!enableLimitScale) {
            f *= ((MannequinEntity)entity).func_213355_cm();
        }
        poseStack.func_227862_a_(f, f, f);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.texture;
    }

    public MannequinModel<T> getModel() {
        if (this.bakedTexture != null && this.bakedTexture.isSlimModel()) {
            return this.slimModel;
        }
        return this.normalModel;
    }

    public MannequinEntityRenderer<T> getChildRenderer() {
        if (this.mannequinRenderer == null) {
            this.mannequinRenderer = new MannequinEntityRenderer<T>(this.context);
        }
        return this.mannequinRenderer;
    }
}

