/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;

public class ExtendedFaceRenderer {
    private static final float[][] FACE_MARK_TEXTURES = new float[][]{{0.998f, 0.998f}, {0.998f, 0.0f}, {0.0f, 0.0f}, {0.0f, 0.998f}};
    private static final float[][][] FACE_MARK_VERTEXES = new float[][][]{new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 1.0f}, {0.0f, -1.0f, 0.0f}}, new float[][]{{1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, -1.0f}}, new float[][]{{1.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 1.0f}}, new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}}, new float[][]{{1.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 0.0f, 1.0f}, {1.0f, 0.0f, 0.0f}}};

    public static void renderMarker(int x, int y, int z, Direction direction, IPaintColor paintColor, int alpha, int light, int overlay, MatrixStack poseStack, IVertexBuilder builder) {
        if (paintColor.getPaintType() == SkinPaintTypes.NORMAL) {
            return;
        }
        Matrix4f pose = poseStack.func_227866_c_().func_227870_a_();
        Matrix3f normal = poseStack.func_227866_c_().func_227872_b_();
        ISkinPaintType paintType = paintColor.getPaintType();
        int u = paintType.getIndex() % 8;
        int v = paintType.getIndex() / 8;
        float[][] vertexes = FACE_MARK_VERTEXES[direction.func_176745_a()];
        for (int i = 0; i < 4; ++i) {
            builder.func_227888_a_(pose, (float)x + vertexes[i][0], (float)y + vertexes[i][1], (float)z + vertexes[i][2]).func_225586_a_(255, 255, 255, alpha & 0xFF).func_225583_a_(((float)u + FACE_MARK_TEXTURES[i][0]) / 8.0f, ((float)v + FACE_MARK_TEXTURES[i][1]) / 8.0f).func_227891_b_(overlay).func_227886_a_(light).func_227887_a_(normal, vertexes[4][0], vertexes[4][1], vertexes[4][2]).func_181675_d();
        }
    }

    public static void render2(int x, int y, int z, Direction direction, IPaintColor paintColor, int alpha, int light, int overlay, MatrixStack poseStack, IVertexBuilder builder) {
        Matrix4f pose = poseStack.func_227866_c_().func_227870_a_();
        Matrix3f normal = poseStack.func_227866_c_().func_227872_b_();
        boolean u = false;
        boolean v = false;
        int color = paintColor.getRGB();
        float[][] vertexes = FACE_MARK_VERTEXES[direction.func_176745_a()];
        for (int i = 0; i < 4; ++i) {
            builder.func_227888_a_(pose, (float)x + vertexes[i][0], (float)y + vertexes[i][1], (float)z + vertexes[i][2]).func_225586_a_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, alpha & 0xFF).func_225583_a_((float)u + FACE_MARK_TEXTURES[i][0], (float)v + FACE_MARK_TEXTURES[i][1]).func_227891_b_(overlay).func_227886_a_(light).func_227887_a_(normal, vertexes[4][0], vertexes[4][1], vertexes[4][2]).func_181675_d();
        }
    }
}

