/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import com.apple.library.uikit.UIColor;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexBufferBuilder;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import org.jetbrains.annotations.NotNull;

public interface SkinRenderBufferSource {
    public static SkinRenderBufferSource immediate(IRenderTypeBuffer buffers) {
        return skin -> {
            SkinVertexBufferBuilder bufferBuilder = SkinVertexBufferBuilder.getBuffer(buffers);
            return bufferBuilder.getBuffer(skin);
        };
    }

    public ObjectBuilder getBuffer(@NotNull BakedSkin var1);

    public static interface ObjectBuilder {
        public int addPart(BakedSkinPart var1, BakedSkin var2, ColorScheme var3, boolean var4, SkinRenderContext var5);

        default public void addShape(Vector3f origin, SkinRenderContext context) {
        }

        default public void addShape(OpenVoxelShape shape, UIColor color, SkinRenderContext context) {
        }

        default public void addShape(IJointTransform[] transforms, SkinRenderContext context) {
        }
    }
}

