/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeView;
import moe.plushie.armourers_workshop.utils.MathUtils;
import org.jetbrains.annotations.Nullable;

public class TreeNode {
    private TreeView view;
    private String title;
    private Object contents;
    private boolean folding = false;
    private boolean enabled = true;
    private boolean locked = false;
    private TreeNode parent;
    private final ArrayList<TreeNode> children = new ArrayList();

    public TreeNode(String title) {
        this.title = title;
    }

    public void setNeedsDisplay() {
        if (this.view != null) {
            this.view.setNeedsDisplay(this);
        }
    }

    public void add(TreeNode node) {
        this.insertAtIndex(node, this.children.size());
    }

    public void insertAtIndex(TreeNode node, int index) {
        this.children.add(index, node);
        node.parent = this;
        node.link(this.view);
        this.setNeedsDisplay();
    }

    public void moveTo(TreeNode node, int toIndex) {
        int index = this.children.indexOf(node);
        if (index < 0 || index == toIndex) {
            return;
        }
        this.children.remove(index);
        this.children.add(MathUtils.clamp(toIndex, 0, this.children.size()), node);
        this.setNeedsDisplay();
    }

    public void removeFromParent() {
        if (this.parent == null) {
            return;
        }
        this.parent.children.remove(this);
        this.parent.setNeedsDisplay();
        this.parent = null;
        this.link(null);
    }

    public void clear() {
        this.children.forEach(node -> node.link(null));
        this.children.clear();
        this.setNeedsDisplay();
    }

    public TreeNode nodeAtIndex(int index) {
        return this.children.get(index);
    }

    public TreeNode parent() {
        return this.parent;
    }

    public List<TreeNode> children() {
        return this.children;
    }

    public boolean isFolding() {
        return this.folding;
    }

    public void setFolding(boolean folding) {
        this.folding = folding;
        this.setNeedsDisplay();
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String title() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContents(Object contents) {
        this.contents = contents;
    }

    public Object getContents() {
        return this.contents;
    }

    public TreeView getTreeView() {
        return this.view;
    }

    protected void link(@Nullable TreeView view) {
        this.view = view;
        for (TreeNode node : this.children) {
            node.link(view);
        }
    }
}

