/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIColor;
import moe.plushie.armourers_workshop.core.client.gui.widget.ClientMenuScreen;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.client.gui.widget.NotificationDialog;
import moe.plushie.armourers_workshop.core.menu.AbstractContainerMenu;
import moe.plushie.armourers_workshop.core.network.ExecuteAlertPacket;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ServerAlertWindow
extends MenuWindow<AbstractContainerMenu> {
    private final ExecuteAlertPacket alertPacket;

    public ServerAlertWindow(ExecuteAlertPacket alertPacket) {
        super(ClientMenuScreen.getEmptyMenu(), ClientMenuScreen.getEmptyInventory(), new NSString(alertPacket.getTitle()));
        this.titleView.removeFromSuperview();
        this.inventoryView.removeFromSuperview();
        this.alertPacket = alertPacket;
    }

    @Override
    public void init() {
        NotificationDialog dialog = new NotificationDialog();
        dialog.setTitle(new NSString(this.alertPacket.getTitle()));
        dialog.setMessage(new NSString(this.alertPacket.getMessage()));
        if (this.alertPacket.getType() == 1) {
            dialog.setMessageColor(new UIColor(0xFF5555));
        }
        dialog.setConfirmText(new NSString(this.alertPacket.getConfirm()));
        dialog.sizeToFit();
        dialog.showInView(this, this::dismiss);
    }

    public void showInScreen() {
        Minecraft minecraft = Minecraft.func_71410_x();
        WrappedScreen screen = new WrappedScreen(this, this.alertPacket.getTitle());
        screen.setTarget(minecraft.field_71462_r);
        minecraft.field_71462_r = null;
        minecraft.func_147108_a((Screen)screen);
    }

    public void dismiss() {
        Minecraft minecraft = Minecraft.func_71410_x();
        WrappedScreen screen = ObjectUtils.safeCast(minecraft.field_71462_r, WrappedScreen.class);
        if (screen == null) {
            return;
        }
        minecraft.func_147108_a(screen.getTarget());
    }

    public static class WrappedScreen
    extends ClientMenuScreen {
        private Screen targetScreen;

        public WrappedScreen(ServerAlertWindow window, ITextComponent component) {
            super(window, component);
        }

        @Override
        public void func_231152_a_(Minecraft minecraft, int i, int j) {
            super.func_231152_a_(minecraft, i, j);
            if (this.targetScreen != null) {
                this.targetScreen.func_231152_a_(minecraft, i, j);
            }
        }

        @Override
        public void render(CGGraphicsContext context, int mouseX, int mouseY, float partialTicks) {
            if (this.targetScreen != null) {
                this.renderBackground(context, this.targetScreen, Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            }
            context.saveGraphicsState();
            context.translateCTM(0.0f, 0.0f, 500.0f);
            super.render(context, mouseX, mouseY, partialTicks);
            context.restoreGraphicsState();
        }

        public void setTarget(Screen screen) {
            this.targetScreen = screen;
        }

        public Screen getTarget() {
            return this.targetScreen;
        }
    }
}

