/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSMutableString;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UISliderBox;
import com.apple.library.uikit.UIView;
import java.util.ArrayList;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.core.client.gui.widget.ClientMenuScreen;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.item.option.BooleanToolProperty;
import moe.plushie.armourers_workshop.core.item.option.IntegerToolProperty;
import moe.plushie.armourers_workshop.core.menu.AbstractContainerMenu;
import moe.plushie.armourers_workshop.core.network.UpdateConfigurableToolPacket;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class ConfigurableToolWindow
extends MenuWindow<AbstractContainerMenu> {
    private final ArrayList<Pair<IConfigurableToolProperty<?>, UIView>> properties = new ArrayList();
    private final Hand hand;
    private final ItemStack itemStack;
    private int contentWidth = 176;
    private int contentHeight = 24;

    public ConfigurableToolWindow(ITextComponent title, ArrayList<IConfigurableToolProperty<?>> properties, ItemStack itemStack, Hand hand) {
        super(ClientMenuScreen.getEmptyMenu(), ClientMenuScreen.getEmptyInventory(), new NSString(title));
        this.inventoryView.removeFromSuperview();
        this.setBackgroundView(ModTextures.defaultWindowImage());
        this.hand = hand;
        this.itemStack = itemStack;
        properties.forEach((Consumer<IConfigurableToolProperty<?>>)((Consumer<IConfigurableToolProperty>)property -> {
            UIView view = this.createOptionView((IConfigurableToolProperty<?>)property);
            if (view != null) {
                this.properties.add(Pair.of((Object)property, (Object)view));
                this.contentHeight = (int)((float)this.contentHeight + (view.frame().getHeight() + 8.0f));
                this.addSubview(view);
            }
        }));
        this.setFrame(new CGRect(0.0f, 0.0f, 176.0f, this.contentHeight));
    }

    public Screen asScreen() {
        return new ClientMenuScreen(this, this.title.component());
    }

    protected void sendToServer() {
        NetworkManager.sendToServer(new UpdateConfigurableToolPacket(this.hand, this.itemStack));
    }

    private UIView createOptionView(IConfigurableToolProperty<?> property) {
        NSString name = NSString.localizedString("toolOptions." + property.getName(), new Object[0]);
        if (property instanceof BooleanToolProperty) {
            BooleanToolProperty property1 = (BooleanToolProperty)property;
            UICheckBox checkBox = new UICheckBox(new CGRect(8.0f, this.contentHeight, this.contentWidth - 16, 9.0f));
            checkBox.setTitle(name);
            checkBox.setSelected((Boolean)property1.get(this.itemStack));
            checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, sender) -> {
                boolean value = sender.isSelected();
                property1.set(this.itemStack, Boolean.valueOf(value));
                this.sendToServer();
            });
            return checkBox;
        }
        if (property instanceof IntegerToolProperty) {
            IntegerToolProperty property1 = (IntegerToolProperty)property;
            UISliderBox slider = new UISliderBox(new CGRect(8.0f, this.contentHeight, this.contentWidth - 16, 20.0f));
            slider.setFormatter(currentValue -> {
                NSMutableString formattedValue = new NSMutableString("");
                formattedValue.append(name);
                formattedValue.append(" ");
                formattedValue.append(String.format("%.1f", currentValue));
                return formattedValue;
            });
            slider.setSmall(true);
            slider.setMinValue(property1.getMinValue());
            slider.setMaxValue(property1.getMaxValue());
            slider.setValue(((Integer)property1.get(this.itemStack)).intValue());
            slider.addTarget(this, UIControl.Event.EDITING_DID_END, (self, sender) -> {
                int value = (int)((UISliderBox)sender).value();
                property1.set(this.itemStack, Integer.valueOf(value));
                this.sendToServer();
            });
            return slider;
        }
        return null;
    }
}

