/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import com.google.common.collect.Range;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.action.ICanUse;
import moe.plushie.armourers_workshop.api.client.IBakedSkin;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemModel;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.render.SkinItemRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.core.data.cache.SkinCache;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinUsedCounter;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector4f;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedSkin
implements IBakedSkin {
    private final int id = ThreadUtils.BAKED_SKIN_COUNTER.incrementAndGet();
    private final String identifier;
    private final Skin skin;
    private final ISkinType skinType;
    private final HashMap<Object, Rectangle3f> cachedBounds = new HashMap();
    private final HashMap<BlockPos, Rectangle3i> cachedBlockBounds = new HashMap();
    private final Range<Integer> useTickRange;
    private final List<BakedSkinPart> skinParts;
    private final ColorDescriptor colorDescriptor;
    private final SkinUsedCounter usedCounter;
    private final ColorScheme colorScheme;
    private final BakedItemModel resolvedItemModel;
    private final HashMap<Integer, ColorScheme> resolvedColorSchemes = new HashMap();

    public BakedSkin(String identifier, ISkinType skinType, ArrayList<BakedSkinPart> bakedParts, Skin skin, ColorScheme colorScheme, ColorDescriptor colorDescriptor, SkinUsedCounter usedCounter) {
        this.identifier = identifier;
        this.skin = skin;
        this.skinType = skinType;
        this.skinParts = bakedParts;
        this.colorScheme = colorScheme;
        this.colorDescriptor = colorDescriptor;
        this.usedCounter = usedCounter;
        this.useTickRange = this.getUseTickRange(bakedParts);
        this.resolvedItemModel = this.resolveItemModel(skin.getItemTransforms());
        this.loadBlockBounds();
    }

    public ColorScheme resolve(Entity entity, ColorScheme scheme) {
        if (this.colorDescriptor.isEmpty()) {
            return ColorScheme.EMPTY;
        }
        ColorScheme resolvedColorScheme = this.resolvedColorSchemes.computeIfAbsent(entity.func_145782_y(), k -> this.colorScheme.copy());
        if (entity.func_145782_y() != -1021) {
            ResourceLocation resolvedTexture = PlayerTextureLoader.getInstance().getTextureLocation(entity);
            if (!Objects.equals(resolvedColorScheme.getTexture(), resolvedTexture)) {
                resolvedColorScheme.setTexture(resolvedTexture);
            }
        }
        resolvedColorScheme.setReference(scheme);
        return resolvedColorScheme;
    }

    public int getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public ISkinType getType() {
        return this.skinType;
    }

    public List<BakedSkinPart> getSkinParts() {
        return this.skinParts;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public ColorDescriptor getColorDescriptor() {
        return this.colorDescriptor;
    }

    @Nullable
    public BakedItemModel getItemModel() {
        return this.resolvedItemModel;
    }

    public SkinUsedCounter getUsedCounter() {
        return this.usedCounter;
    }

    public HashMap<BlockPos, Rectangle3i> getBlockBounds() {
        return this.cachedBlockBounds;
    }

    public Rectangle3f getRenderBounds(@Nullable Entity entity, @Nullable Model model, SkinItemSource itemSource) {
        if (entity == null) {
            entity = SkinItemRenderer.getInstance().getMannequinEntity();
        }
        if (model == null) {
            model = SkinItemRenderer.getInstance().getMannequinModel();
        }
        Vector3f rotation = itemSource.getRotation();
        Object key = SkinCache.borrowKey(model, rotation);
        Rectangle3f bounds = this.cachedBounds.get(key);
        if (bounds != null) {
            SkinCache.returnKey(key);
            return bounds;
        }
        OpenMatrix4f matrix = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
        OpenVoxelShape shape = this.getRenderShape((Entity)entity, (Model)model, itemSource);
        if (rotation != null) {
            matrix.rotate(new OpenQuaternionf(rotation.getX(), rotation.getY(), rotation.getZ(), true));
            shape.mul(matrix);
        }
        bounds = shape.bounds().copy();
        if (rotation != null) {
            Vector4f center = new Vector4f(bounds.getCenter());
            matrix.invert();
            center.transform(matrix);
            bounds.setX(center.x() - bounds.getWidth() / 2.0f);
            bounds.setY(center.y() - bounds.getHeight() / 2.0f);
            bounds.setZ(center.z() - bounds.getDepth() / 2.0f);
        }
        this.cachedBounds.put(key, bounds);
        return bounds;
    }

    public OpenVoxelShape getRenderShape(Entity entity, Model model, SkinItemSource itemSource) {
        SkinRenderer<Entity, IModel> renderer = SkinRendererManager.getInstance().getRenderer(entity, model, null);
        if (renderer != null) {
            return this.getRenderShape((T)entity, (M)ModelHolder.ofNullable(model), itemSource, renderer);
        }
        return OpenVoxelShape.empty();
    }

    public <T extends Entity, M extends IModel> OpenVoxelShape getRenderShape(T entity, M model, SkinItemSource itemSource, SkinRenderer<T, M> renderer) {
        SkinRenderContext context = new SkinRenderContext(new MatrixStack());
        context.setReferenced(itemSource);
        context.setTransformType(itemSource.getTransformType());
        context.setTransforms(entity, model);
        OpenVoxelShape shape = OpenVoxelShape.empty();
        for (BakedSkinPart bakedPart : this.skinParts) {
            this.addRenderShape(shape, entity, model, bakedPart, renderer, context);
        }
        return shape;
    }

    private <T extends Entity, M extends IModel> void addRenderShape(OpenVoxelShape shape, T entity, M model, BakedSkinPart part, SkinRenderer<T, M> renderer, SkinRenderContext context) {
        if (!renderer.prepare(entity, model, part, this, context)) {
            return;
        }
        OpenVoxelShape shape1 = part.getRenderShape().copy();
        context.pushPose();
        renderer.apply(entity, model, part, this, context);
        shape1.mul(context.pose().lastPose());
        shape.add(shape1);
        for (BakedSkinPart childPart : part.getChildren()) {
            this.addRenderShape(shape, entity, model, childPart, renderer, context);
        }
        context.popPose();
    }

    public <T extends Entity, V extends Model, M extends IModel> boolean shouldRenderPart(T entity, M model, BakedSkinPart bakedPart, SkinRenderContext context) {
        ISkinPartType partType = bakedPart.getType();
        if (partType == SkinPartTypes.ITEM_ARROW) {
            if (this.isArrowEntity(entity)) {
                return true;
            }
            if (context.getTransformType() == AbstractItemTransformType.NONE) {
                return this.skinParts.size() == 1;
            }
            return false;
        }
        if (this.isArrowEntity(entity)) {
            return false;
        }
        if (partType instanceof ICanUse && entity instanceof LivingEntity) {
            int useTick = this.getUseTick((LivingEntity)entity, context.getReferenced().getItem());
            Range<Integer> useRange = ((ICanUse)((Object)partType)).getUseRange();
            return useRange.contains((Comparable)Integer.valueOf(MathUtils.clamp(useTick, (Integer)this.useTickRange.lowerEndpoint(), (Integer)this.useTickRange.upperEndpoint())));
        }
        return true;
    }

    private boolean isArrowEntity(Entity entity) {
        if (entity instanceof TridentEntity) {
            return false;
        }
        return entity instanceof AbstractArrowEntity;
    }

    private void loadBlockBounds() {
        if (this.skinType != SkinTypes.BLOCK) {
            return;
        }
        for (BakedSkinPart skinPart : this.skinParts) {
            HashMap<BlockPos, Rectangle3i> bm = skinPart.getPart().getBlockBounds();
            if (bm == null) continue;
            this.cachedBlockBounds.putAll(bm);
        }
    }

    private int getUseTick(LivingEntity entity, ItemStack itemStack) {
        if (entity.func_184607_cu() == itemStack) {
            return entity.func_184612_cw();
        }
        if (CrossbowItem.func_220012_d((ItemStack)itemStack)) {
            return 100;
        }
        return 0;
    }

    private Range<Integer> getUseTickRange(ArrayList<BakedSkinPart> bakedParts) {
        int count = 0;
        int maxUseTick = Integer.MIN_VALUE;
        int minUseTick = Integer.MAX_VALUE;
        for (BakedSkinPart bakedPart : bakedParts) {
            ISkinPartType partType = bakedPart.getType();
            if (!(partType instanceof ICanUse)) continue;
            Range<Integer> range = ((ICanUse)((Object)partType)).getUseRange();
            maxUseTick = Math.max(maxUseTick, (Integer)range.upperEndpoint());
            minUseTick = Math.min(minUseTick, (Integer)range.lowerEndpoint());
            ++count;
        }
        if (count == 0) {
            return Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
        }
        return Range.closed((Comparable)Integer.valueOf(minUseTick), (Comparable)Integer.valueOf(maxUseTick));
    }

    private BakedItemModel resolveItemModel(SkinItemTransforms oldValue) {
        if (oldValue != null) {
            return new BakedItemModel(oldValue, false);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BakedSkin bakedSkin = (BakedSkin)o;
        return this.identifier.equals(bakedSkin.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

