/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.blockentity;

import com.google.common.collect.ImmutableMap;
import extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import java.util.Collection;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.client.IBlockEntityExtendedRenderer;
import moe.plushie.armourers_workshop.core.block.SkinnableBlock;
import moe.plushie.armourers_workshop.core.blockentity.RotableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3d;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class SkinnableBlockEntity
extends RotableContainerBlockEntity
implements IBlockEntityExtendedRenderer {
    private static final BlockPos INVALID = BlockPos.func_218283_e((long)-1L);
    private static final ImmutableMap<?, Vector3f> FACING_TO_ROT = new ImmutableMap.Builder().put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.EAST), (Object)new Vector3f(180.0f, 270.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.NORTH), (Object)new Vector3f(180.0f, 180.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.WEST), (Object)new Vector3f(180.0f, 90.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.SOUTH), (Object)new Vector3f(180.0f, 0.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.EAST), (Object)new Vector3f(0.0f, 270.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.SOUTH), (Object)new Vector3f(0.0f, 180.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.WEST), (Object)new Vector3f(0.0f, 90.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.NORTH), (Object)new Vector3f(0.0f, 0.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.EAST), (Object)new Vector3f(0.0f, 270.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.SOUTH), (Object)new Vector3f(0.0f, 180.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.WEST), (Object)new Vector3f(0.0f, 90.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.NORTH), (Object)new Vector3f(0.0f, 0.0f, 0.0f)).build();
    private BlockPos refer = INVALID;
    private Rectangle3i shape = Rectangle3i.ZERO;
    private NonNullList<ItemStack> items;
    private Collection<BlockPos> refers;
    private Collection<SkinMarker> markers;
    private BlockPos linkedBlockPos = null;
    private SkinProperties properties;
    private SkinDescriptor descriptor = SkinDescriptor.EMPTY;
    private OpenQuaternionf renderRotations;
    private AxisAlignedBB renderBoundingBox;
    private VoxelShape renderVoxelShape = null;
    private ItemStack droppedStack = null;
    private boolean isParent = false;

    public SkinnableBlockEntity(TileEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public static Vector3f getRotations(BlockState state) {
        AttachFace face = state.func_235903_d_((Property)SkinnableBlock.FACE).orElse(AttachFace.FLOOR);
        Direction facing = state.func_235903_d_((Property)SkinnableBlock.field_185512_D).orElse(Direction.NORTH);
        return (Vector3f)FACING_TO_ROT.getOrDefault((Object)Pair.of((Object)face, (Object)facing), (Object)Vector3f.ZERO);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        this.refer = OptionalAPI.getOptionalBlockPos(tag, "Refer", INVALID);
        this.shape = OptionalAPI.getOptionalRectangle3i(tag, "Shape", Rectangle3i.ZERO);
        this.renderVoxelShape = null;
        this.isParent = BlockPos.field_177992_a.equals((Object)this.refer);
        if (!this.isParent()) {
            return;
        }
        SkinProperties oldProperties = this.properties;
        this.refers = OptionalAPI.getOptionalBlockPosArray(tag, "Refers");
        this.markers = OptionalAPI.getOptionalSkinMarkerArray(tag, "Markers");
        this.descriptor = OptionalAPI.getOptionalSkinDescriptor(tag, "Skin");
        this.properties = OptionalAPI.getOptionalSkinProperties(tag, "SkinProperties");
        this.linkedBlockPos = OptionalAPI.getOptionalBlockPos(tag, "LinkedPos", null);
        if (oldProperties != null) {
            oldProperties.clear();
            oldProperties.putAll(this.properties);
            this.properties = oldProperties;
        }
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.getOrCreateItems());
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        OptionalAPI.putOptionalBlockPos(tag, "Refer", this.refer, INVALID);
        OptionalAPI.putOptionalRectangle3i(tag, "Shape", this.shape, Rectangle3i.ZERO);
        if (!this.isParent()) {
            return;
        }
        OptionalAPI.putOptionalBlockPosArray(tag, "Refers", this.refers);
        OptionalAPI.putOptionalSkinMarkerArray(tag, "Markers", this.markers);
        OptionalAPI.putOptionalSkinDescriptor(tag, "Skin", this.descriptor);
        OptionalAPI.putOptionalSkinProperties(tag, "SkinProperties", this.properties);
        OptionalAPI.putOptionalBlockPos(tag, "LinkedPos", this.linkedBlockPos, null);
        ItemStackHelper.func_191282_a((CompoundNBT)tag, this.getOrCreateItems());
    }

    public void updateBlockStates() {
        this.func_70296_d();
        World level = this.func_145831_w();
        if (level != null && !level.func_201670_d()) {
            level.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public SkinDescriptor getDescriptor() {
        if (this.isParent()) {
            return this.descriptor;
        }
        return SkinDescriptor.EMPTY;
    }

    public void setDescriptor(SkinDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public VoxelShape getShape() {
        if (this.renderVoxelShape != null) {
            return this.renderVoxelShape;
        }
        if (this.shape.equals(Rectangle3i.ZERO)) {
            this.renderVoxelShape = VoxelShapes.func_197868_b();
            return this.renderVoxelShape;
        }
        float minX = (float)this.shape.getMinX() / 16.0f + 0.5f;
        float minY = (float)this.shape.getMinY() / 16.0f + 0.5f;
        float minZ = (float)this.shape.getMinZ() / 16.0f + 0.5f;
        float maxX = (float)this.shape.getMaxX() / 16.0f + 0.5f;
        float maxY = (float)this.shape.getMaxY() / 16.0f + 0.5f;
        float maxZ = (float)this.shape.getMaxZ() / 16.0f + 0.5f;
        this.renderVoxelShape = VoxelShapes.func_197873_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        return this.renderVoxelShape;
    }

    public void setShape(Rectangle3i shape) {
        this.shape = shape;
        this.renderVoxelShape = null;
    }

    public BlockPos getLinkedBlockPos() {
        return this.getValueFromParent(te -> te.linkedBlockPos);
    }

    public void setLinkedBlockPos(BlockPos linkedBlockPos) {
        SkinnableBlockEntity blockEntity = this.getParent();
        if (blockEntity != null) {
            blockEntity.linkedBlockPos = linkedBlockPos;
            blockEntity.updateBlockStates();
        }
    }

    public void kill() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public OpenQuaternionf getRenderRotations(BlockState blockState) {
        if (this.renderRotations != null) {
            return this.renderRotations;
        }
        Vector3f r = SkinnableBlockEntity.getRotations(blockState);
        this.renderRotations = new OpenQuaternionf(r.getX(), r.getY(), r.getZ(), true);
        return this.renderRotations;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.getOrCreateItems();
    }

    public int func_70302_i_() {
        return 81;
    }

    @Nullable
    public String getInventoryName() {
        return this.getProperty(SkinProperty.ALL_CUSTOM_NAME);
    }

    @Override
    @Nullable
    public IInventory getInventory() {
        return this.getParent();
    }

    public Collection<BlockPos> getRefers() {
        if (this.refers == null) {
            this.refers = this.getValueFromParent(te -> te.refers);
        }
        return this.refers;
    }

    public BlockPos getParentPos() {
        return this.func_174877_v().func_177973_b((Vector3i)this.refer);
    }

    public Vector3d getSeatPos() {
        float dx = 0.0f;
        float dy = 0.0f;
        float dz = 0.0f;
        BlockPos parentPos = this.getParentPos();
        Collection<SkinMarker> markers = this.getMarkers();
        if (markers != null && !markers.isEmpty()) {
            SkinMarker marker = markers.iterator().next();
            dx = (float)marker.x / 16.0f;
            dy = (float)marker.y / 16.0f;
            dz = (float)marker.z / 16.0f;
        }
        return new Vector3d((float)parentPos.func_177958_n() + dx, (float)parentPos.func_177956_o() + dy, (float)parentPos.func_177952_p() + dz);
    }

    public BlockPos getBedPos() {
        BlockPos parentPos = this.getParentPos();
        Collection<SkinMarker> markers = this.getMarkers();
        if (markers == null || markers.isEmpty()) {
            Direction facing = this.func_195044_w().func_235903_d_((Property)SkinnableBlock.field_185512_D).orElse(Direction.NORTH);
            return parentPos.func_177972_a(Rotation.CLOCKWISE_180.func_185831_a(facing));
        }
        SkinMarker marker = markers.iterator().next();
        return parentPos.func_177982_a(marker.x / 16, marker.y / 16, marker.z / 16);
    }

    public Collection<SkinMarker> getMarkers() {
        if (this.markers == null) {
            this.markers = this.getValueFromParent(te -> te.markers);
        }
        return this.markers;
    }

    @Nullable
    public SkinProperties getProperties() {
        if (this.properties == null) {
            this.properties = this.getValueFromParent(te -> te.properties);
        }
        return this.properties;
    }

    @Nullable
    public SkinnableBlockEntity getParent() {
        if (this.isParent()) {
            return this;
        }
        if (this.func_145831_w() != null && this.refer != INVALID) {
            return ObjectUtils.safeCast(this.func_145831_w().func_175625_s(this.getParentPos()), SkinnableBlockEntity.class);
        }
        return null;
    }

    public void setDropped(ItemStack itemStack) {
        this.droppedStack = itemStack;
    }

    public ItemStack getDropped() {
        return this.droppedStack;
    }

    public boolean isDropped() {
        return this.droppedStack != null;
    }

    public boolean isLadder() {
        return this.getProperty(SkinProperty.BLOCK_LADDER);
    }

    public boolean isGrowing() {
        return this.getProperty(SkinProperty.BLOCK_GLOWING);
    }

    public boolean isSeat() {
        return this.getProperty(SkinProperty.BLOCK_SEAT);
    }

    public boolean isBed() {
        return this.getProperty(SkinProperty.BLOCK_BED);
    }

    public boolean isLinked() {
        return this.getLinkedBlockPos() != null;
    }

    public boolean isInventory() {
        return this.getProperty(SkinProperty.BLOCK_INVENTORY) != false || this.isEnderInventory();
    }

    public boolean isEnderInventory() {
        return this.getProperty(SkinProperty.BLOCK_ENDER_INVENTORY);
    }

    public boolean isParent() {
        return this.isParent;
    }

    public boolean noCollision() {
        return this.getProperty(SkinProperty.BLOCK_NO_COLLISION);
    }

    public int getInventoryWidth() {
        return this.getProperty(SkinProperty.BLOCK_INVENTORY_WIDTH);
    }

    public int getInventoryHeight() {
        return this.getProperty(SkinProperty.BLOCK_INVENTORY_HEIGHT);
    }

    @Override
    public boolean shouldUseExtendedRenderer() {
        return this.isParent;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Rectangle3f getRenderBoundingBox(BlockState blockState) {
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(this.getDescriptor(), Tickets.TEST);
        if (bakedSkin == null) {
            return null;
        }
        float f = 0.0625f;
        Rectangle3f box = bakedSkin.getRenderBounds(null, null, SkinItemSource.EMPTY).copy();
        box.mul(OpenMatrix4f.createScaleMatrix(-f, -f, f));
        return box;
    }

    private NonNullList<ItemStack> getOrCreateItems() {
        if (this.items == null) {
            this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        }
        return this.items;
    }

    @Nullable
    private <V> V getValueFromParent(Function<SkinnableBlockEntity, V> getter) {
        SkinnableBlockEntity blockEntity = this.getParent();
        if (blockEntity != null) {
            return getter.apply(blockEntity);
        }
        return null;
    }

    private <V> V getProperty(SkinProperty<V> property) {
        SkinProperties properties = this.getProperties();
        if (properties != null) {
            return properties.get(property);
        }
        return property.getDefaultValue();
    }
}

