/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.blockentity;

import moe.plushie.armourers_workshop.api.common.IBlockEntityHandler;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableContainerBlockEntity;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector3d;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class RotableContainerBlockEntity
extends UpdatableContainerBlockEntity
implements IBlockEntityHandler {
    public static final AxisAlignedBB ZERO_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private AxisAlignedBB renderBoundingBox;

    public RotableContainerBlockEntity(TileEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void setRenderChanged() {
        this.renderBoundingBox = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public OpenQuaternionf getRenderRotations(BlockState blockState) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rectangle3f getRenderBoundingBox(BlockState blockState) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getCustomRenderBoundingBox(BlockState blockState) {
        if (this.renderBoundingBox != null) {
            return this.renderBoundingBox;
        }
        Rectangle3f rect = this.getRenderBoundingBox(blockState);
        if (rect == null) {
            return ZERO_BOX;
        }
        OpenQuaternionf quaternion = this.getRenderRotations(blockState);
        if (quaternion != null) {
            rect.mul(quaternion);
        }
        this.renderBoundingBox = rect.offset(Vector3d.atCenterOf(this.func_174877_v())).asAABB();
        return this.renderBoundingBox;
    }
}

