/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.util.ResourceLocation;

public class AbstractForgeRegistryEntry<T>
implements IRegistryKey<T> {
    private final Supplier<T> value;
    private final ResourceLocation registryName;

    public AbstractForgeRegistryEntry(ResourceLocation registryName, Supplier<T> value) {
        this.value = value;
        this.registryName = registryName;
    }

    public static <T> AbstractForgeRegistryEntry<T> of(ResourceLocation registryName, Supplier<T> value) {
        return new AbstractForgeRegistryEntry<T>(registryName, value);
    }

    public static <T extends S, S> AbstractForgeRegistryEntry<T> cast(ResourceLocation registryName, Supplier<S> value) {
        Supplier targetValue = (Supplier)ObjectUtils.unsafeCast(value);
        return new AbstractForgeRegistryEntry<T>(registryName, targetValue);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Override
    public T get() {
        return this.value.get();
    }
}

