/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.storage.WorldSavedData;

public abstract class AbstractSavedData {
    private boolean dirty;
    private Consumer<Boolean> dirtyImpl;

    final void init(Consumer<Boolean> dirtyImpl) {
        this.dirtyImpl = dirtyImpl;
        if (this.dirty) {
            this.setDirty(true);
        }
    }

    public void setDirty() {
        this.setDirty(true);
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        if (this.dirtyImpl != null) {
            this.dirtyImpl.accept(bl);
        }
    }

    public abstract void load(CompoundNBT var1);

    public abstract CompoundNBT save(CompoundNBT var1);

    public static class Storage<T extends AbstractSavedData>
    extends WorldSavedData {
        private final T value;

        public Storage(Supplier<T> provider, String name) {
            super(name);
            this.value = (AbstractSavedData)provider.get();
            ((AbstractSavedData)this.value).init(arg_0 -> ((Storage)this).func_76186_a(arg_0));
        }

        public void func_76184_a(CompoundNBT tag) {
            ((AbstractSavedData)this.value).load(tag);
        }

        public CompoundNBT func_189551_b(CompoundNBT tag) {
            return ((AbstractSavedData)this.value).save(tag);
        }

        public T get() {
            return this.value;
        }
    }
}

