/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import moe.plushie.armourers_workshop.api.common.ILootContext;
import moe.plushie.armourers_workshop.api.common.ILootContextParam;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.util.math.vector.Vector3d;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHorizontalBlockImpl
extends HorizontalBlock {
    public AbstractHorizontalBlockImpl(AbstractBlock.Properties properties) {
        super(properties);
    }

    public final List<ItemStack> func_220076_a(BlockState blockState, LootContext.Builder builder) {
        return this.getDrops(blockState, new LootContextBuilder(builder));
    }

    public List<ItemStack> getDrops(BlockState blockState, ILootContext context) {
        return super.func_220076_a(blockState, ((LootContextBuilder)context).builder);
    }

    public static class LootContextBuilder
    implements ILootContext {
        private static final ImmutableMap<ILootContextParam<?>, LootParameter<?>> KEYS = ImmutableMap.builder().put(ILootContextParam.THIS_ENTITY, (Object)LootParameters.field_216281_a).put(ILootContextParam.LAST_DAMAGE_PLAYER, (Object)LootParameters.field_216282_b).put(ILootContextParam.DAMAGE_SOURCE, (Object)LootParameters.field_216283_c).put(ILootContextParam.KILLER_ENTITY, (Object)LootParameters.field_216284_d).put(ILootContextParam.DIRECT_KILLER_ENTITY, (Object)LootParameters.field_216285_e).put(ILootContextParam.ORIGIN, (Object)LootParameters.field_237457_g_).put(ILootContextParam.BLOCK_STATE, (Object)LootParameters.field_216287_g).put(ILootContextParam.BLOCK_ENTITY, (Object)LootParameters.field_216288_h).put(ILootContextParam.TOOL, (Object)LootParameters.field_216289_i).put(ILootContextParam.EXPLOSION_RADIUS, (Object)LootParameters.field_216290_j).build();
        private final LootContext.Builder builder;

        public LootContextBuilder(LootContext.Builder builder) {
            this.builder = builder;
        }

        @Override
        public <T> T getParameter(ILootContextParam<T> param) {
            Object value = this.builder.func_216024_a((LootParameter)KEYS.get(param));
            return param.getValueClass().cast(this.convert(value));
        }

        @Override
        @Nullable
        public <T> T getOptionalParameter(ILootContextParam<T> param) {
            Object value = this.builder.func_216019_b((LootParameter)KEYS.get(param));
            if (value != null) {
                return param.getValueClass().cast(this.convert(value));
            }
            return null;
        }

        private Object convert(Object value) {
            Vector3d pos = ObjectUtils.safeCast(value, Vector3d.class);
            if (pos != null) {
                return new Vector3f((float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c);
            }
            return value;
        }
    }
}

