/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility;

import com.mojang.blaze3d.matrix.MatrixStack;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.compatibility.AbstractLightBufferObject;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderObject;
import moe.plushie.armourers_workshop.core.client.other.VertexIndexBuffer;
import moe.plushie.armourers_workshop.core.client.shader.Shader;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexGroup;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.math.OpenPoseStack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractShader
extends Shader {
    private int lastMaxVertexCount = 0;

    @Override
    public void begin() {
        super.begin();
        RenderSystem.enableRescaleNormal();
    }

    @Override
    public void end() {
        RenderSystem.disableRescaleNormal();
        SkinRenderObject.unbind();
        super.end();
    }

    @Override
    public void apply(ShaderVertexGroup group, Runnable action) {
        this.lastMaxVertexCount = group.maxVertexCount;
        group.getRenderType().func_228547_a_();
        action.run();
        group.getRenderType().func_228549_b_();
    }

    @Override
    public void render(ShaderVertexObject object) {
        VertexFormat vertexFormat = object.getFormat();
        AbstractLightBufferObject lightBuffer = null;
        if (!object.isGrowing()) {
            lightBuffer = AbstractLightBufferObject.getLightBuffer(object.getLightmap());
            lightBuffer.ensureCapacity(this.lastMaxVertexCount);
            lightBuffer.bind();
            lightBuffer.getFormat().func_227892_a_(0L);
        }
        object.getVertexBuffer().bind();
        vertexFormat.func_227892_a_((long)object.getVertexOffset());
        this.setupPolygonState(object);
        OpenPoseStack poseStack = object.getPoseStack();
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)ABI.convertMatrix(MatrixStack.class, poseStack.lastPose()));
        RenderSystem.drawArrays((int)object.getType().func_228664_q_(), (int)0, (int)object.getVertexCount());
        RenderSystem.popMatrix();
        this.cleanPolygonState(object);
        vertexFormat.func_227895_d_();
        if (lightBuffer != null) {
            lightBuffer.getFormat().func_227895_d_();
        }
    }

    @Override
    protected void draw(RenderType renderType, VertexIndexBuffer.IndexType indexType, int count, int indices) {
        throw new AssertionError();
    }
}

