/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.ArrayList;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.math.IRectangle3i;
import moe.plushie.armourers_workshop.api.math.ITexturePos;
import moe.plushie.armourers_workshop.api.math.IVector3i;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.api.skin.ISkinCube;
import moe.plushie.armourers_workshop.api.skin.ISkinCubeType;
import moe.plushie.armourers_workshop.api.skin.ISkinMarker;
import moe.plushie.armourers_workshop.api.skin.ISkinPart;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.builder.block.SkinCubeBlock;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeReplacingEvent;
import moe.plushie.armourers_workshop.builder.other.CubeTransform;
import moe.plushie.armourers_workshop.builder.other.CubeWrapper;
import moe.plushie.armourers_workshop.core.data.OptionalDirection;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubeTypes;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.cube.impl.SkinCubesV0;
import moe.plushie.armourers_workshop.core.skin.exception.SkinSaveException;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.TexturePos;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import moe.plushie.armourers_workshop.utils.texture.SkinPaintData;
import moe.plushie.armourers_workshop.utils.texture.SkyBox;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class WorldUtils {
    public static Skin saveSkinFromWorld(World level, CubeTransform transform, SkinProperties skinProps, ISkinType skinType, SkinPaintData paintData) throws SkinSaveException {
        SkinPart testPart;
        ArrayList<SkinPart> parts = new ArrayList<SkinPart>();
        if (skinType == SkinTypes.BLOCK) {
            SkinPart skinPart;
            Object partType = SkinPartTypes.BLOCK;
            if (skinProps.get(SkinProperty.BLOCK_MULTIBLOCK).booleanValue()) {
                partType = SkinPartTypes.BLOCK_MULTI;
            }
            if ((skinPart = WorldUtils.saveArmourPart(level, transform, (ISkinPartType)partType, true)) != null) {
                parts.add(skinPart);
            }
        } else {
            for (ISkinPartType iSkinPartType : skinType.getParts()) {
                SkinPart skinPart = WorldUtils.saveArmourPart(level, transform, iSkinPartType, true);
                if (skinPart == null) continue;
                parts.add(skinPart);
            }
        }
        if (paintData != null) {
            SkinPaintData resolvedPaintData = SkinPaintData.v1();
            resolvedPaintData.copyFrom(paintData);
            paintData = resolvedPaintData;
        }
        Skin.Builder builder = new Skin.Builder(skinType);
        builder.properties(skinProps);
        builder.paintData(paintData);
        builder.parts(parts);
        Skin skin = builder.build();
        if (skin.getParts().size() == 0 && skin.getPaintData() == null) {
            throw SkinSaveException.Type.NO_DATA.build("noting", new Object[0]);
        }
        for (ISkinPartType iSkinPartType : skinType.getParts()) {
            if (!iSkinPartType.isPartRequired()) continue;
            boolean havePart = false;
            for (ISkinPart iSkinPart : skin.getParts()) {
                if (iSkinPartType != iSkinPart.getType()) continue;
                havePart = true;
                break;
            }
            if (havePart) continue;
            throw SkinSaveException.Type.MISSING_PARTS.build("missingPart", TranslateUtils.Name.of(iSkinPartType));
        }
        if (skinProps.get(SkinProperty.BLOCK_BED).booleanValue() && skinProps.get(SkinProperty.BLOCK_SEAT).booleanValue()) {
            throw SkinSaveException.Type.BED_AND_SEAT.build("conflictBedSeat", new Object[0]);
        }
        if (skinType == SkinTypes.BLOCK && skinProps.get(SkinProperty.BLOCK_MULTIBLOCK).booleanValue() && (testPart = WorldUtils.saveArmourPart(level, transform, SkinPartTypes.BLOCK, true)) == null) {
            throw SkinSaveException.Type.INVALID_MULTIBLOCK.build("missingMainBlock", new Object[0]);
        }
        return skin;
    }

    private static SkinPart saveArmourPart(World level, CubeTransform transform, ISkinPartType partType, boolean markerCheck) throws SkinSaveException {
        int cubeCount = WorldUtils.getNumberOfCubesInPart(level, transform, partType);
        if (cubeCount < 1) {
            return null;
        }
        SkinCubesV0 cubeData = new SkinCubesV0(cubeCount);
        ArrayList<SkinMarker> markerBlocks = new ArrayList<SkinMarker>();
        IRectangle3i buildSpace = partType.getBuildingSpace();
        IVector3i offset = partType.getOffset();
        int i = 0;
        for (int ix = 0; ix < buildSpace.getWidth(); ++ix) {
            for (int iy = 0; iy < buildSpace.getHeight(); ++iy) {
                for (int iz = 0; iz < buildSpace.getDepth(); ++iz) {
                    BlockPos target = transform.mul(ix + -offset.getX() + buildSpace.getX(), iy + -offset.getY(), iz + offset.getZ() + buildSpace.getZ());
                    int xOrigin = -ix + -buildSpace.getX();
                    int yOrigin = -iy + -buildSpace.getY();
                    int zOrigin = -iz + -buildSpace.getZ();
                    BlockState targetState = level.func_180495_p(target);
                    if (!(targetState.func_177230_c() instanceof SkinCubeBlock)) continue;
                    WorldUtils.saveArmourBlockToList(level, transform, target, xOrigin - 1, yOrigin - 1, -zOrigin, cubeData.getCube(i), markerBlocks);
                    ++i;
                }
            }
        }
        if (markerCheck) {
            if (partType.getMinimumMarkersNeeded() > markerBlocks.size()) {
                throw SkinSaveException.Type.MARKER_ERROR.build("missingMarker", TranslateUtils.Name.of(partType));
            }
            if (markerBlocks.size() > partType.getMaximumMarkersNeeded()) {
                throw SkinSaveException.Type.MARKER_ERROR.build("tooManyMarkers", TranslateUtils.Name.of(partType));
            }
        }
        SkinPart.Builder builder = new SkinPart.Builder(partType);
        builder.cubes(cubeData);
        builder.markers(markerBlocks);
        return builder.build();
    }

    private static void saveArmourBlockToList(World level, CubeTransform transform, BlockPos pos, int ix, int iy, int iz, SkinCube cube, ArrayList<SkinMarker> markerBlocks) {
        TileEntity blockEntity = level.func_175625_s(pos);
        if (!(blockEntity instanceof IPaintable)) {
            return;
        }
        IPaintable target = (IPaintable)blockEntity;
        BlockState blockState = blockEntity.func_195044_w();
        OptionalDirection marker = SkinCubeBlock.getMarker(blockState);
        cube.setType(SkinCubeTypes.byBlock(blockState.func_177230_c()));
        cube.setPosition(new Vector3i(ix, iy, iz));
        for (Direction dir : Direction.values()) {
            IPaintColor paintColor = target.getColor(dir);
            Direction resolvedDir = transform.invRotate(dir);
            cube.setPaintColor(resolvedDir, paintColor);
        }
        if (marker != OptionalDirection.NONE) {
            OptionalDirection resolvedMarker = OptionalDirection.of(transform.invRotate(marker.getDirection()));
            markerBlocks.add(new SkinMarker((byte)ix, (byte)iy, (byte)iz, (byte)resolvedMarker.ordinal()));
        }
    }

    public static void loadSkinIntoWorld(CubeChangesCollector collector, CubeTransform transform, Skin skin) {
        for (SkinPart part : skin.getParts()) {
            WorldUtils.loadSkinPartIntoWorld(collector, transform, part, false);
        }
    }

    private static void loadSkinPartIntoWorld(CubeChangesCollector collector, CubeTransform transform, SkinPart partData, boolean mirror) {
        ISkinPartType skinPart = partData.getType();
        IRectangle3i buildSpace = skinPart.getBuildingSpace();
        IVector3i offset = skinPart.getOffset();
        SkinCubes cubeData = partData.getCubeData();
        for (int i = 0; i < cubeData.getCubeTotal(); ++i) {
            ISkinCube cube = cubeData.getCube(i);
            IVector3i cubePos = cube.getPosition();
            ISkinCubeType blockData = cube.getType();
            OptionalDirection markerFacing = OptionalDirection.NONE;
            for (ISkinMarker iSkinMarker : partData.getMarkers()) {
                if (!cubePos.equals(iSkinMarker.getPosition())) continue;
                Direction resolvedMarker = WorldUtils.getResolvedDirection(iSkinMarker.getDirection(), mirror);
                markerFacing = OptionalDirection.of(transform.rotate(resolvedMarker));
                break;
            }
            BlockPos origin = new BlockPos(-offset.getX(), -offset.getY() + -buildSpace.getY(), offset.getZ());
            WorldUtils.loadSkinBlockIntoWorld(collector, transform, origin, blockData, cubePos, markerFacing, cube, mirror);
        }
    }

    private static void loadSkinBlockIntoWorld(CubeChangesCollector collector, CubeTransform transform, BlockPos origin, ISkinCubeType blockData, IVector3i cubePos, OptionalDirection markerFacing, ISkinCube cube, boolean mirror) {
        BlockPos target;
        CubeWrapper targetCube;
        int shiftX = -cubePos.getX() - 1;
        int shiftY = cubePos.getY() + 1;
        int shiftZ = cubePos.getZ();
        if (mirror) {
            shiftX = cubePos.getX();
        }
        if ((targetCube = collector.getCube(target = transform.mul(shiftX + origin.func_177958_n(), origin.func_177956_o() - shiftY, shiftZ + origin.func_177952_p()))).is((Block)ModBlocks.BOUNDING_BOX.get())) {
            targetCube.setBlockStateAndTag(Blocks.field_150350_a.func_176223_P(), null);
        }
        Block targetBlock = blockData.getBlock();
        BlockState targetState = SkinCubeBlock.setMarker(targetBlock.func_176223_P(), markerFacing);
        HashMap<Direction, IPaintColor> colors = new HashMap<Direction, IPaintColor>();
        for (Direction dir : Direction.values()) {
            IPaintColor paintColor = cube.getPaintColor(dir);
            Direction resolvedDir = WorldUtils.getResolvedDirection(dir, mirror);
            colors.put(transform.rotate(resolvedDir), paintColor);
        }
        targetCube.setBlockStateAndColors(targetState, colors);
    }

    public static void copyPaintData(SkinPaintData paintData, SkyBox srcBox, SkyBox destBox, boolean isMirrorX) {
        int srcX = srcBox.getBounds().getX();
        int srcY = srcBox.getBounds().getY();
        int srcZ = srcBox.getBounds().getZ();
        int destX = destBox.getBounds().getX();
        int destY = destBox.getBounds().getY();
        int destZ = destBox.getBounds().getZ();
        int destWidth = destBox.getBounds().getWidth();
        HashMap<ITexturePos, Integer> colors = new HashMap<ITexturePos, Integer>();
        srcBox.forEach((texture, x, y, z, dir) -> {
            TexturePos newTexture;
            int ix = x - srcX;
            int iy = y - srcY;
            int iz = z - srcZ;
            if (isMirrorX) {
                ix = destWidth - ix - 1;
                dir = WorldUtils.getResolvedDirection(dir, true);
            }
            if ((newTexture = destBox.get(ix + destX, iy + destY, iz + destZ, dir)) == null) {
                return;
            }
            int color = paintData.getColor(texture);
            if (PaintColor.isOpaque(color)) {
                colors.put(newTexture, color);
            }
        });
        colors.forEach(paintData::setColor);
    }

    public static void clearPaintData(SkinPaintData paintData, SkyBox srcBox) {
        srcBox.forEach((texturePos, x, y, z, dir) -> paintData.setColor(texturePos, 0));
    }

    public static void replaceCubes(CubeChangesCollector collector, CubeTransform transform, ISkinType skinType, SkinProperties skinProps, CubeReplacingEvent event) {
        for (ISkinPartType iSkinPartType : skinType.getParts()) {
            for (Vector3i offset : WorldUtils.getResolvedBuildingSpace2(iSkinPartType)) {
                WorldUtils.replaceCube(collector, transform.mul(offset), event);
            }
        }
    }

    public static void replaceCube(CubeChangesCollector collector, BlockPos pos, CubeReplacingEvent event) {
        CubeWrapper cube = collector.getCube(pos);
        if (event.accept(cube)) {
            event.apply(cube);
        }
    }

    public static void copyCubes(CubeChangesCollector collector, CubeTransform transform, ISkinType skinType, SkinProperties skinProps, ISkinPartType srcPart, ISkinPartType destPart, boolean mirror) throws SkinSaveException {
        SkinPart skinPart = WorldUtils.saveArmourPart(collector.getLevel(), transform, srcPart, false);
        if (skinPart != null) {
            skinPart.setSkinPart(destPart);
            WorldUtils.loadSkinPartIntoWorld(collector, transform, skinPart, mirror);
        }
    }

    public static int clearMarkers(CubeChangesCollector collector, CubeTransform transform, ISkinType skinType, SkinProperties skinProps, ISkinPartType partType) {
        int blockCount = 0;
        for (ISkinPartType iSkinPartType : skinType.getParts()) {
            if (partType != SkinPartTypes.UNKNOWN && partType != iSkinPartType) continue;
            if (skinType == SkinTypes.BLOCK) {
                boolean multiblock = skinProps.get(SkinProperty.BLOCK_MULTIBLOCK);
                if (iSkinPartType == SkinPartTypes.BLOCK && !multiblock) {
                    blockCount += WorldUtils.clearMarkersForSkinPart(collector, transform, iSkinPartType);
                }
                if (iSkinPartType != SkinPartTypes.BLOCK_MULTI || !multiblock) continue;
                blockCount += WorldUtils.clearMarkersForSkinPart(collector, transform, iSkinPartType);
                continue;
            }
            blockCount += WorldUtils.clearMarkersForSkinPart(collector, transform, iSkinPartType);
        }
        return blockCount;
    }

    private static int clearMarkersForSkinPart(CubeChangesCollector collector, CubeTransform transform, ISkinPartType skinPart) {
        int blockCount = 0;
        for (Vector3i offset : WorldUtils.getResolvedBuildingSpace2(skinPart)) {
            CubeWrapper cube = collector.getCube(transform.mul(offset));
            BlockState targetState = cube.getBlockState();
            if (!targetState.func_235901_b_((Property)SkinCubeBlock.MARKER) || SkinCubeBlock.getMarker(targetState) == OptionalDirection.NONE) continue;
            cube.setBlockState(SkinCubeBlock.setMarker(targetState, OptionalDirection.NONE));
            ++blockCount;
        }
        return blockCount;
    }

    public static int clearCubes(CubeChangesCollector collector, CubeTransform transform, ISkinType skinType, SkinProperties skinProps, ISkinPartType partType) {
        int blockCount = 0;
        for (ISkinPartType iSkinPartType : skinType.getParts()) {
            if (partType != SkinPartTypes.UNKNOWN && partType != iSkinPartType) continue;
            if (skinType == SkinTypes.BLOCK) {
                boolean multiblock = skinProps.get(SkinProperty.BLOCK_MULTIBLOCK);
                if (iSkinPartType == SkinPartTypes.BLOCK && !multiblock) {
                    blockCount += WorldUtils.clearEquipmentCubesForSkinPart(collector, transform, iSkinPartType);
                }
                if (iSkinPartType != SkinPartTypes.BLOCK_MULTI || !multiblock) continue;
                blockCount += WorldUtils.clearEquipmentCubesForSkinPart(collector, transform, iSkinPartType);
                continue;
            }
            blockCount += WorldUtils.clearEquipmentCubesForSkinPart(collector, transform, iSkinPartType);
        }
        return blockCount;
    }

    private static int clearEquipmentCubesForSkinPart(CubeChangesCollector collector, CubeTransform transform, ISkinPartType skinPart) {
        int blockCount = 0;
        for (Vector3i offset : WorldUtils.getResolvedBuildingSpace2(skinPart)) {
            CubeWrapper cube = collector.getCube(transform.mul(offset));
            if (!cube.is(SkinCubeBlock.class)) continue;
            cube.setBlockStateAndTag(Blocks.field_150350_a.func_176223_P(), null);
            ++blockCount;
        }
        return blockCount;
    }

    public static Rectangle3i getResolvedBuildingSpace(ISkinPartType skinPart) {
        IVector3i origin = skinPart.getOffset();
        IRectangle3i buildSpace = skinPart.getBuildingSpace();
        int dx = -origin.getX() + buildSpace.getX();
        int dy = -origin.getY();
        int dz = origin.getZ() + buildSpace.getZ();
        return new Rectangle3i(dx, dy, dz, buildSpace.getWidth(), buildSpace.getHeight(), buildSpace.getDepth());
    }

    private static Iterable<Vector3i> getResolvedBuildingSpace2(ISkinPartType skinPart) {
        return WorldUtils.getResolvedBuildingSpace(skinPart).enumerateZYX();
    }

    private static int getNumberOfCubesInPart(World level, CubeTransform transform, ISkinPartType skinPart) {
        int cubeCount = 0;
        for (Vector3i offset : WorldUtils.getResolvedBuildingSpace2(skinPart)) {
            BlockState blockState = level.func_180495_p(transform.mul(offset));
            if (!(blockState.func_177230_c() instanceof SkinCubeBlock)) continue;
            ++cubeCount;
        }
        return cubeCount;
    }

    private static Direction getResolvedDirection(Direction dir, boolean mirror) {
        if (mirror && dir.func_176740_k() == Direction.Axis.X) {
            return dir.func_176734_d();
        }
        return dir;
    }
}

