/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import extensions.net.minecraft.world.level.block.entity.BlockEntity.DataProvider;
import java.util.List;
import moe.plushie.armourers_workshop.api.common.IItemColorProvider;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.item.impl.IPaintProvider;
import moe.plushie.armourers_workshop.core.item.impl.IPaintToolPicker;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public class SkinCubeItem
extends BlockItem
implements IItemColorProvider,
IPaintToolPicker {
    public SkinCubeItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public ActionResultType usePickTool(World level, BlockPos pos, Direction dir, TileEntity blockEntity, ItemUseContext context) {
        ItemStack itemStack = context.func_195996_i();
        if (blockEntity instanceof IPaintProvider) {
            this.setItemColor(itemStack, ((IPaintProvider)blockEntity).getColor());
            return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
        }
        return ActionResultType.PASS;
    }

    protected boolean func_195943_a(BlockPos pos, World level, @Nullable PlayerEntity player, ItemStack itemStack, BlockState blockState) {
        TileEntity blockEntity = level.func_175625_s(pos);
        CompoundNBT nbt = itemStack.func_179543_a("BlockEntityTag");
        if (nbt != null && blockEntity != null) {
            CompoundNBT newNBT = DataProvider.saveWithFullMetadata(blockEntity);
            newNBT.func_218657_a("Color", (INBT)nbt.func_74775_l("Color"));
            DataProvider.load(blockEntity, newNBT);
        }
        return super.func_195943_a(pos, level, player, itemStack, blockState);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World level, List<ITextComponent> tooltips, ITooltipFlag flags) {
        super.func_77624_a(itemStack, level, tooltips, flags);
        BlockPaintColor paintColor = this.getItemColors(itemStack);
        if (paintColor != null && paintColor.isPureColor()) {
            tooltips.addAll(ColorUtils.getColorTooltips(paintColor.get(Direction.NORTH), true));
        }
    }

    @Override
    public void setItemColor(ItemStack itemStack, IPaintColor paintColor) {
        CompoundNBT nbt = itemStack.func_190925_c("BlockEntityTag");
        BlockPaintColor color = new BlockPaintColor(paintColor);
        OptionalAPI.putOptionalBlockPaintColor(nbt, "Color", color, null);
        itemStack.func_77983_a("Flags", (INBT)IntNBT.func_229692_a_((int)1));
    }

    @Override
    public IPaintColor getItemColor(ItemStack itemStack) {
        return (IPaintColor)ObjectUtils.defaultIfNull((Object)ColorUtils.getColor(itemStack), (Object)PaintColor.WHITE);
    }

    @Nullable
    public BlockPaintColor getItemColors(ItemStack itemStack) {
        return ColorUtils.getBlockColor(itemStack);
    }
}

