/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.common.IItemColorProvider;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.api.painting.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.builder.client.gui.PaletteToolWindow;
import moe.plushie.armourers_workshop.builder.item.AbstractColoredToolItem;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.item.impl.IPaintProvider;
import moe.plushie.armourers_workshop.core.item.impl.IPaintToolPicker;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModSounds;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutorIO;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PaintbrushItem
extends AbstractColoredToolItem
implements IItemTintColorProvider,
IItemPropertiesProvider,
IItemColorProvider,
IBlockPaintViewer,
IPaintToolPicker {
    public PaintbrushItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType resultType = this.usePickTool(context);
        if (resultType.func_226246_a_()) {
            return resultType;
        }
        return super.func_195939_a(context);
    }

    @Override
    public ActionResultType usePickTool(World level, BlockPos pos, Direction dir, TileEntity blockEntity, ItemUseContext context) {
        if (blockEntity instanceof IPaintProvider) {
            this.setItemColor(context.func_195996_i(), ((IPaintProvider)blockEntity).getColor());
            return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
        }
        return ActionResultType.PASS;
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(PaintingToolOptions.FULL_BLOCK_MODE);
    }

    @Override
    public IPaintToolAction createPaintToolAction(ItemUseContext context) {
        IPaintColor paintColor = this.getItemColor(context.func_195996_i(), PaintColor.WHITE);
        return new CubePaintingEvent.SetAction(paintColor);
    }

    @Override
    public void createModelProperties(BiConsumer<ResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("small"), (itemStack, level, entity, id) -> (Boolean)PaintingToolOptions.FULL_BLOCK_MODE.get(itemStack) != false ? 0.0f : 1.0f);
    }

    @Override
    public void appendColorHoverText(ItemStack itemStack, List<ITextComponent> tooltips) {
        IPaintColor paintColor = this.getItemColor(itemStack, PaintColor.WHITE);
        tooltips.addAll(ColorUtils.getColorTooltips(paintColor, true));
    }

    @Override
    public boolean openContainer(World level, PlayerEntity player, Hand hand, ItemStack itemStack) {
        if (level.func_201670_d() && EnvironmentExecutorIO.hasSprintDown()) {
            this.openPaletteGUI(level, player, hand, itemStack);
            return true;
        }
        return super.openContainer(level, player, hand, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openPaletteGUI(World level, PlayerEntity player, Hand hand, ItemStack itemStack) {
        PaletteToolWindow window = new PaletteToolWindow(itemStack.func_200301_q(), itemStack, hand);
        Minecraft.func_71410_x().func_147108_a(window.asScreen());
    }

    @Override
    public void setItemColor(ItemStack itemStack, IPaintColor paintColor) {
        ColorUtils.setColor(itemStack, paintColor);
    }

    @Override
    public IPaintColor getItemColor(ItemStack itemStack) {
        return ColorUtils.getColor(itemStack);
    }

    @Override
    public int getTintColor(ItemStack itemStack, int index) {
        if (index == 1) {
            return ColorUtils.getDisplayRGB(itemStack);
        }
        return -1;
    }

    @Override
    public IRegistryKey<SoundEvent> getItemSoundEvent(ItemUseContext context) {
        return ModSounds.PAINT;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        IPaintColor paintColor = this.getItemColor(itemStack, PaintColor.WHITE);
        return paintColor.getPaintType() != SkinPaintTypes.NORMAL;
    }
}

