/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.data.palette;

import com.apple.library.uikit.UIColor;
import java.util.Arrays;

public class Palette {
    public static final int MAX_COLORS_PER_PALETTE = 32;
    private final boolean locked;
    private String name;
    private final UIColor[] colors;

    public Palette(String name, boolean locked, UIColor[] colors) {
        this.name = name;
        this.locked = locked;
        this.colors = colors;
    }

    public Palette(String name) {
        this(name, false, new UIColor[32]);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public UIColor[] getColors() {
        return this.colors;
    }

    public void setColor(int index, UIColor color) {
        this.colors[index] = color;
    }

    public UIColor getColor(int index) {
        return this.colors[index];
    }

    public String toString() {
        return "Palette [name=" + this.name + ", colors=" + Arrays.toString(this.colors) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Palette other = (Palette)obj;
        if (this.name == null) {
            return other.name == null;
        }
        return this.name.equals(other.name);
    }

    protected Palette clone() {
        return new Palette(this.name, this.locked, (UIColor[])this.colors.clone());
    }
}

