/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.builder.item.SkinCubeItem;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractItemStackRenderer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.render.ExtendedFaceRenderer;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.init.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinCubeItemRenderer
extends AbstractItemStackRenderer {
    private static SkinCubeItemRenderer INSTANCE;

    public static SkinCubeItemRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SkinCubeItemRenderer();
        }
        return INSTANCE;
    }

    @Override
    public void renderByItem(ItemStack itemStack, AbstractItemTransformType transformType, MatrixStack poseStack, IRenderTypeBuffer renderTypeBuffer, int light, int overlay) {
        Block block;
        if (itemStack.func_190926_b()) {
            return;
        }
        SkinCubeItem item = (SkinCubeItem)itemStack.func_77973_b();
        BlockPaintColor blockPaintColor = item.getItemColors(itemStack);
        if (blockPaintColor == null) {
            blockPaintColor = BlockPaintColor.WHITE;
        }
        boolean isGlowing = (block = item.func_179223_d()).equals(ModBlocks.SKIN_CUBE_GLOWING.get()) || block.equals(ModBlocks.SKIN_CUBE_GLASS_GLOWING.get());
        boolean isGlass = block.equals(ModBlocks.SKIN_CUBE_GLASS.get()) || block.equals(ModBlocks.SKIN_CUBE_GLASS_GLOWING.get());
        RenderType renderType = SkinRenderType.BLOCK_CUBE;
        if (isGlass) {
            renderType = SkinRenderType.BLOCK_CUBE_GLASS;
        }
        if (isGlowing) {
            float f1 = 0.0625f;
            float f = 0.875f;
            IVertexBuilder builder2 = renderTypeBuffer.getBuffer(renderType);
            poseStack.func_227860_a_();
            poseStack.func_227861_a_((double)f1, (double)f1, (double)f1);
            poseStack.func_227862_a_(f, f, f);
            this.renderCube(blockPaintColor, light, overlay, poseStack, builder2);
            poseStack.func_227865_b_();
            renderType = SkinRenderType.BLOCK_CUBE_GLASS_UNSORTED;
        }
        IVertexBuilder builder1 = renderTypeBuffer.getBuffer(renderType);
        this.renderCube(blockPaintColor, light, overlay, poseStack, builder1);
    }

    public void renderCube(BlockPaintColor blockPaintColor, int light, int overlay, MatrixStack poseStack, IVertexBuilder builder) {
        for (Direction dir : Direction.values()) {
            IPaintColor paintColor = blockPaintColor.getOrDefault(dir, PaintColor.WHITE);
            ExtendedFaceRenderer.render2(0, 0, 0, dir, paintColor, 255, light, overlay, poseStack, builder);
        }
    }
}

