/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import com.apple.library.uikit.UIColor;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AbstractAdvancedGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedBlockGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.GuideRendererManager;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderBufferSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentSettings;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentType;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentTypes;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.PoseUtils;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedBuilderBlockRenderer<T extends AdvancedBuilderBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    private static final ImmutableMap<SkinDocumentType, AbstractAdvancedGuideRenderer> GUIDES = ImmutableMap.builder().put((Object)SkinDocumentTypes.BLOCK, (Object)new AdvancedBlockGuideRenderer()).build();
    public static ArrayList<Vector3f> OUTPUTS = new ArrayList();
    public static HashSet<BakedSkinPart> RESULTS = new HashSet();
    private final GuideRendererManager rendererManager = new GuideRendererManager();

    public static void setOutput(int i, Vector3f pt) {
        while (i >= OUTPUTS.size()) {
            OUTPUTS.add(Vector3f.ZERO);
        }
        OUTPUTS.set(i, pt);
    }

    public static void setResult(Collection<BakedSkinPart> results) {
        RESULTS.clear();
        RESULTS.addAll(results);
    }

    public AdvancedBuilderBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    public void render(T entity, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffers, int light, int overlay) {
        AbstractAdvancedGuideRenderer guideRenderer;
        poseStack.func_227860_a_();
        poseStack.func_227861_a_((double)((AdvancedBuilderBlockEntity)entity).offset.getX(), (double)((AdvancedBuilderBlockEntity)entity).offset.getY(), (double)((AdvancedBuilderBlockEntity)entity).offset.getZ());
        poseStack.func_227861_a_(0.5, 0.5, 0.5);
        poseStack.func_227862_a_(((AdvancedBuilderBlockEntity)entity).carmeScale.getX(), ((AdvancedBuilderBlockEntity)entity).carmeScale.getY(), ((AdvancedBuilderBlockEntity)entity).carmeScale.getZ());
        poseStack.func_227862_a_(-0.0625f, -0.0625f, 0.0625f);
        SkinDocumentSettings settings = ((AdvancedBuilderBlockEntity)entity).getDocument().getSettings();
        if (settings.showsHelperModel() && (guideRenderer = (AbstractAdvancedGuideRenderer)GUIDES.get((Object)((AdvancedBuilderBlockEntity)entity).getDocument().getType())) != null) {
            guideRenderer.render(poseStack, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f, buffers);
        }
        if (settings.showsOrigin()) {
            poseStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
            ShapeTesselator.vector(Vector3f.ZERO, 16.0f, poseStack, buffers);
            poseStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        }
        this.renderNode(((AdvancedBuilderBlockEntity)entity).getDocument().getRoot(), 0.0f, poseStack, buffers, light, overlay);
        poseStack.func_227865_b_();
        if (ModDebugger.advancedBuilder) {
            BlockState blockState = entity.func_195044_w();
            BlockPos pos = entity.func_174877_v();
            poseStack.func_227860_a_();
            poseStack.func_227861_a_((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
            ShapeTesselator.stroke(((AdvancedBuilderBlockEntity)entity).getCustomRenderBoundingBox(blockState), UIColor.RED, poseStack, buffers);
            Vector3f origin = ((AdvancedBuilderBlockEntity)entity).getRenderOrigin();
            poseStack.func_227861_a_((double)origin.getX(), (double)origin.getY(), (double)origin.getZ());
            ShapeTesselator.vector(Vector3f.ZERO, 1.0f, poseStack, buffers);
            poseStack.func_227861_a_((double)((AdvancedBuilderBlockEntity)entity).carmeOffset.getX(), (double)((AdvancedBuilderBlockEntity)entity).carmeOffset.getY(), (double)((AdvancedBuilderBlockEntity)entity).carmeOffset.getZ());
            ShapeTesselator.vector(Vector3f.ZERO, 1.0f, poseStack, buffers);
            poseStack.func_227865_b_();
        }
    }

    protected void renderNode(SkinDocumentNode node, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffers, int light, int overlay) {
        SkinDescriptor descriptor;
        SkinRenderTesselator tesselator;
        if (!node.isEnabled()) {
            return;
        }
        poseStack.func_227860_a_();
        SkinTransform transform = node.getTransform();
        PoseUtils.apply(poseStack, transform);
        if (node.isLocator()) {
            poseStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
            ShapeTesselator.vector(Vector3f.ZERO, 16.0f, poseStack, buffers);
            poseStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        }
        if (node.isMirror()) {
            ABI.mulPoseMatrix(poseStack, OpenMatrix4f.createScaleMatrix(-1.0f, 1.0f, 1.0f));
            ABI.mulNormalMatrix(poseStack, OpenMatrix3f.createScaleMatrix(-1.0f, 1.0f, 1.0f));
        }
        if ((tesselator = SkinRenderTesselator.create(descriptor = node.getSkin(), Tickets.RENDERER)) != null) {
            tesselator.setLightmap(0xF000F0);
            tesselator.setPartialTicks(partialTicks);
            tesselator.setPartialTicks(0.0f);
            tesselator.draw(poseStack, buffers);
        }
        for (SkinDocumentNode child : node.children()) {
            this.renderNode(child, partialTicks, poseStack, buffers, light, overlay);
        }
        poseStack.func_227865_b_();
    }

    public void renderOutput(T entity, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffers, int light, int overlay) {
        BlockPos pos = entity.func_174877_v();
        poseStack.func_227860_a_();
        poseStack.func_227861_a_((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        if (OUTPUTS.size() >= 2) {
            Vector3f pt1 = OUTPUTS.get(0);
            Vector3f vector3f = OUTPUTS.get(1);
        }
        poseStack.func_227865_b_();
    }

    @Override
    public int getViewDistance() {
        return 272;
    }

    public static class OutlineObjectBuilder
    implements SkinRenderBufferSource.ObjectBuilder {
        private final SkinRenderBufferSource.ObjectBuilder builder;

        public OutlineObjectBuilder(SkinRenderBufferSource.ObjectBuilder builder) {
            this.builder = builder;
        }

        public static SkinRenderBufferSource immediate(IRenderTypeBuffer buffers) {
            SkinRenderBufferSource source = SkinRenderBufferSource.immediate(buffers);
            return skin -> new OutlineObjectBuilder(source.getBuffer(skin));
        }

        @Override
        public int addPart(BakedSkinPart bakedPart, BakedSkin bakedSkin, ColorScheme scheme, boolean shouldRender, SkinRenderContext context) {
            int total = 0;
            if (RESULTS.contains(bakedPart)) {
                context.setOverlay(0x38FFFFFF);
                total = this.builder.addPart(bakedPart, bakedSkin, scheme, shouldRender, context);
                context.setOverlay(0);
            }
            if (total != 0) {
                shouldRender = false;
            }
            return this.builder.addPart(bakedPart, bakedSkin, scheme, shouldRender, context);
        }

        @Override
        public void addShape(Vector3f origin, SkinRenderContext context) {
            this.builder.addShape(origin, context);
        }

        @Override
        public void addShape(OpenVoxelShape shape, UIColor color, SkinRenderContext context) {
            this.builder.addShape(shape, color, context);
        }

        @Override
        public void addShape(IJointTransform[] transforms, SkinRenderContext context) {
            this.builder.addShape(transforms, context);
        }
    }
}

