/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.ArmourerBaseSetting;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.panel.ArmourerAdvancedSkinPanel;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.panel.ArmourerBaseSkinPanel;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.panel.ArmourerBlockSkinPanel;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.panel.ArmourerChestSkinPanel;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.panel.ArmourerFeetSkinPanel;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.panel.ArmourerHeadSkinPanel;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.panel.ArmourerLegSkinPanel;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.panel.ArmourerWingsSkinPanel;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.builder.network.UpdateArmourerPacket;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerSkinSetting
extends ArmourerBaseSetting {
    public static final ImmutableMap<ISkinType, Function<SkinProperties, ArmourerBaseSkinPanel>> REGISTERED = ImmutableMap.builder().put((Object)SkinTypes.ARMOR_HEAD, ArmourerHeadSkinPanel::new).put((Object)SkinTypes.ARMOR_CHEST, ArmourerChestSkinPanel::new).put((Object)SkinTypes.ARMOR_LEGS, ArmourerLegSkinPanel::new).put((Object)SkinTypes.ARMOR_FEET, ArmourerFeetSkinPanel::new).put((Object)SkinTypes.ARMOR_WINGS, ArmourerWingsSkinPanel::new).put((Object)SkinTypes.BLOCK, ArmourerBlockSkinPanel::new).put((Object)SkinTypes.ADVANCED, ArmourerAdvancedSkinPanel::new).build();
    protected final DifferenceSkinProperties skinProperties = new DifferenceSkinProperties();
    protected final ArmourerBlockEntity blockEntity;
    protected ArmourerBaseSkinPanel screen;

    public ArmourerSkinSetting(ArmourerMenu container) {
        super("armourer.skinSettings");
        this.blockEntity = (ArmourerBlockEntity)container.getBlockEntity();
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        if (this.screen != null) {
            this.screen.setFrame(this.bounds());
        }
    }

    @Override
    public void reloadData() {
        ISkinType skinType = this.blockEntity.getSkinType();
        this.skinProperties.reset(this.blockEntity.getSkinProperties());
        Function supplier = (Function)REGISTERED.get((Object)skinType);
        if (supplier != null) {
            this.updateScreen((ArmourerBaseSkinPanel)supplier.apply(this.skinProperties));
            this.screen.setApplier(this::updateSkinProperties);
            this.screen.setFrame(this.bounds());
            this.screen.init();
        } else {
            this.updateScreen(null);
        }
    }

    @Override
    public void init() {
        super.init();
        this.reloadData();
    }

    private void updateSkinProperties(SkinProperties skinProperties) {
        SkinProperties skinProperties1 = this.blockEntity.getSkinProperties().copy();
        this.skinProperties.applyTo(skinProperties1);
        if (skinProperties1.equals(this.blockEntity.getSkinProperties())) {
            return;
        }
        this.skinProperties.reset(skinProperties1);
        this.blockEntity.setSkinProperties(skinProperties);
        UpdateArmourerPacket.Field field = UpdateArmourerPacket.Field.SKIN_PROPERTIES;
        UpdateArmourerPacket packet = new UpdateArmourerPacket(this.blockEntity, field, skinProperties);
        NetworkManager.sendToServer(packet);
    }

    private void updateScreen(ArmourerBaseSkinPanel view) {
        if (this.screen == view) {
            return;
        }
        if (this.screen != null) {
            this.screen.removeFromSuperview();
        }
        this.screen = view;
        if (this.screen != null) {
            this.addSubview(this.screen);
        }
    }

    public static class DifferenceSkinProperties
    extends SkinProperties {
        protected HashMap<ISkinProperty<?>, BiConsumer<SkinProperties, SkinProperties>> changes = new HashMap();

        @Override
        public <T> void put(ISkinProperty<T> property, T value) {
            this.changes.put(property, (src, dest) -> dest.put(property, src.get(property)));
            super.put(property, value);
        }

        @Override
        public <T> void remove(ISkinProperty<T> property) {
            this.changes.put(property, (src, dest) -> dest.remove(property));
            super.remove(property);
        }

        @Override
        public void clear() {
            this.changes.clear();
            super.clear();
        }

        @Override
        public void putAll(SkinProperties properties) {
            this.changes.clear();
            super.putAll(properties);
        }

        public void reset(SkinProperties properties) {
            this.clear();
            this.putAll(properties);
        }

        public void applyTo(SkinProperties properties) {
            this.changes.values().forEach(co -> co.accept(this, properties));
        }
    }
}

