/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document;

import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIColor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import moe.plushie.armourers_workshop.api.common.IResource;
import moe.plushie.armourers_workshop.api.common.IResultHandler;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.client.gui.notification.UserNotificationCenter;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.exception.TranslatableException;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.property.SkinSettings;
import moe.plushie.armourers_workshop.core.skin.transformer.SkinPack;
import moe.plushie.armourers_workshop.core.skin.transformer.SkinPackReader;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModel;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelBone;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelExporter;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelGeometry;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelTexture;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockTransform;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchReader;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Util;

public class DocumentImporter {
    private final File inputFile;
    private final ISkinType skinType;

    public DocumentImporter(File inputFile, ISkinType skinType) {
        this.inputFile = inputFile;
        this.skinType = skinType;
    }

    public void execute(Consumer<Skin> consumer) {
        this.generateSkin((skin, exception) -> {
            try {
                if (skin == null) {
                    throw exception;
                }
                consumer.accept((Skin)skin);
            }
            catch (TranslatableException e) {
                e.printStackTrace();
                NSString message = new NSString(e.getComponent());
                NSString title = NSString.localizedString("advanced-skin-builder.dialog.importer.title", new Object[0]);
                UserNotificationCenter.showToast(message, UIColor.RED, title, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                NSString message = NSString.localizedString("skin-library.error.illegalOperation", new Object[0]);
                NSString title = NSString.localizedString("advanced-skin-builder.dialog.importer.title", new Object[0]);
                UserNotificationCenter.showToast(message, UIColor.RED, title, null);
            }
        });
    }

    private void generateSkin(IResultHandler<Skin> resultHandler) {
        Util.func_215072_e().execute(() -> {
            try {
                if (!this.inputFile.exists()) {
                    throw new TranslatableException("inventory.armourers_workshop.skin-library.error.illegalModelFile", new Object[0]);
                }
                Skin skin = this.readSkinFromFile(this.inputFile);
                if (skin == null || skin.getParts().isEmpty()) {
                    throw new TranslatableException("inventory.armourers_workshop.skin-library.error.illegalModelFormat", new Object[0]);
                }
                Minecraft.func_71410_x().execute(() -> resultHandler.accept(skin));
            }
            catch (Exception e) {
                Minecraft.func_71410_x().execute(() -> resultHandler.throwing(e));
            }
        });
    }

    private Skin readSkinFromFile(File file) throws IOException {
        String name = file.getName();
        Collection<IResource> resources = this.getResourcesFromFile(file);
        return this.readSkinFromReader(BlockBenchReader.from(name, resources));
    }

    private Skin readSkinFromReader(SkinPackReader reader) throws IOException {
        CustomModelExporter exporter = new CustomModelExporter();
        reader.loadEntityModel(modelReader -> {
            Map<String, BedrockTransform> transforms;
            BedrockModel model = modelReader.readModel();
            for (BedrockModelGeometry geometry : model.getGeometries()) {
                BedrockModelTexture texture = modelReader.readTexture(geometry);
                for (BedrockModelBone bone : geometry.getBones()) {
                    exporter.add(bone, texture);
                }
            }
            SkinPack pack = modelReader.getPack();
            if (pack != null) {
                List<String> authors;
                String description;
                String name2 = pack.getName();
                if (name2 != null && !name2.isEmpty()) {
                    exporter.add(SkinProperty.ALL_CUSTOM_NAME, name2);
                }
                if ((description = pack.getDescription()) != null && !description.isEmpty()) {
                    exporter.add(SkinProperty.ALL_FLAVOUR_TEXT, description);
                }
                if ((authors = pack.getAuthors()) != null && !authors.isEmpty()) {
                    StringBuilder builder = null;
                    for (String a : authors) {
                        if (builder == null) {
                            builder = new StringBuilder(a);
                            continue;
                        }
                        builder.append(",");
                        builder.append(a);
                    }
                    exporter.add(SkinProperty.ALL_AUTHOR_NAME, builder.toString());
                }
            }
            if ((transforms = modelReader.getTransforms()) != null) {
                transforms.forEach((name, transform) -> {
                    Vector3f scale;
                    Vector3f rotation;
                    Vector3f translation = transform.getTranslation();
                    SkinTransform transform1 = SkinTransform.create(translation, rotation = transform.getRotation(), scale = transform.getScale());
                    if (!transform1.isIdentity()) {
                        exporter.add((String)name, transform1);
                    }
                });
            }
        });
        if (this.skinType == SkinTypes.OUTFIT) {
            exporter.move(new Vector3f(0.0f, -24.0f, 0.0f));
        }
        return exporter.export(this.skinType);
    }

    private Collection<IResource> getResourcesFromFile(File file) throws IOException {
        if (file.isDirectory()) {
            return this.getResourcesFromDirectory(file);
        }
        if (file.getName().toLowerCase().endsWith(".zip")) {
            return this.getResourcesFromZip(file);
        }
        return this.getResourcesFromSet(file);
    }

    private Collection<IResource> getResourcesFromZip(File zipFile) throws IOException {
        ZipEntry entry;
        ArrayList<IResource> resources = new ArrayList<IResource>();
        final ZipFile file = new ZipFile(zipFile);
        ZipInputStream zip = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
        while ((entry = zip.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            final String fileName = entry.getName();
            final ZipEntry fileEntry = entry;
            resources.add(new IResource(){

                @Override
                public String getName() {
                    return fileName;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return file.getInputStream(fileEntry);
                }
            });
        }
        return resources;
    }

    private Collection<IResource> getResourcesFromDirectory(File rootPath) throws IOException {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (final File entry : SkinFileUtils.listAllFiles(rootPath)) {
            if (entry.isDirectory()) continue;
            final String fileName = SkinFileUtils.getRelativePath(entry, rootPath, true).substring(1);
            resources.add(new IResource(){

                @Override
                public String getName() {
                    return fileName;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(entry);
                }
            });
        }
        return resources;
    }

    private Collection<IResource> getResourcesFromSet(File ... entries) throws IOException {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (final File entry : entries) {
            if (entry.isDirectory()) continue;
            final String fileName = entry.getName();
            resources.add(new IResource(){

                @Override
                public String getName() {
                    return fileName;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(entry);
                }
            });
        }
        return resources;
    }

    public static class CustomModelExporter
    extends BedrockModelExporter {
        @Override
        protected Skin.Builder createSkin(ISkinType skinType) {
            Skin.Builder builder = new Skin.Builder(SkinTypes.ADVANCED);
            SkinSettings settings = new SkinSettings();
            settings.setEditable(true);
            builder.settings(settings);
            return builder;
        }
    }
}

