/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.item.impl.IPaintProvider;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;

public class ColorMixerBlockEntity
extends UpdatableBlockEntity
implements IPaintProvider {
    private IPaintColor color = PaintColor.WHITE;

    public ColorMixerBlockEntity(TileEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        this.color = OptionalAPI.getOptionalPaintColor(nbt, "Color", PaintColor.WHITE);
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        OptionalAPI.putOptionalPaintColor(nbt, "Color", this.color, PaintColor.WHITE);
    }

    @Override
    public IPaintColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(IPaintColor color) {
        this.color = color;
        BlockUtils.combine(this, this::sendBlockUpdates);
    }
}

