/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.block;

import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.common.IBlockTintColorProvider;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockEntityProvider;
import moe.plushie.armourers_workshop.compatibility.core.AbstractHorizontalBlock;
import moe.plushie.armourers_workshop.core.data.OptionalDirection;
import moe.plushie.armourers_workshop.init.ModBlockEntityTypes;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import org.jetbrains.annotations.Nullable;

public class SkinCubeBlock
extends AbstractHorizontalBlock
implements AbstractBlockEntityProvider,
IBlockTintColorProvider {
    public static final DirectionProperty MARKER = DirectionProperty.func_196962_a((String)"marker", (Direction[])Direction.values());
    public static final BooleanProperty HAS_MARKER = BooleanProperty.func_177716_a((String)"has_marker");

    public SkinCubeBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HAS_MARKER, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)MARKER, (Comparable)Direction.NORTH));
    }

    public static OptionalDirection getMarker(BlockState blockState) {
        if (blockState.func_235903_d_((Property)HAS_MARKER).orElse(false).booleanValue()) {
            return OptionalDirection.of((Direction)blockState.func_177229_b((Property)MARKER));
        }
        return OptionalDirection.NONE;
    }

    public static BlockState setMarker(BlockState blockState, OptionalDirection direction) {
        Direction dir = direction.getDirection();
        if (dir != null) {
            return (BlockState)((BlockState)blockState.func_206870_a((Property)HAS_MARKER, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)MARKER, (Comparable)dir);
        }
        return (BlockState)blockState.func_206870_a((Property)HAS_MARKER, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public TileEntity createBlockEntity(IBlockReader level, BlockPos blockPos, BlockState blockState) {
        return ((IBlockEntityType)ModBlockEntityTypes.SKIN_CUBE.get()).create(level, blockPos, blockState);
    }

    public boolean func_200122_a(BlockState state, BlockState state1, Direction dir) {
        return state.func_177230_c() == state1.func_177230_c();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{MARKER});
        builder.func_206894_a(new Property[]{HAS_MARKER});
    }

    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        Direction facing = rotation.func_185831_a((Direction)blockState.func_177229_b((Property)field_185512_D));
        Direction marker = rotation.func_185831_a((Direction)blockState.func_177229_b((Property)MARKER));
        return (BlockState)((BlockState)blockState.func_206870_a((Property)field_185512_D, (Comparable)facing)).func_206870_a((Property)MARKER, (Comparable)marker);
    }

    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        return this.func_185499_a(blockState, mirror.func_185800_a((Direction)blockState.func_177229_b((Property)field_185512_D)));
    }

    public boolean func_200123_i(BlockState blockState, IBlockReader blockGetter, BlockPos blockPos) {
        return true;
    }

    @Override
    public int getTintColor(BlockState blockState, @Nullable IBlockReader reader, @Nullable BlockPos blockPos, int index) {
        IPaintColor paintColor;
        TileEntity blockEntity;
        if (reader == null || blockPos == null) {
            return -1;
        }
        Direction direction = Direction.NORTH;
        if (index > 0 && index < 7) {
            direction = Direction.values()[index - 1];
        }
        if ((blockEntity = reader.func_175625_s(blockPos)) instanceof IPaintable && (paintColor = ((IPaintable)blockEntity).getColor(direction)) != null) {
            return paintColor.getRGB() | 0xFF000000;
        }
        return -1;
    }
}

