/*
 * Decompiled with CFR 0.152.
 */
package extensions.net.minecraft.core.Registry;

import extensions.net.minecraft.world.item.CreativeModeTab.BuilderProvider;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.ThisClass;
import moe.plushie.armourers_workshop.api.common.IItemTag;
import moe.plushie.armourers_workshop.api.registry.IRegistry;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistry;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistryEntry;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Extension
public class ForgeProvider {
    public static final IRegistry<Block> BLOCKS = new Proxy<Block>(Block.class, ForgeRegistries.BLOCKS);
    public static final IRegistry<Item> ITEMS = new Proxy<Item>(Item.class, ForgeRegistries.ITEMS);
    public static final IRegistry<ContainerType<?>> MENU_TYPES = new Proxy(ContainerType.class, ForgeRegistries.CONTAINERS);
    public static final IRegistry<EntityType<?>> ENTITY_TYPES = new Proxy(EntityType.class, ForgeRegistries.ENTITIES);
    public static final IRegistry<DataSerializerEntry> ENTITY_DATA_SERIALIZER = new Proxy<DataSerializerEntry>(IDataSerializer.class, ForgeRegistries.DATA_SERIALIZERS);
    public static final IRegistry<TileEntityType<?>> BLOCK_ENTITY_TYPES = new Proxy(TileEntityType.class, ForgeRegistries.TILE_ENTITIES);
    public static final IRegistry<SoundEvent> SOUND_EVENTS = new Proxy<SoundEvent>(SoundEvent.class, ForgeRegistries.SOUND_EVENTS);

    public static <T extends Item> IRegistryKey<T> registerItemFO(@ThisClass Class<?> clazz, String name, Supplier<T> supplier) {
        return ITEMS.register(name, supplier);
    }

    public static <T extends IItemTag> IRegistryKey<T> registerItemTagFO(@ThisClass Class<?> clazz, String name) {
        ResourceLocation registryName = ModConstants.key(name);
        Tags.IOptionalNamedTag tag = ItemTags.createOptional((ResourceLocation)registryName);
        ModLog.debug("Registering Item Tag '{}'", registryName);
        return AbstractForgeRegistryEntry.cast(registryName, () -> ForgeProvider.lambda$registerItemTagFO$1((ITag)tag));
    }

    public static <T extends ItemGroup> IRegistryKey<T> registerItemGroupFO(@ThisClass Class<?> clazz, String name, Supplier<Supplier<ItemStack>> icon, Consumer<List<ItemStack>> itemProvider) {
        ResourceLocation registryName = ModConstants.key(name);
        Supplier<ItemGroup> tab = BuilderProvider.createCreativeModeTabFO(ItemGroup.class, name, icon, itemProvider);
        ModLog.debug("Registering Creative Mode Tab '{}'", registryName);
        return AbstractForgeRegistryEntry.cast(registryName, tab);
    }

    public static <T extends Block> IRegistryKey<T> registerBlockFO(@ThisClass Class<?> clazz, String name, Supplier<T> supplier) {
        return BLOCKS.register(name, supplier);
    }

    public static <T extends TileEntity, V extends TileEntityType<T>> IRegistryKey<V> registerBlockEntityTypeFO(@ThisClass Class<?> clazz, String name, Supplier<V> supplier) {
        return BLOCK_ENTITY_TYPES.register(name, supplier);
    }

    public static <T extends Entity, V extends EntityType<T>> IRegistryKey<V> registerEntityTypeFO(@ThisClass Class<?> clazz, String name, Supplier<V> supplier) {
        return ENTITY_TYPES.register(name, supplier);
    }

    public static <T extends IDataSerializer<?>> IRegistryKey<T> registerEntityDataSerializerFO(@ThisClass Class<?> clazz, String name, Supplier<T> supplier) {
        IRegistryKey<DataSerializerEntry> entry = ENTITY_DATA_SERIALIZER.register(name, () -> new DataSerializerEntry((IDataSerializer)supplier.get()));
        return AbstractForgeRegistryEntry.cast(entry.getRegistryName(), () -> ((DataSerializerEntry)entry.get()).getSerializer());
    }

    public static <T extends Container, V extends ContainerType<T>> IRegistryKey<V> registerMenuTypeFO(@ThisClass Class<?> clazz, String name, Supplier<V> supplier) {
        return MENU_TYPES.register(name, supplier);
    }

    public static <T extends SoundEvent> IRegistryKey<T> registerSoundEventFO(@ThisClass Class<?> clazz, String name, Supplier<T> supplier) {
        return SOUND_EVENTS.register(name, supplier);
    }

    private static /* synthetic */ IItemTag lambda$registerItemTagFO$1(ITag tag) {
        return itemStack -> itemStack.func_77973_b().func_206844_a(tag);
    }

    public static class Proxy<T extends IForgeRegistryEntry<T>>
    extends AbstractForgeRegistry<T> {
        private final Supplier<IForgeRegistry<T>> registry;
        private final DeferredRegister<T> deferredRegistry;

        public Proxy(Class<?> type, IForgeRegistry<T> registry) {
            this(type, () -> registry, DeferredRegister.create(registry, (String)"armourers_workshop"));
        }

        public Proxy(Class<?> type, Supplier<IForgeRegistry<T>> registry, DeferredRegister<T> deferredRegistry) {
            super(type, deferredRegistry);
            this.registry = registry;
            this.deferredRegistry = deferredRegistry;
        }

        @Override
        public <I extends T> Supplier<I> deferredRegister(String name, Supplier<? extends I> provider) {
            return this.deferredRegistry.register(name, provider);
        }

        @Override
        public ResourceLocation getKey(T object) {
            return this.registry.get().getKey(object);
        }

        @Override
        public T getValue(ResourceLocation registryName) {
            return (T)this.registry.get().getValue(registryName);
        }
    }
}

