/*
 * Decompiled with CFR 0.152.
 */
package extensions.net.minecraft.core.Registry;

import java.util.function.Consumer;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.ThisClass;
import moe.plushie.armourers_workshop.init.platform.forge.NotificationCenterImpl;
import moe.plushie.armourers_workshop.init.provider.ClientNativeProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;

@Extension
public class ClientEventProvider {
    public static void willRenderBlockHighlightFO(@ThisClass Class<?> clazz, ClientNativeProvider.RenderBlockHighlight renderer) {
        NotificationCenterImpl.observer(DrawHighlightEvent.HighlightBlock.class, event -> renderer.render(event.getTarget(), event.getInfo(), event.getMatrix(), event.getBuffers()));
    }

    public static void willRenderLivingEntityFO(@ThisClass Class<?> clazz, ClientNativeProvider.RenderLivingEntity renderer) {
        NotificationCenterImpl.observer(RenderLivingEvent.Pre.class, event -> renderer.render(event.getEntity(), event.getPartialRenderTick(), event.getLight(), event.getMatrixStack(), event.getBuffers(), event.getRenderer()));
    }

    public static void didRenderLivingEntityFO(@ThisClass Class<?> clazz, ClientNativeProvider.RenderLivingEntity renderer) {
        NotificationCenterImpl.observer(RenderLivingEvent.Post.class, event -> renderer.render(event.getEntity(), event.getPartialRenderTick(), event.getLight(), event.getMatrixStack(), event.getBuffers(), event.getRenderer()));
    }

    public static void willPlayerEnterFO(@ThisClass Class<?> clazz, Consumer<PlayerEntity> consumer) {
        NotificationCenterImpl.observer(ClientPlayerNetworkEvent.LoggedInEvent.class, consumer, ClientPlayerNetworkEvent::getPlayer);
    }

    public static void willPlayerLeaveFO(@ThisClass Class<?> clazz, Consumer<PlayerEntity> consumer) {
        NotificationCenterImpl.observer(ClientPlayerNetworkEvent.LoggedOutEvent.class, consumer, ClientPlayerNetworkEvent::getPlayer);
    }

    public static void willRegisterItemColorFO(@ThisClass Class<?> clazz, Consumer<ClientNativeProvider.ItemColorRegistry> consumer) {
        NotificationCenterImpl.observer(ColorHandlerEvent.Item.class, consumer, event -> (provider, values) -> event.getItemColors().func_199877_a(provider::getTintColor, (IItemProvider[])values));
    }

    public static void willRegisterBlockColorFO(@ThisClass Class<?> clazz, Consumer<ClientNativeProvider.BlockColorRegistry> consumer) {
        NotificationCenterImpl.observer(ColorHandlerEvent.Block.class, consumer, event -> (provider, values) -> event.getBlockColors().func_186722_a(provider::getTintColor, values));
    }

    public static void willRegisterModelFO(@ThisClass Class<?> clazz, Consumer<ClientNativeProvider.ModelRegistry> consumer) {
        NotificationCenterImpl.observer(ModelRegistryEvent.class, event -> consumer.accept(ModelLoader::addSpecialModel));
    }

    public static void willRegisterKeyMappingFO(@ThisClass Class<?> clazz, Consumer<ClientNativeProvider.KeyMappingRegistry> consumer) {
        consumer.accept(ClientRegistry::registerKeyBinding);
    }

    public static void willRegisterItemPropertyFO(@ThisClass Class<?> clazz, Consumer<ClientNativeProvider.ItemPropertyRegistry> consumer) {
        NotificationCenterImpl.observer(ModelRegistryEvent.class, event -> consumer.accept((registryName, item, property) -> ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)registryName, (itemStack, level, entity) -> property.getValue(itemStack, (World)level, entity, 0))));
    }

    public static void willRegisterTextureFO(@ThisClass Class<?> clazz, Consumer<ClientNativeProvider.TextureRegistry> consumer) {
        NotificationCenterImpl.observer(TextureStitchEvent.Pre.class, consumer, event -> registryName -> {
            if (event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
                event.addSprite(registryName);
            }
        });
    }
}

