/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSIndexPath;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.impl.AppearanceImpl;
import com.apple.library.impl.SoundManagerImpl;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEdgeInsets;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UITableView;
import com.apple.library.uikit.UITableViewCell;
import com.apple.library.uikit.UITableViewDataSource;
import com.apple.library.uikit.UITableViewDelegate;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.init.ModTextures;
import org.jetbrains.annotations.Nullable;

public class UIComboBox
extends UIControl
implements UITableViewDataSource,
UITableViewDelegate {
    protected final Entry titleView = new Entry();
    protected final UIButton handleView = new UIButton(CGRect.ZERO);
    protected final UIView popoverView = new UIView(CGRect.ZERO);
    protected final UITableView popoverContentView = new UITableView(CGRect.ZERO);
    protected final ArrayList<UIComboItem> items = new ArrayList();
    protected int selectedIndex = 0;
    protected int maxRows = 0;
    private UIImage backgroundImage;

    public UIComboBox(CGRect frame) {
        super(frame);
        this.setBackgroundImage(AppearanceImpl.BUTTON_IMAGE.imageAtIndex(4));
        this.handleView.setBackgroundImage(AppearanceImpl.BUTTON_IMAGE, 7);
        this.handleView.setUserInteractionEnabled(false);
        this.handleView.setImage(UIImage.of(ModTextures.LIST).uv(0.0f, 248.0f).fixed(8.0f, 8.0f).build(), 0);
        this.handleView.setImage(UIImage.of(ModTextures.LIST).uv(0.0f, 240.0f).fixed(8.0f, 8.0f).build(), 2);
        this.handleView.setTitleColor(UIColor.WHITE, 7);
        this.handleView.setCanBecomeFocused(false);
        this.titleView.titleView.setEnabled(false);
        this.titleView.setClipBounds(true);
        this.titleView.setUserInteractionEnabled(false);
        this.addSubview(this.handleView);
        this.addSubview(this.titleView);
        this.popoverContentView.setRowHeight(13);
        this.popoverContentView.setDataSource(this);
        this.popoverContentView.setDelegate(this);
        this.popoverView.setZIndex(200);
        this.popoverView.addSubview(this.popoverContentView);
    }

    public void reloadData(List<? extends UIComboItem> items) {
        this.items.clear();
        this.items.addAll(items);
        this.applyTableViewSize();
        this.popoverContentView.reloadData();
        this.layoutIfNeeded();
        this.updateTitleView(this.safeGet(this.selectedIndex));
    }

    @Override
    public void mouseDown(UIEvent event) {
        super.mouseDown(event);
        SoundManagerImpl.click();
        this.setSelected(!this.isSelected());
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGRect rect = this.bounds();
        float h = rect.height;
        this.titleView.setFrame(rect.insetBy(1.0f, 1.0f, 1.0f, h + 1.0f));
        this.handleView.setFrame(new CGRect(rect.width - h, 0.0f, h, h));
        this.applyTableViewSize();
    }

    @Override
    public boolean pointInside(CGPoint point, UIEvent event) {
        if (super.pointInside(point, event)) {
            return true;
        }
        if (this.popoverView.superview() != null) {
            return this.popoverView.pointInside(this.convertPointToView(point, this.popoverView), event);
        }
        return false;
    }

    @Override
    public int tableViewNumberOfRowsInSection(UITableView tableView, int section) {
        return this.items.size();
    }

    @Override
    public UITableViewCell tableViewCellForRow(UITableView tableView, NSIndexPath indexPath) {
        Entry entry = new Entry();
        this.updateEntryView(entry, this.items.get(indexPath.row));
        return entry;
    }

    @Override
    public void tableViewDidSelectRow(UITableView tableView, NSIndexPath indexPath) {
        this.setSelectedIndex(indexPath.row);
        this.sendEvent(UIControl.Event.VALUE_CHANGED);
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        context.drawImage(this.backgroundImage, this.bounds());
        super.render(point, context);
    }

    public UIImage backgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(UIImage backgroundImage) {
        this.backgroundImage = backgroundImage;
        this.popoverView.setContents(backgroundImage);
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        super.setHighlighted(highlighted);
        this.handleView.setHighlighted(highlighted);
    }

    @Override
    public void setSelected(boolean isSelected) {
        super.setSelected(isSelected);
        if (isSelected == this.handleView.isSelected()) {
            return;
        }
        this.handleView.setSelected(isSelected);
        this.popoverView.removeFromSuperview();
        if (isSelected) {
            this.popoverContentView.setContentOffset(CGPoint.ZERO);
            this.addSubview(this.popoverView);
        }
        if (isSelected) {
            this.addGlobalClickListener();
        } else {
            this.removeGlobalClickListener();
        }
    }

    public int selectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
        this.updateTitleView(this.safeGet(selectedIndex));
    }

    public int maxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    protected void updateTitleView(UIComboItem comboItem) {
        this.updateEntryView(this.titleView, comboItem);
    }

    protected void updateEntryView(Entry entry, UIComboItem comboItem) {
        entry.setup(comboItem);
    }

    @Override
    protected boolean shouldBeHighlight(CGPoint point, UIEvent event) {
        return this.bounds().contains(point);
    }

    @Override
    protected boolean shouldPassHighlighted() {
        return false;
    }

    private UIComboItem safeGet(int row) {
        if (row >= 0 && row < this.items.size()) {
            return this.items.get(row);
        }
        return null;
    }

    private void applyTableViewSize() {
        CGRect rect = this.bounds();
        float popoverHeight = 0.0f;
        if (this.maxRows != 0) {
            popoverHeight = this.maxRows * this.popoverContentView.rowHeight();
        }
        if (popoverHeight == 0.0f) {
            UIEdgeInsets edg = this.popoverContentView.contentInsets();
            popoverHeight = edg.top + this.popoverContentView.contentSize().height + edg.bottom;
        }
        this.popoverView.setFrame(new CGRect(0.0f, rect.height + 1.0f, rect.width, popoverHeight + 2.0f));
        this.popoverContentView.setFrame(this.popoverView.bounds().insetBy(1.0f, 1.0f, 1.0f, 1.0f));
    }

    private void addGlobalClickListener() {
        UIWindow window = this.window();
        if (window != null) {
            window.addGlobalTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, (self, event) -> {
                self.removeGlobalClickListener();
                CGPoint point = event.locationInView((UIView)self);
                if (!self.pointInside(point, (UIEvent)event)) {
                    self.setSelected(false);
                }
            });
        }
    }

    private void removeGlobalClickListener() {
        UIWindow window = this.window();
        if (window != null) {
            window.removeGlobalTarget(this, UIControl.Event.MOUSE_LEFT_DOWN);
        }
    }

    public static class Entry
    extends UITableViewCell {
        private static final UIColor BACKGROUND_COLOR = new UIColor(0x44CCCCCC, true);
        public final UIButton titleView = new UIButton(CGRect.ZERO);

        public Entry() {
            super(CGRect.ZERO);
            this.titleView.titleView().setShadowColor(null);
            this.titleView.setUserInteractionEnabled(false);
            this.titleView.setHorizontalAlignment(NSTextAlignment.Horizontal.LEFT);
            this.titleView.setContentEdgeInsets(new UIEdgeInsets(0.0f, 2.0f, 0.0f, 2.0f));
            this.titleView.setTitleColor(UIColor.WHITE, 0);
            this.titleView.setTitleColor(new UIColor(0xFFFFA0), 1);
            this.titleView.setTitleColor(new UIColor(0xCC0000), 4);
            this.titleView.setCanBecomeFocused(false);
            this.addSubview(this.titleView);
        }

        @Override
        public void layoutSubviews() {
            super.layoutSubviews();
            this.titleView.setFrame(this.bounds());
        }

        public void setup(@Nullable UIComboItem item) {
            if (item == null) {
                this.setHidden(true);
                return;
            }
            this.titleView.setTitle(item.title, 7);
            this.titleView.setImage(item.image, 7);
            this.titleView.setEnabled(item.isEnabled);
            this.setHidden(false);
        }

        @Override
        public void setHighlighted(boolean highlighted) {
            super.setHighlighted(highlighted);
            this.titleView.setHighlighted(highlighted);
            if (highlighted) {
                this.setBackgroundColor(BACKGROUND_COLOR);
            } else {
                this.setBackgroundColor(null);
            }
        }
    }
}

