/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.impl.ObjectUtilsImpl;
import com.apple.library.uikit.UIFont;
import java.util.LinkedList;
import java.util.List;

public class SimpleTextLayoutImpl {
    private final float contentWidth;
    private final float contentHeight;
    private final List<Line> textLines;

    public SimpleTextLayoutImpl(NSString title, UIFont font, int numberOfLines, float lineSpacing, float preferredMaxLayoutWidth) {
        if (preferredMaxLayoutWidth <= 0.0f) {
            preferredMaxLayoutWidth = 10000.0f;
        }
        LinkedList<NSString> lines = new LinkedList<NSString>();
        if (numberOfLines == 1) {
            lines.add(title);
        } else {
            lines.addAll(title.split(font, preferredMaxLayoutWidth));
        }
        while (numberOfLines != 0 && lines.size() > numberOfLines) {
            lines.removeLast();
        }
        this.textLines = ObjectUtilsImpl.map(lines, text -> new Line((NSString)text, font));
        float textWidth = 0.0f;
        float textHeight = 0.0f;
        for (Line line : this.textLines) {
            line.offset = new CGPoint(0.0f, textHeight);
            textHeight += line.size.height + lineSpacing;
            textWidth = Math.max(textWidth, line.size.width);
        }
        if (!this.textLines.isEmpty()) {
            textHeight -= lineSpacing;
        }
        this.contentWidth = textWidth;
        this.contentHeight = textHeight;
    }

    public List<Line> contents() {
        return this.textLines;
    }

    public CGSize contentSize() {
        return new CGSize(this.contentWidth, this.contentHeight);
    }

    public boolean isEmpty() {
        return this.textLines.isEmpty();
    }

    public static class Line {
        public CGPoint offset;
        public CGRect size;
        public NSString text;
        public UIFont font;

        public Line(NSString text, UIFont font) {
            this.text = text;
            this.size = text.boundingRectWithFont(font);
            this.font = font;
        }
    }
}

