/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.coregraphics;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.impl.ObjectUtilsImpl;
import com.mojang.blaze3d.matrix.MatrixStack;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.IRenderTypeBuffer;

public interface CGGraphicsState {
    public MatrixStack ctm();

    public IRenderTypeBuffer buffers();

    public CGPoint mousePos();

    public float partialTicks();

    public void flush();

    default public void save() {
        this.ctm().func_227860_a_();
    }

    default public void translate(float x, float y, float z) {
        if (x != 0.0f || y != 0.0f || z != 0.0f) {
            this.ctm().func_227861_a_((double)x, (double)y, (double)z);
        }
    }

    default public void rotate(float x, float y, float z) {
        if (x != 0.0f) {
            ABI.mulPose(this.ctm(), Vector3f.XP.rotationDegrees(x));
        }
        if (y != 0.0f) {
            ABI.mulPose(this.ctm(), Vector3f.YP.rotationDegrees(y));
        }
        if (z != 0.0f) {
            ABI.mulPose(this.ctm(), Vector3f.ZP.rotationDegrees(z));
        }
    }

    default public void concatenate(CGAffineTransform transform) {
        MatrixStack ctm = this.ctm();
        ABI.mulNormalMatrix(ctm, ObjectUtilsImpl.convertToMatrix3x3(transform));
        ABI.mulPoseMatrix(ctm, ObjectUtilsImpl.convertToMatrix4x4(transform));
    }

    default public void restore() {
        this.ctm().func_227865_b_();
    }
}

