/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import java.io.IOException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.blocks.tiles.TileScriptedDoor;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.packets.IPacketServer;

public class SPacketScriptSave
extends IPacketServer {
    private int type;
    private CompoundNBT data;

    public SPacketScriptSave(int type, CompoundNBT data) {
        this.type = type;
        this.data = data;
    }

    public SPacketScriptSave() {
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return item.func_77973_b() == CustomItems.scripter || item.func_77973_b() == CustomBlocks.scripted_door_item || item.func_77973_b() == CustomItems.wand || item.func_77973_b() == CustomItems.scripted_item || item.func_77973_b() == CustomBlocks.scripted_item;
    }

    @Override
    public boolean requiresNpc() {
        return this.type == 0;
    }

    @Override
    public CustomNpcsPermissions.Permission getPermission() {
        return CustomNpcsPermissions.TOOL_SCRIPTER;
    }

    @Override
    public void handle() {
        TileNpcEntity script;
        TileEntity tile;
        PlayerData pd;
        if (this.type == 0) {
            this.npc.script.load(this.data);
            this.npc.updateAI = true;
            this.npc.script.lastInited = -1L;
        }
        if (this.type == 1) {
            pd = PlayerData.get((PlayerEntity)this.player);
            tile = this.player.field_70170_p.func_175625_s(pd.scriptBlockPos);
            if (!(tile instanceof TileScripted)) {
                return;
            }
            script = (TileScripted)tile;
            ((TileScripted)script).setNBT(this.data);
            ((TileScripted)script).lastInited = -1L;
        }
        if (this.type == 2) {
            if (!this.player.func_184812_l_()) {
                return;
            }
            ItemScriptedWrapper wrapper = (ItemScriptedWrapper)NpcAPI.Instance().getIItemStack(this.player.func_184614_ca());
            wrapper.setMCNbt(this.data);
            wrapper.lastInited = -1L;
            wrapper.saveScriptData();
            wrapper.updateClient = true;
            this.player.func_71120_a(this.player.field_71070_bA);
        }
        if (this.type == 3) {
            ScriptController.Instance.setForgeScripts(this.data);
        }
        if (this.type == 4) {
            ScriptController.Instance.setPlayerScripts(this.data);
        }
        if (this.type == 5) {
            pd = PlayerData.get((PlayerEntity)this.player);
            tile = this.player.field_70170_p.func_175625_s(pd.scriptBlockPos);
            if (!(tile instanceof TileScriptedDoor)) {
                return;
            }
            script = (TileScriptedDoor)tile;
            ((TileScriptedDoor)script).setNBT(this.data);
            ((TileScriptedDoor)script).lastInited = -1L;
        }
    }

    public void func_148837_a(PacketBuffer buf) throws IOException {
        this.type = buf.readInt();
        this.data = buf.func_150793_b();
    }

    public void func_148840_b(PacketBuffer buf) throws IOException {
        buf.writeInt(this.type);
        buf.func_150786_a(this.data);
    }
}

