/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.schematics.SchematicWrapper;

public class CmdSchematics {
    public static final List<String> names = new ArrayList<String>();
    public static final SuggestionProvider<CommandSource> SCHEMAS = SuggestionProviders.func_197494_a((ResourceLocation)new ResourceLocation("schemas"), (context, builder) -> ISuggestionProvider.func_197013_a(names.stream(), (SuggestionsBuilder)builder));
    public static final SuggestionProvider<CommandSource> ROTATION = SuggestionProviders.func_197494_a((ResourceLocation)new ResourceLocation("rotation"), (context, builder) -> ISuggestionProvider.func_197008_a((String[])new String[]{"0", "90", "180", "270"}, (SuggestionsBuilder)builder));

    public static LiteralArgumentBuilder<CommandSource> register() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"schema").requires(source -> source.func_197034_c(4))).then(Commands.func_197057_a((String)"build").then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.word()).suggests(SCHEMAS).then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"rotation", (ArgumentType)StringArgumentType.word()).suggests(ROTATION).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            BlockPos pos = BlockPosArgument.func_197274_b((CommandContext)context, (String)"pos");
            int rotation = Integer.parseInt(StringArgumentType.getString((CommandContext)context, (String)"rotation"));
            SchematicWrapper schem = SchematicController.Instance.load(name);
            schem.init(pos, (World)((CommandSource)context.getSource()).func_197023_e(), rotation);
            SchematicController.Instance.build(schem, (CommandSource)context.getSource());
            return 1;
        })))))).then(Commands.func_197057_a((String)"stop").executes(context -> {
            SchematicController.Instance.stop((CommandSource)context.getSource());
            return 1;
        }))).then(Commands.func_197057_a((String)"info").executes(context -> {
            SchematicController.Instance.info((CommandSource)context.getSource());
            return 1;
        }))).then(Commands.func_197057_a((String)"list").executes(context -> {
            List<String> list = SchematicController.Instance.list();
            if (list.isEmpty()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("No schemas available"), false);
                return 1;
            }
            String s = "";
            for (String file : list) {
                s = s + file + ", ";
            }
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(s), false);
            return 1;
        }));
        return command;
    }
}

