/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import noppes.npcs.mixin.ListNBTMixin;
import org.apache.commons.io.Charsets;

public class NBTJsonUtil {
    public static String Convert(CompoundNBT compound) {
        ArrayList<JsonLine> list = new ArrayList<JsonLine>();
        JsonLine line = NBTJsonUtil.ReadTag("", (INBT)compound, list);
        line.removeComma();
        return NBTJsonUtil.ConvertList(list);
    }

    public static CompoundNBT Convert(String json) throws JsonException {
        json = json.trim();
        JsonFile file = new JsonFile(json);
        if (!json.startsWith("{") || !json.endsWith("}")) {
            throw new JsonException("Not properly incapsulated between { }", file);
        }
        CompoundNBT compound = new CompoundNBT();
        NBTJsonUtil.FillCompound(compound, file);
        return compound;
    }

    public static void FillCompound(CompoundNBT compound, JsonFile json) throws JsonException {
        if (json.startsWith("{") || json.startsWith(",")) {
            json.cut(1);
        }
        if (json.startsWith("}")) {
            return;
        }
        int index = json.keyIndex();
        if (index < 1) {
            throw new JsonException("Expected key after ,", json);
        }
        String key = json.substring(0, index);
        json.cut(index + 1);
        INBT base = NBTJsonUtil.ReadValue(json);
        if (base == null) {
            base = StringNBT.func_229705_a_((String)"");
        }
        if (key.startsWith("\"")) {
            key = key.substring(1);
        }
        if (key.endsWith("\"")) {
            key = key.substring(0, key.length() - 1);
        }
        compound.func_218657_a(key, base);
        if (json.startsWith(",")) {
            NBTJsonUtil.FillCompound(compound, json);
        }
    }

    public static INBT ReadValue(JsonFile json) throws JsonException {
        if (json.startsWith("{")) {
            CompoundNBT compound = new CompoundNBT();
            NBTJsonUtil.FillCompound(compound, json);
            if (!json.startsWith("}")) {
                throw new JsonException("Expected }", json);
            }
            json.cut(1);
            return compound;
        }
        if (json.startsWith("[")) {
            json.cut(1);
            ListNBT list = new ListNBT();
            if (json.startsWith("B;") || json.startsWith("I;") || json.startsWith("L;")) {
                json.cut(2);
            }
            INBT value = NBTJsonUtil.ReadValue(json);
            while (value != null) {
                list.add((Object)value);
                if (!json.startsWith(",")) break;
                json.cut(1);
                value = NBTJsonUtil.ReadValue(json);
            }
            if (!json.startsWith("]")) {
                throw new JsonException("Expected ]", json);
            }
            json.cut(1);
            if (list.func_230528_d__() == 3) {
                int[] arr = new int[list.size()];
                int i = 0;
                while (list.size() > 0) {
                    arr[i] = ((IntNBT)list.remove(0)).func_150287_d();
                    ++i;
                }
                return new IntArrayNBT(arr);
            }
            if (list.func_230528_d__() == 1) {
                byte[] arr = new byte[list.size()];
                int i = 0;
                while (list.size() > 0) {
                    arr[i] = ((ByteNBT)list.remove(0)).func_150290_f();
                    ++i;
                }
                return new ByteArrayNBT(arr);
            }
            if (list.func_230528_d__() == 4) {
                long[] arr = new long[list.size()];
                int i = 0;
                while (list.size() > 0) {
                    arr[i] = ((LongNBT)list.remove(0)).func_150290_f();
                    ++i;
                }
                return new LongArrayNBT(arr);
            }
            return list;
        }
        if (json.startsWith("\"")) {
            json.cut(1);
            String s = "";
            boolean ignore = false;
            while (!json.startsWith("\"") || ignore) {
                String cut = json.cutDirty(1);
                ignore = cut.equals("\\");
                s = s + cut;
            }
            json.cut(1);
            return StringNBT.func_229705_a_((String)s.replace("\\\\", "\\").replace("\\\"", "\""));
        }
        String s = "";
        while (!json.startsWith(",", "]", "}")) {
            s = s + json.cut(1);
        }
        if ((s = s.trim().toLowerCase()).isEmpty()) {
            return null;
        }
        try {
            if (s.endsWith("d")) {
                return DoubleNBT.func_229684_a_((double)Double.parseDouble(s.substring(0, s.length() - 1)));
            }
            if (s.endsWith("f")) {
                return FloatNBT.func_229689_a_((float)Float.parseFloat(s.substring(0, s.length() - 1)));
            }
            if (s.endsWith("b")) {
                return ByteNBT.func_229671_a_((byte)Byte.parseByte(s.substring(0, s.length() - 1)));
            }
            if (s.endsWith("s")) {
                return ShortNBT.func_229701_a_((short)Short.parseShort(s.substring(0, s.length() - 1)));
            }
            if (s.endsWith("l")) {
                return LongNBT.func_229698_a_((long)Long.parseLong(s.substring(0, s.length() - 1)));
            }
            if (s.contains(".")) {
                return DoubleNBT.func_229684_a_((double)Double.parseDouble(s));
            }
            return IntNBT.func_229692_a_((int)Integer.parseInt(s));
        }
        catch (NumberFormatException ex) {
            throw new JsonException("Unable to convert: " + s + " to a number", json);
        }
    }

    private static JsonLine ReadTag(String name, INBT base, List<JsonLine> list) {
        JsonLine line;
        JsonLine line2;
        if (!name.isEmpty()) {
            name = "\"" + name + "\": ";
        }
        if (base.func_74732_a() == 9) {
            list.add(new JsonLine(name + "["));
            ListNBT tags = (ListNBT)base;
            line2 = null;
            List<INBT> data = ((ListNBTMixin)tags).getList();
            for (INBT b : data) {
                line2 = NBTJsonUtil.ReadTag("", b, list);
            }
            if (line2 != null) {
                line2.removeComma();
            }
            list.add(new JsonLine("]"));
        } else if (base.func_74732_a() == 10) {
            list.add(new JsonLine(name + "{"));
            CompoundNBT compound = (CompoundNBT)base;
            line2 = null;
            for (Object key : compound.func_150296_c()) {
                line2 = NBTJsonUtil.ReadTag(key.toString(), compound.func_74781_a(key.toString()), list);
            }
            if (line2 != null) {
                line2.removeComma();
            }
            list.add(new JsonLine("}"));
        } else if (base.func_74732_a() == 11) {
            list.add(new JsonLine(name + base.toString().replaceFirst(",]", "]")));
        } else if (base.func_74732_a() == 8) {
            list.add(new JsonLine(name + NBTJsonUtil.quoteAndEscape(base.func_150285_a_())));
        } else {
            list.add(new JsonLine(name + base));
        }
        JsonLine jsonLine = line = list.get(list.size() - 1);
        jsonLine.line = jsonLine.line + ",";
        return line;
    }

    private static String ConvertList(List<JsonLine> list) {
        String json = "";
        int tab = 0;
        for (JsonLine tag : list) {
            if (tag.reduceTab()) {
                --tab;
            }
            for (int i = 0; i < tab; ++i) {
                json = json + "    ";
            }
            json = json + tag + "\n";
            if (!tag.increaseTab()) continue;
            ++tab;
        }
        return json;
    }

    public static CompoundNBT LoadFile(File file) throws IOException, JsonException {
        return NBTJsonUtil.Convert(Files.toString((File)file, (Charset)Charsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SaveFile(File file, CompoundNBT compound) throws IOException, JsonException {
        String json = NBTJsonUtil.Convert(compound);
        try (OutputStreamWriter writer = null;){
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);
            writer.write(json);
        }
    }

    public static void main(String[] args) {
        CompoundNBT comp = new CompoundNBT();
        CompoundNBT comp2 = new CompoundNBT();
        comp2.func_74773_a("test", new byte[]{0, 0, 1, 1, 0});
        comp.func_218657_a("comp", (INBT)comp2);
        System.out.println(NBTJsonUtil.Convert(comp));
    }

    public static String quoteAndEscape(String p_193588_0_) {
        StringBuilder stringbuilder = new StringBuilder("\"");
        for (int i = 0; i < p_193588_0_.length(); ++i) {
            char c0 = p_193588_0_.charAt(i);
            if (c0 == '\\' || c0 == '\"') {
                stringbuilder.append('\\');
            }
            stringbuilder.append(c0);
        }
        return stringbuilder.append('\"').toString();
    }

    public static class JsonException
    extends Exception {
        public JsonException(String message, JsonFile json) {
            super(message + ": " + json.getCurrentPos());
        }
    }

    static class JsonFile {
        private String original;
        private String text;

        public JsonFile(String text) {
            this.text = text;
            this.original = text;
        }

        public int keyIndex() {
            boolean hasQuote = false;
            for (int i = 0; i < this.text.length(); ++i) {
                char c = this.text.charAt(i);
                if (i == 0 && c == '\"') {
                    hasQuote = true;
                } else if (hasQuote && c == '\"') {
                    hasQuote = false;
                }
                if (hasQuote || c != ':') continue;
                return i;
            }
            return -1;
        }

        public String cutDirty(int i) {
            String s = this.text.substring(0, i);
            this.text = this.text.substring(i);
            return s;
        }

        public String cut(int i) {
            String s = this.text.substring(0, i);
            this.text = this.text.substring(i).trim();
            return s;
        }

        public String substring(int beginIndex, int endIndex) {
            return this.text.substring(beginIndex, endIndex);
        }

        public int indexOf(String s) {
            return this.text.indexOf(s);
        }

        public String getCurrentPos() {
            int lengthOr = this.original.length();
            int lengthCur = this.text.length();
            int currentPos = lengthOr - lengthCur;
            String done = this.original.substring(0, currentPos);
            String[] lines = done.split("\r\n|\r|\n");
            int pos = 0;
            String line = "";
            if (lines.length > 0) {
                pos = lines[lines.length - 1].length();
                line = this.original.split("\r\n|\r|\n")[lines.length - 1].trim();
            }
            return "Line: " + lines.length + ", Pos: " + pos + ", Text: " + line;
        }

        public boolean startsWith(String ... ss) {
            for (String s : ss) {
                if (!this.text.startsWith(s)) continue;
                return true;
            }
            return false;
        }

        public boolean endsWith(String s) {
            return this.text.endsWith(s);
        }
    }

    static class JsonLine {
        private String line;

        public JsonLine(String line) {
            this.line = line;
        }

        public void removeComma() {
            if (this.line.endsWith(",")) {
                this.line = this.line.substring(0, this.line.length() - 1);
            }
        }

        public boolean reduceTab() {
            int length = this.line.length();
            return length == 1 && (this.line.endsWith("}") || this.line.endsWith("]")) || length == 2 && (this.line.endsWith("},") || this.line.endsWith("],"));
        }

        public boolean increaseTab() {
            return this.line.endsWith("{") || this.line.endsWith("[");
        }

        public String toString() {
            return this.line;
        }
    }
}

