/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NBTTags;
import noppes.npcs.constants.EnumMenuType;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketMenuSave
extends PacketServerBasic {
    private EnumMenuType type;
    private CompoundNBT data;

    public SPacketMenuSave(EnumMenuType type, CompoundNBT data) {
        this.type = type;
        this.data = data;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        if (this.type == EnumMenuType.MOVING_PATH) {
            return item.func_77973_b() == CustomItems.moving;
        }
        return item.func_77973_b() == CustomItems.wand;
    }

    @Override
    public boolean requiresNpc() {
        return true;
    }

    @Override
    public CustomNpcsPermissions.Permission getPermission() {
        if (this.type == EnumMenuType.DISPLAY || this.type == EnumMenuType.MODEL) {
            return CustomNpcsPermissions.NPC_DISPLAY;
        }
        if (this.type == EnumMenuType.STATS) {
            return CustomNpcsPermissions.NPC_STATS;
        }
        if (this.type == EnumMenuType.INVENTORY) {
            return CustomNpcsPermissions.NPC_INVENTORY;
        }
        if (this.type == EnumMenuType.AI) {
            return CustomNpcsPermissions.NPC_AI;
        }
        if (this.type == EnumMenuType.ADVANCED || this.type == EnumMenuType.TRANSFORM || this.type == EnumMenuType.MARK) {
            return CustomNpcsPermissions.NPC_ADVANCED;
        }
        if (this.type == EnumMenuType.MOVING_PATH) {
            return CustomNpcsPermissions.TOOL_PATHER;
        }
        return CustomNpcsPermissions.NPC_GUI;
    }

    public static void encode(SPacketMenuSave msg, PacketBuffer buf) {
        buf.func_179249_a((Enum)msg.type);
        buf.func_150786_a(msg.data);
    }

    public static SPacketMenuSave decode(PacketBuffer buf) {
        return new SPacketMenuSave((EnumMenuType)buf.func_179257_a(EnumMenuType.class), buf.func_150793_b());
    }

    @Override
    protected void handle() {
        if (this.type == EnumMenuType.DISPLAY) {
            this.npc.display.readToNBT(this.data);
        }
        if (this.type == EnumMenuType.STATS) {
            this.npc.stats.readToNBT(this.data);
        }
        if (this.type == EnumMenuType.INVENTORY) {
            this.npc.inventory.load(this.data);
            this.npc.updateAI = true;
        }
        if (this.type == EnumMenuType.AI) {
            this.npc.ais.readToNBT(this.data);
            this.npc.func_70606_j(this.npc.func_110138_aP());
            this.npc.updateAI = true;
        }
        if (this.type == EnumMenuType.ADVANCED) {
            this.npc.advanced.readToNBT(this.data);
            this.npc.updateAI = true;
        }
        if (this.type == EnumMenuType.MODEL) {
            ((EntityCustomNpc)this.npc).modelData.load(this.data);
        }
        if (this.type == EnumMenuType.TRANSFORM) {
            boolean isValid = this.npc.transform.isValid();
            this.npc.transform.readOptions(this.data);
            if (isValid != this.npc.transform.isValid()) {
                this.npc.updateAI = true;
            }
        }
        if (this.type == EnumMenuType.MOVING_PATH) {
            this.npc.ais.setMovingPath(NBTTags.getIntegerArraySet(this.data.func_150295_c("MovingPathNew", 10)));
        }
        if (this.type == EnumMenuType.MARK) {
            MarkData mark = MarkData.get((LivingEntity)this.npc);
            mark.setNBT(this.data);
            mark.syncClients();
        }
        this.npc.updateClient = true;
    }
}

