/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.client;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.npcs.client.controllers.ClientSkinController;
import noppes.npcs.controllers.data.PlayerSkinData;
import noppes.npcs.shared.common.PacketBasic;

public class PacketSyncSkin
extends PacketBasic {
    private final String name;
    private final PlayerSkinData skinData;

    public PacketSyncSkin(String name, PlayerSkinData skinData) {
        this.name = name;
        this.skinData = skinData;
    }

    public static void encode(PacketSyncSkin msg, PacketBuffer buf) {
        buf.func_180714_a(msg.name);
        CompoundNBT tag = new CompoundNBT();
        msg.skinData.saveNBTData(tag);
        buf.func_150786_a(tag);
    }

    public static PacketSyncSkin decode(PacketBuffer buf) {
        String name = buf.func_218666_n();
        CompoundNBT tag = buf.func_150793_b();
        PlayerSkinData skinData = new PlayerSkinData();
        skinData.loadNBTData(tag);
        return new PacketSyncSkin(name, skinData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle() {
        ClientSkinController.addSkinForPlayer(this.name, this.skinData);
    }
}

