/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.IBlockReader;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.client.TextBlockClient;
import noppes.npcs.client.renderer.blocks.BlockRendererInterface;

public class BlockScriptedRenderer
extends BlockRendererInterface<TileScripted> {
    private static Random random = new Random();

    public BlockScriptedRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileScripted tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        matrixStack.func_227860_a_();
        if (this.overrideModel()) {
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227862_a_(2.0f, 2.0f, 2.0f);
            this.renderItem(new ItemStack((IItemProvider)CustomBlocks.scripted), matrixStack, buffer, light, overlay);
        } else {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)tile.rotationY));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)tile.rotationX));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)tile.rotationZ));
            matrixStack.func_227862_a_(tile.scaleX, tile.scaleY, tile.scaleZ);
            Block b = tile.blockModel;
            if (b == null || b == Blocks.field_150350_a || b == CustomBlocks.scripted) {
                matrixStack.func_227861_a_(0.5, 0.5, 0.5);
                matrixStack.func_227862_a_(2.0f, 2.0f, 2.0f);
                this.renderItem(tile.itemModel, matrixStack, buffer, light, overlay);
            } else {
                BlockState state = b.func_176223_P();
                this.renderBlock(tile, b, state, matrixStack, buffer, light, overlay);
                if (b.hasTileEntity(state) && !tile.renderTileErrored) {
                    try {
                        TileEntityRenderer renderer;
                        if (tile.renderTile == null) {
                            TileEntity entity = b.createTileEntity(state, (IBlockReader)tile.func_145831_w());
                            entity.func_226984_a_(tile.func_145831_w(), tile.func_174877_v());
                            tile.renderTile = entity;
                            if (entity instanceof ITickableTileEntity) {
                                tile.renderTileUpdate = (ITickableTileEntity)entity;
                            }
                        }
                        if ((renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tile.renderTile)) != null) {
                            renderer.func_225616_a_(tile.renderTile, partialTicks, matrixStack, buffer, light, overlay);
                        } else {
                            tile.renderTileErrored = true;
                        }
                    }
                    catch (Exception e) {
                        tile.renderTileErrored = true;
                    }
                }
            }
        }
        matrixStack.func_227865_b_();
        if (!tile.text1.text.isEmpty()) {
            this.drawText(matrixStack, tile.text1);
        }
        if (!tile.text2.text.isEmpty()) {
            this.drawText(matrixStack, tile.text2);
        }
        if (!tile.text3.text.isEmpty()) {
            this.drawText(matrixStack, tile.text3);
        }
        if (!tile.text4.text.isEmpty()) {
            this.drawText(matrixStack, tile.text4);
        }
        if (!tile.text5.text.isEmpty()) {
            this.drawText(matrixStack, tile.text5);
        }
        if (!tile.text6.text.isEmpty()) {
            this.drawText(matrixStack, tile.text6);
        }
    }

    private void drawText(MatrixStack matrixStack, TileScripted.TextPlane text1) {
        if (text1.textBlock == null || text1.textHasChanged) {
            text1.textBlock = new TextBlockClient(text1.text, 336, true, Minecraft.func_71410_x().field_71439_g);
            text1.textHasChanged = false;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)text1.rotationY));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)text1.rotationX));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)text1.rotationZ));
        matrixStack.func_227862_a_(text1.scale, text1.scale, 1.0f);
        matrixStack.func_227861_a_((double)text1.offsetX, (double)text1.offsetY, (double)text1.offsetZ);
        float f1 = 0.6666667f;
        float f3 = 0.0133f * f1;
        matrixStack.func_227861_a_(0.0, 0.5, (double)0.01f);
        matrixStack.func_227862_a_(f3, -f3, f3);
        FontRenderer fontrenderer = this.field_228858_b_.field_147557_n;
        float lineOffset = 0.0f;
        if (text1.textBlock.lines.size() < 14) {
            lineOffset = (14.0f - (float)text1.textBlock.lines.size()) / 2.0f;
        }
        for (int i = 0; i < text1.textBlock.lines.size(); ++i) {
            ITextComponent text = text1.textBlock.lines.get(i);
            float f = -fontrenderer.func_238414_a_((ITextProperties)text) / 2;
            double d = lineOffset + (float)i;
            fontrenderer.getClass();
            fontrenderer.func_243248_b(matrixStack, text, f, (float)((int)(d * (9.0 - 0.3))), 0);
        }
        matrixStack.func_227865_b_();
    }

    private void renderItem(ItemStack item, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(item, ItemCameraTransforms.TransformType.FIXED, light, OverlayTexture.field_229196_a_, matrixStack, buffer);
    }

    private void renderBlock(TileScripted tile, Block b, BlockState state, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        matrixStack.func_227860_a_();
        Minecraft.func_71410_x().func_175602_ab().func_228791_a_(state, matrixStack, buffer, light, OverlayTexture.field_229196_a_);
        if (random.nextInt(12) == 1) {
            state.func_177230_c().func_180655_c(state, tile.func_145831_w(), tile.func_174877_v(), random);
        }
        matrixStack.func_227865_b_();
    }

    private boolean overrideModel() {
        ItemStack held = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        if (held == null) {
            return false;
        }
        return held.func_77973_b() == CustomItems.wand || held.func_77973_b() == CustomItems.scripter;
    }
}

