/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import noppes.npcs.client.renderer.ImageDownloadAlt;

public class Model2DRenderer
extends ModelRenderer {
    private static final RenderTypeBuffers typeBuffer = new RenderTypeBuffers();
    private VertexBuffer cache = null;
    private final float x1;
    private final float x2;
    private final float y1;
    private final float y2;
    private final int width;
    private final int height;
    private final int xTex;
    private final int yTex;
    private float rotationOffsetX;
    private float rotationOffsetY;
    private float rotationOffsetZ;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float thickness = 1.0f;
    private int displayList;
    private boolean isCompiled = false;
    public static final VertexFormat POSITION_TEX_NORMAL = new VertexFormat(ImmutableList.builder().add((Object)DefaultVertexFormats.field_181713_m).add((Object)DefaultVertexFormats.field_181715_o).add((Object)DefaultVertexFormats.field_181717_q).add((Object)DefaultVertexFormats.field_181718_r).build());
    private TexturedQuad[] quads = new TexturedQuad[6];

    public Model2DRenderer(Model base, float x, float y, int width, int height, int texWidth, int texHeight) {
        super(base.field_78090_t, base.field_78089_u, 0, 0);
        this.width = width;
        this.height = height;
        this.xTex = (int)x;
        this.yTex = (int)y;
        this.func_78787_b(texWidth, texHeight);
        this.x1 = x / (float)texWidth;
        this.y1 = y / (float)texHeight;
        this.x2 = (x + (float)width) / (float)texWidth;
        this.y2 = (y + (float)height) / (float)texHeight;
        this.init();
    }

    public Model2DRenderer(Model modelBase, float x, float y, int width, int height) {
        this(modelBase, x, y, width, height, modelBase.field_78090_t, modelBase.field_78089_u);
    }

    public Model2DRenderer(Model modelBase, float x, float y, int width, int height, ResourceLocation location) {
        this(modelBase, x, y, width, height, modelBase.field_78090_t, modelBase.field_78089_u);
        this.init(location);
    }

    public Model2DRenderer(int x, int y, int width, int height, int texWidth, int texHeight) {
        super(texWidth, texHeight, x, y);
        this.width = width;
        this.height = height;
        this.xTex = x;
        this.yTex = y;
        this.func_78787_b(texWidth, texHeight);
        this.x1 = (float)x / (float)texWidth;
        this.y1 = (float)y / (float)texHeight;
        this.x2 = ((float)x + (float)width) / (float)texWidth;
        this.y2 = ((float)y + (float)height) / (float)texHeight;
        this.init();
    }

    public void init(ResourceLocation location) {
        int n;
        float f9;
        float f8;
        float f7;
        int k;
        BufferedImage image;
        block44: {
            if (location == null) {
                return;
            }
            image = null;
            try (IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(location);){
                image = ImageIO.read(resource.func_199027_b());
            }
            catch (Exception e) {
                Texture text = Minecraft.func_71410_x().func_110434_K().func_229267_b_(location);
                if (text == null || !(text instanceof ImageDownloadAlt)) break block44;
                try (FileInputStream input2 = new FileInputStream(((ImageDownloadAlt)text).cacheFile);){
                    image = ImageIO.read(input2);
                }
                catch (Exception input2) {
                    // empty catch block
                }
            }
        }
        if (image == null) {
            return;
        }
        int width = this.width * (image.getWidth() / 64);
        int height = this.height * (image.getHeight() / 64);
        int xTex = this.xTex * (image.getWidth() / 64);
        int yTex = this.yTex * (image.getHeight() / 64);
        ArrayList<PositionTextureVertex> list = new ArrayList<PositionTextureVertex>();
        list.add(new PositionTextureVertex(0.0f, 0.0f, 0.0f, this.x1, this.y2));
        list.add(new PositionTextureVertex(1.0f, 0.0f, 0.0f, this.x2, this.y2));
        list.add(new PositionTextureVertex(1.0f, 1.0f, 0.0f, this.x2, this.y1));
        list.add(new PositionTextureVertex(0.0f, 1.0f, 0.0f, this.x1, this.y1));
        this.quads[0] = new TexturedQuad(0.0f, 0.0f, 1.0f, list.toArray(new PositionTextureVertex[0]));
        list = new ArrayList();
        this.quads[1] = new TexturedQuad(0.0f, 0.0f, -1.0f, list.toArray(new PositionTextureVertex[0]));
        list = new ArrayList();
        ArrayList<PositionTextureVertex> list2 = new ArrayList<PositionTextureVertex>();
        for (k = 0; k < width; ++k) {
            f7 = (float)k / (float)width;
            f8 = this.x1 + (this.x2 - this.x1) * f7 - 0.5f * (this.x1 - this.x2) / (float)width;
            f9 = f7 + 1.0f / (float)width;
            boolean left = false;
            boolean right = false;
            for (n = 0; n < height; ++n) {
                if ((image.getRGB(xTex + k, yTex + n) >> 24 & 0xFF) < 128) continue;
                if (k + 1 < width && (image.getRGB(xTex + k + 1, yTex + n) >> 24 & 0xFF) < 128) {
                    right = true;
                } else if (k + 1 == width) {
                    right = true;
                }
                if (k > 0 && (image.getRGB(xTex + k - 1, yTex + n) >> 24 & 0xFF) < 128) {
                    left = true;
                    continue;
                }
                if (k != 0) continue;
                left = true;
            }
            if (left) {
                list.add(new PositionTextureVertex(f7, 0.0f, -0.0625f, f8, this.y2));
                list.add(new PositionTextureVertex(f7, 0.0f, 0.0f, f8, this.y2));
                list.add(new PositionTextureVertex(f7, 1.0f, 0.0f, f8, this.y1));
                list.add(new PositionTextureVertex(f7, 1.0f, -0.0625f, f8, this.y1));
            }
            if (!right) continue;
            list2.add(new PositionTextureVertex(f9, 1.0f, -0.0625f, f8, this.y1));
            list2.add(new PositionTextureVertex(f9, 1.0f, 0.0f, f8, this.y1));
            list2.add(new PositionTextureVertex(f9, 0.0f, 0.0f, f8, this.y2));
            list2.add(new PositionTextureVertex(f9, 0.0f, -0.0625f, f8, this.y2));
        }
        this.quads[2] = new TexturedQuad(-1.0f, 0.0f, 0.0f, list.toArray(new PositionTextureVertex[0]));
        this.quads[3] = new TexturedQuad(1.0f, 0.0f, 0.0f, list2.toArray(new PositionTextureVertex[0]));
        list = new ArrayList();
        list2 = new ArrayList();
        for (k = 0; k < height; ++k) {
            f7 = (float)k / (float)height;
            f8 = this.y2 + (this.y1 - this.y2) * f7 - 0.5f * (this.y2 - this.y1) / (float)height;
            f9 = f7 + 1.0f / (float)height;
            boolean top = false;
            boolean bottom = false;
            for (n = 0; n < width; ++n) {
                int m = height - k - 1;
                if ((image.getRGB(xTex + n, yTex + m) >> 24 & 0xFF) < 128) continue;
                if (m > 0 && (image.getRGB(xTex + n, yTex + m - 1) >> 24 & 0xFF) < 128) {
                    top = true;
                } else if (m == 0) {
                    top = true;
                }
                if (m + 1 < height && (image.getRGB(xTex + n, yTex + m + 1) >> 24 & 0xFF) < 128) {
                    bottom = true;
                    continue;
                }
                if (m + 1 != height) continue;
                bottom = true;
            }
            if (bottom) {
                list2.add(new PositionTextureVertex(1.0f, f7, 0.0f, this.x2, f8));
                list2.add(new PositionTextureVertex(0.0f, f7, 0.0f, this.x1, f8));
                list2.add(new PositionTextureVertex(0.0f, f7, -0.0625f, this.x1, f8));
                list2.add(new PositionTextureVertex(1.0f, f7, -0.0625f, this.x2, f8));
            }
            if (!top) continue;
            list.add(new PositionTextureVertex(0.0f, f9, 0.0f, this.x1, f8));
            list.add(new PositionTextureVertex(1.0f, f9, 0.0f, this.x2, f8));
            list.add(new PositionTextureVertex(1.0f, f9, -0.0625f, this.x2, f8));
            list.add(new PositionTextureVertex(0.0f, f9, -0.0625f, this.x1, f8));
        }
        this.quads[4] = new TexturedQuad(0.0f, 1.0f, 0.0f, list.toArray(new PositionTextureVertex[0]));
        this.quads[5] = new TexturedQuad(0.0f, -1.0f, 0.0f, list2.toArray(new PositionTextureVertex[0]));
    }

    private void init() {
        float f9;
        float f8;
        float f7;
        int k;
        this.func_228300_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        ArrayList<PositionTextureVertex> list = new ArrayList<PositionTextureVertex>();
        list.add(new PositionTextureVertex(0.0f, 0.0f, 0.0f, this.x1, this.y2));
        list.add(new PositionTextureVertex(1.0f, 0.0f, 0.0f, this.x2, this.y2));
        list.add(new PositionTextureVertex(1.0f, 1.0f, 0.0f, this.x2, this.y1));
        list.add(new PositionTextureVertex(0.0f, 1.0f, 0.0f, this.x1, this.y1));
        this.quads[0] = new TexturedQuad(0.0f, 0.0f, 1.0f, list.toArray(new PositionTextureVertex[0]));
        list = new ArrayList();
        list.add(new PositionTextureVertex(0.0f, 1.0f, -0.0625f, this.x1, this.y1));
        list.add(new PositionTextureVertex(1.0f, 1.0f, -0.0625f, this.x2, this.y1));
        list.add(new PositionTextureVertex(1.0f, 0.0f, -0.0625f, this.x2, this.y2));
        list.add(new PositionTextureVertex(0.0f, 0.0f, -0.0625f, this.x1, this.y2));
        this.quads[1] = new TexturedQuad(0.0f, 0.0f, -1.0f, list.toArray(new PositionTextureVertex[0]));
        list = new ArrayList();
        ArrayList<PositionTextureVertex> list2 = new ArrayList<PositionTextureVertex>();
        for (k = 0; k < this.width; ++k) {
            f7 = (float)k / (float)this.width;
            f8 = this.x1 + (this.x2 - this.x1) * f7 - 0.5f * (this.x1 - this.x2) / (float)this.width;
            f9 = f7 + 1.0f / (float)this.width;
            list.add(new PositionTextureVertex(f7, 0.0f, -0.0625f, f8, this.y2));
            list.add(new PositionTextureVertex(f7, 0.0f, 0.0f, f8, this.y2));
            list.add(new PositionTextureVertex(f7, 1.0f, 0.0f, f8, this.y1));
            list.add(new PositionTextureVertex(f7, 1.0f, -0.0625f, f8, this.y1));
            list2.add(new PositionTextureVertex(f9, 1.0f, -0.0625f, f8, this.y1));
            list2.add(new PositionTextureVertex(f9, 1.0f, 0.0f, f8, this.y1));
            list2.add(new PositionTextureVertex(f9, 0.0f, 0.0f, f8, this.y2));
            list2.add(new PositionTextureVertex(f9, 0.0f, -0.0625f, f8, this.y2));
        }
        this.quads[2] = new TexturedQuad(-1.0f, 0.0f, 0.0f, list.toArray(new PositionTextureVertex[0]));
        this.quads[3] = new TexturedQuad(1.0f, 0.0f, 0.0f, list2.toArray(new PositionTextureVertex[0]));
        list = new ArrayList();
        list2 = new ArrayList();
        for (k = 0; k < this.height; ++k) {
            f7 = (float)k / (float)this.height;
            f8 = this.y2 + (this.y1 - this.y2) * f7 - 0.5f * (this.y2 - this.y1) / (float)this.height;
            f9 = f7 + 1.0f / (float)this.height;
            list.add(new PositionTextureVertex(0.0f, f9, 0.0f, this.x1, f8));
            list.add(new PositionTextureVertex(1.0f, f9, 0.0f, this.x2, f8));
            list.add(new PositionTextureVertex(1.0f, f9, -0.0625f, this.x2, f8));
            list.add(new PositionTextureVertex(0.0f, f9, -0.0625f, this.x1, f8));
            list2.add(new PositionTextureVertex(1.0f, f7, 0.0f, this.x2, f8));
            list2.add(new PositionTextureVertex(0.0f, f7, 0.0f, this.x1, f8));
            list2.add(new PositionTextureVertex(0.0f, f7, -0.0625f, this.x1, f8));
            list2.add(new PositionTextureVertex(1.0f, f7, -0.0625f, this.x2, f8));
        }
        this.quads[4] = new TexturedQuad(0.0f, 1.0f, 0.0f, list.toArray(new PositionTextureVertex[0]));
        this.quads[5] = new TexturedQuad(0.0f, -1.0f, 0.0f, list2.toArray(new PositionTextureVertex[0]));
    }

    public void func_228309_a_(MatrixStack mstack, IVertexBuilder builder, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!this.field_78806_j) {
            return;
        }
        float f = 0.0625f;
        mstack.func_227860_a_();
        this.func_228307_a_(mstack);
        mstack.func_227861_a_((double)(this.rotationOffsetX * f), (double)(this.rotationOffsetY * f), (double)(this.rotationOffsetZ * f));
        mstack.func_227862_a_(this.scaleX * (float)this.width / (float)this.height, this.scaleY, this.thickness);
        mstack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        if (this.field_78809_i) {
            mstack.func_227861_a_(0.0, 0.0, (double)(-1.0f * f));
            mstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        }
        this.renderModel(mstack.func_227866_c_().func_227872_b_(), mstack.func_227866_c_().func_227870_a_(), builder, light, overlay, red, green, blue, alpha);
        mstack.func_227865_b_();
    }

    public void render(MatrixStack mstack, int light, int overlay, float red, float green, float blue, float alpha, ResourceLocation resource) {
        if (!this.field_78806_j) {
            return;
        }
        RenderType rType = RenderType.func_228646_f_((ResourceLocation)resource);
        if (this.cache == null) {
            this.cache = new VertexBuffer(DefaultVertexFormats.field_227849_i_);
            MatrixStack mmstack = new MatrixStack();
            mmstack.func_227860_a_();
            IRenderTypeBuffer.Impl impl = typeBuffer.func_228487_b_();
            BufferBuilder bufferbuilder = (BufferBuilder)impl.getBuffer(rType);
            this.renderModel(mmstack.func_227866_c_().func_227872_b_(), mmstack.func_227866_c_().func_227870_a_(), (IVertexBuilder)bufferbuilder, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            bufferbuilder.func_178977_d();
            this.cache.func_227875_a_(bufferbuilder);
            mmstack.func_227865_b_();
            impl.func_228461_a_();
        }
        mstack.func_227860_a_();
        this.func_228307_a_(mstack);
        float f = 0.0625f;
        mstack.func_227861_a_((double)(this.rotationOffsetX * f), (double)(this.rotationOffsetY * f), (double)(this.rotationOffsetZ * f));
        mstack.func_227862_a_(this.scaleX * (float)this.width / (float)this.height, this.scaleY, this.thickness);
        mstack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        if (this.field_78809_i) {
            mstack.func_227861_a_(0.0, 0.0, (double)(-1.0f * f));
            mstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        }
        MatrixStack.Entry entry = mstack.func_227866_c_();
        Matrix4f matrix = entry.func_227870_a_();
        rType.func_228547_a_();
        this.cache.func_177359_a();
        DefaultVertexFormats.field_227849_i_.func_227892_a_(0L);
        RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.cache.func_227874_a_(matrix, 7);
        VertexBuffer.func_177361_b();
        DefaultVertexFormats.field_227849_i_.func_227895_d_();
        rType.func_228549_b_();
        mstack.func_227865_b_();
    }

    public void renderModel(Matrix3f matrix3f, Matrix4f matrix4f, IVertexBuilder builder, int light, int overlay, float red, float green, float blue, float alpha) {
        for (TexturedQuad quad : this.quads) {
            Vector3f vector3f = quad.normal.func_229195_e_();
            vector3f.func_229188_a_(matrix3f);
            float nX = vector3f.func_195899_a();
            float nY = vector3f.func_195900_b();
            float nZ = vector3f.func_195902_c();
            for (PositionTextureVertex vec : quad.vertices) {
                Vector4f vector4f = new Vector4f(vec.pos);
                vector4f.func_229372_a_(matrix4f);
                builder.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c());
                builder.func_227885_a_(red, green, blue, alpha);
                builder.func_225583_a_(vec.u, vec.v);
                builder.func_227891_b_(overlay);
                builder.func_227886_a_(light);
                builder.func_225584_a_(nX, nY, nZ);
                builder.func_181675_d();
            }
        }
    }

    private void addVertex(IVertexBuilder builder, Matrix4f matrix, float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        Vector4f v = new Vector4f(x, y, z, 1.0f);
        v.func_229372_a_(matrix);
        builder.func_225582_a_((double)v.func_195910_a(), (double)v.func_195913_b(), (double)v.func_195914_c());
        builder.func_227885_a_(red, green, blue, alpha);
        builder.func_225583_a_(texU, texV);
        builder.func_227891_b_(overlayUV);
        builder.func_227886_a_(lightmapUV);
        builder.func_225584_a_(normalX, normalY, normalZ);
        builder.func_181675_d();
    }

    public void setRotationOffset(float x, float y, float z) {
        this.rotationOffsetX = x;
        this.rotationOffsetY = y;
        this.rotationOffsetZ = z;
    }

    public void setScale(float scale) {
        this.scaleX = scale;
        this.scaleY = scale;
    }

    public void setScale(float x, float y) {
        this.scaleX = x;
        this.scaleY = y;
    }

    public void setThickness(float thickness) {
        this.thickness = thickness;
    }

    static class PositionTextureVertex {
        public final Vector3f pos;
        public final float u;
        public final float v;

        public PositionTextureVertex(float x, float y, float z, float u, float v) {
            this.pos = new Vector3f(x, y, z);
            this.u = u;
            this.v = v;
        }
    }

    static class TexturedQuad {
        public final PositionTextureVertex[] vertices;
        public final Vector3f normal;

        public TexturedQuad(float x, float y, float z, PositionTextureVertex[] vertices) {
            this.normal = new Vector3f(x, y, z);
            this.vertices = vertices;
        }
    }
}

