/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player.moderngui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.TextBlockClient;
import noppes.npcs.client.gui.player.GuiDialogInteract;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.MouseHelperMixin;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketDialogSelected;
import noppes.npcs.packets.server.SPacketQuestCompletionCheckAll;
import noppes.npcs.shared.client.gui.listeners.IGuiClose;

public class GuiQuestModern
extends GuiNPCInterface
implements IGuiClose {
    private final ResourceLocation decomposed = new ResourceLocation("customnpcs", "textures/gui/dialog_menu_decomposed.png");
    private boolean isGrabbed = false;
    private final Dialog prevDialog;
    private final int optionId;
    private final Quest quest;
    private double wcoeff = 1.0;

    public GuiQuestModern(EntityNPCInterface npc, Quest quest, Dialog prevDialog, int optionId) {
        super(npc);
        this.imageHeight = 238;
        this.prevDialog = prevDialog;
        this.quest = quest;
        this.optionId = optionId;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.isGrabbed = false;
        this.grabMouse(false);
        this.guiTop = this.field_230709_l_ - this.imageHeight;
        this.func_230480_a_((Widget)new ImageButton(720, 326, 78, 20, 36, 27, 22, this.decomposed, 256, 256, button -> {
            Packets.sendServer(new SPacketDialogSelected(this.prevDialog.id, -1));
            this.closed();
            this.func_231175_as__();
        }));
        this.func_230480_a_((Widget)new ImageButton(812, 326, 78, 20, 36, 27, 22, this.decomposed, 256, 256, button -> {
            if (this.optionId != -2) {
                Packets.sendServer(new SPacketDialogSelected(this.prevDialog.id, this.optionId));
            } else {
                CustomNpcs.proxy.openGui((PlayerEntity)this.player, new GuiDialogInteract(this.npc, this.prevDialog));
            }
        }));
    }

    public void grabMouse(boolean grab) {
        if (grab && !this.isGrabbed) {
            MouseHelperMixin mouse = (MouseHelperMixin)Minecraft.func_71410_x().field_71417_B;
            mouse.setGrabbed(false);
            double xpos = 0.0;
            double ypos = 0.0;
            mouse.setX(xpos);
            mouse.setY(ypos);
            InputMappings.func_216504_a((long)this.field_230706_i_.func_228018_at_().func_198092_i(), (int)212995, (double)xpos, (double)ypos);
            this.isGrabbed = true;
        } else if (!grab && this.isGrabbed) {
            Minecraft.func_71410_x().field_71417_B.func_198032_j();
            this.isGrabbed = false;
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int fac2ID;
        int fac1ID;
        this.func_238468_a_(matrixStack, 0, 0, this.field_230708_k_, this.field_230709_l_, 0x66000000, 0x66000000);
        this.wcoeff = (double)this.field_230708_k_ / 960.0;
        double hcoeff = (double)this.field_230709_l_ / 509.0;
        if (!(this.npc instanceof EntityDialogNpc)) {
            this.drawNpc((LivingEntity)this.npc, -210 + (int)(300.0 * (1.0 - this.wcoeff)), 350 - (int)(100.0 * (1.0 - hcoeff)), (float)(9.5 * hcoeff), -20);
        }
        int textBlockWidth = 700;
        String takeQuestString = this.translate("questgui.doyouaccept");
        int lineCount = this.getLineCount(takeQuestString, textBlockWidth);
        int gap = Math.max(16, Math.min((int)(2.6f * (float)lineCount), 32));
        int textPartHeight = 26 + lineCount * ClientProxy.Font.height(null) + 2 * gap;
        this.func_238468_a_(matrixStack, 0, this.field_230709_l_ - textPartHeight, this.field_230708_k_, this.field_230709_l_, -1728053248, -1728053248);
        this.drawLine(matrixStack, 23, this.field_230709_l_ - textPartHeight + 23, this.field_230708_k_ - 23);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.5, (double)200.065f);
        matrixStack.func_227862_a_(1.5f, 1.5f, 1.0f);
        AbstractGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.npc.func_145748_c_(), (int)31, (int)((int)((double)(this.field_230709_l_ - textPartHeight + 5) / 1.5)), (int)-1);
        matrixStack.func_227862_a_(0.6666667f, 0.6666667f, 1.0f);
        this.drawTextBlock(matrixStack, takeQuestString, (this.field_230708_k_ - textBlockWidth) / 2, this.field_230709_l_ - textPartHeight + 23 + 3 + gap, textBlockWidth, -1);
        matrixStack.func_227862_a_((float)this.wcoeff, (float)this.wcoeff, (float)this.wcoeff);
        HashMap<Integer, QuestData> activeQuests = PlayerData.get((PlayerEntity)this.player).questData.activeQuests;
        boolean hadQuest = activeQuests.containsKey(this.quest.id);
        activeQuests.put(this.quest.id, new QuestData(this.quest));
        StringBuilder objectiveString = new StringBuilder();
        String[] questType = new String[]{this.translate("questgui.bringitems"), this.translate("questgui.readdialog"), this.translate("questgui.killmobs"), this.translate("questgui.findlocation"), this.translate("questgui.defeat")};
        for (IQuestObjective objective : this.quest.questInterface.getObjectives((PlayerEntity)this.player)) {
            if (objective == null) continue;
            objectiveString.append("- ").append(questType[this.quest.getType()]).append(": ").append(objective.getText()).append("\n");
        }
        if (!hadQuest) {
            activeQuests.remove(this.quest.id);
        }
        int questLineCount = this.getLineCount(this.quest.logText, 180);
        int objectivesLineCount = this.getLineCount(objectiveString.toString(), 180);
        int topToTextBottom = 78 + questLineCount * ClientProxy.Font.height(null) + 20;
        int topToObjectivesBottom = topToTextBottom + 19 + objectivesLineCount * ClientProxy.Font.height(null) + 14;
        int rewardCount = 0;
        ArrayList<Integer> facIDs = new ArrayList<Integer>();
        for (Integer facID : new Integer[]{this.quest.factionOptions.factionId, this.quest.factionOptions.faction2Id}) {
            if (facID == -1) continue;
            facIDs.add(facID);
        }
        for (IItemStack reward : this.quest.getRewards().getItems()) {
            if (reward.isEmpty()) continue;
            ++rewardCount;
        }
        int topToRewardsBottom = topToObjectivesBottom + (rewardCount == 0 ? 0 : 49);
        int topToExpBottom = topToRewardsBottom + (this.quest.rewardExp == 0 ? 0 : 12);
        int topToFactionBottom = topToExpBottom + facIDs.size() * 15;
        int questBlockHeight = topToFactionBottom + 28;
        this.func_238468_a_(matrixStack, 675, 40, 935, questBlockHeight, -1157627904, -1157627904);
        matrixStack.func_227862_a_(1.5f, 1.5f, 1.0f);
        AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.quest.getName(), (int)461, (int)33, (int)-1);
        matrixStack.func_227862_a_(0.6666667f, 0.6666667f, 1.0f);
        this.drawLine(matrixStack, 686, 66, 924);
        this.drawTextBlock(matrixStack, this.quest.logText, 715, 80, 180, 0xB8B8B8);
        AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.translate("questgui.objectives"), (int)690, (int)topToTextBottom, (int)-1);
        this.drawLeftAllignedTextBlock(matrixStack, objectiveString.toString(), 705, topToTextBottom + 12, 180, 0xB8B8B8);
        if (rewardCount != 0) {
            AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.translate("questgui.rewards"), (int)690, (int)topToObjectivesBottom, (int)-1);
        }
        for (int i = 0; i < this.quest.rewardItems.func_70302_i_(); ++i) {
            ItemStack rewardStack = this.quest.rewardItems.func_70301_a(i);
            if (rewardStack == null || rewardStack.func_190926_b()) continue;
            this.field_230706_i_.func_110434_K().func_110577_a(this.decomposed);
            this.func_238474_b_(matrixStack, 690 + 26 * i, topToObjectivesBottom + 16, 0, 27, 24, 24);
            RenderSystem.scaled((double)this.wcoeff, (double)this.wcoeff, (double)this.wcoeff);
            this.field_230707_j_.func_184391_a((LivingEntity)this.player, rewardStack, 694 + 26 * i, topToObjectivesBottom + 20);
            this.field_230707_j_.func_180453_a(this.field_230712_o_, rewardStack, 694 + 26 * i, topToObjectivesBottom + 20, "" + rewardStack.func_190916_E());
            RenderSystem.scaled((double)(1.0 / this.wcoeff), (double)(1.0 / this.wcoeff), (double)(1.0 / this.wcoeff));
        }
        if (this.quest.rewardExp != 0) {
            AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.translate("questgui.experience"), (int)690, (int)topToRewardsBottom, (int)0xB8B8B8);
            int expPosX = 690 + ClientProxy.Font.width(this.translate("questgui.experience") + "     ");
            AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)("" + this.quest.rewardExp), (int)expPosX, (int)topToRewardsBottom, (int)-1);
            int expSymbolPosX = expPosX + ClientProxy.Font.width(this.quest.rewardExp + "  ");
            this.field_230706_i_.func_110434_K().func_110577_a(this.decomposed);
            this.func_238474_b_(matrixStack, expSymbolPosX, topToRewardsBottom, 26, 27, 8, 8);
        }
        if ((fac1ID = this.quest.factionOptions.factionId) != -1) {
            String fac1Name = FactionController.instance.getFaction(fac1ID).getName();
            String fac1Color = this.quest.factionOptions.decreaseFactionPoints ? "\u00a7c-" : "\u00a7a+";
            int fac1Point = this.quest.factionOptions.factionPoints;
            int facIDIndex = facIDs.indexOf(fac1ID);
            AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(fac1Name + " " + fac1Color + fac1Point), (int)690, (int)(topToExpBottom + facIDIndex * 12), (int)0xB8B8B8);
        }
        if ((fac2ID = this.quest.factionOptions.faction2Id) != -1) {
            String fac2Name = FactionController.instance.getFaction(fac2ID).getName();
            String fac2Color = this.quest.factionOptions.decreaseFaction2Points ? "\u00a7c-" : "\u00a7a+";
            int fac2Point = this.quest.factionOptions.faction2Points;
            int facIDIndex = facIDs.indexOf(fac2ID);
            AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(fac2Name + " " + fac2Color + fac2Point), (int)690, (int)(topToExpBottom + facIDIndex * 12), (int)0xB8B8B8);
        }
        ((Widget)this.field_230710_m_.get((int)0)).field_230691_m_ = topToFactionBottom;
        ((Widget)this.field_230710_m_.get((int)1)).field_230691_m_ = topToFactionBottom;
        super.func_230430_a_(matrixStack, (int)((double)mouseX / this.wcoeff), (int)((double)mouseY / this.wcoeff), partialTicks);
        String reject = this.translate("questgui.reject");
        AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)reject, (int)(753 - ClientProxy.Font.width(reject) / 2), (int)(topToFactionBottom + 6), (int)-1);
        String accept = this.translate("questgui.accept");
        AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)accept, (int)(847 - ClientProxy.Font.width(accept) / 2), (int)(topToFactionBottom + 6), (int)-1);
        matrixStack.func_227865_b_();
    }

    public void drawLine(MatrixStack stack, int x, int y, int width) {
        GuiQuestModern.func_238467_a_((MatrixStack)stack, (int)x, (int)y, (int)width, (int)(y + 1), (int)-7522304);
        GuiQuestModern.func_238467_a_((MatrixStack)stack, (int)x, (int)(y + 1), (int)width, (int)(y + 2), (int)-88773);
        GuiQuestModern.func_238467_a_((MatrixStack)stack, (int)x, (int)(y + 2), (int)width, (int)(y + 3), (int)-5352703);
    }

    public String translate(String key) {
        return I18n.func_135052_a((String)key, (Object[])new Object[0]);
    }

    @Override
    public void drawNpc(LivingEntity entity, int x, int y, float zoomed, int rotation) {
        EntityCustomNpc npc = null;
        if (entity instanceof EntityCustomNpc) {
            npc = (EntityCustomNpc)entity;
        }
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        float scale = 1.0f;
        if ((double)entity.func_213302_cg() > 2.4) {
            scale = 2.0f / entity.func_213302_cg();
        }
        float f7 = this.guiLeft + x;
        entity.field_70761_aq = 0.0f;
        entity.field_70177_z = (float)Math.atan(f7 / 80.0f) * 40.0f + (float)rotation;
        entity.field_70125_A = 0.0f;
        entity.field_70759_as = 0.0f;
        entity.field_70758_at = 0.0f;
        int orientation = 0;
        int showName = 0;
        if (npc != null) {
            showName = npc.display.getShowName();
            npc.display.setShowName(1);
            orientation = npc.ais.orientation;
            npc.ais.orientation = rotation;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)this.guiLeft + (float)x), (float)(this.guiTop + y), (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixStack.func_227862_a_(30.0f * scale * zoomed, 30.0f * scale * zoomed, 30.0f * scale * zoomed);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        EntityRendererManager lvt_16_1_ = Minecraft.func_71410_x().func_175598_ae();
        lvt_16_1_.func_178633_a(false);
        IRenderTypeBuffer.Impl lvt_17_1_ = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_((float)rotation));
        RenderSystem.runAsFancy(() -> lvt_16_1_.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)lvt_17_1_, 0xF000F0));
        lvt_17_1_.func_228461_a_();
        lvt_16_1_.func_178633_a(true);
        RenderSystem.popMatrix();
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        if (npc != null) {
            npc.display.setShowName(showName);
            npc.ais.orientation = orientation;
        }
    }

    public void func_238651_a_(MatrixStack matrixStack, int p_238651_2_) {
    }

    @Override
    public boolean func_231044_a_(double i, double j, int k) {
        super.func_231044_a_(i / this.wcoeff, j / this.wcoeff, k);
        return true;
    }

    private void closed() {
        this.grabMouse(false);
        Packets.sendServer(new SPacketQuestCompletionCheckAll());
    }

    public void drawTextBlock(MatrixStack stack, String text, int x, int y, int width, int color) {
        TextBlockClient block = new TextBlockClient("", text, width, -1, new Object[]{this.player, this.npc});
        int count = 0;
        for (ITextComponent line : block.lines) {
            int height = y + count * ClientProxy.Font.height(null);
            AbstractGui.func_238472_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)line, (int)(x + width / 2), (int)height, (int)color);
            ++count;
        }
    }

    public void drawLeftAllignedTextBlock(MatrixStack stack, String text, int x, int y, int width, int color) {
        TextBlockClient block = new TextBlockClient("", text, width, -1, new Object[]{this.player, this.npc});
        int count = 0;
        for (ITextComponent line : block.lines) {
            int height = y + count * ClientProxy.Font.height(null);
            AbstractGui.func_238475_b_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)line, (int)x, (int)height, (int)color);
            ++count;
        }
    }

    public int getLineCount(String text, int width) {
        TextBlockClient block = new TextBlockClient("", text, width, -1, new Object[]{this.player, this.npc});
        return block.lines.size();
    }

    @Override
    public void setClose(CompoundNBT data) {
        this.grabMouse(false);
    }
}

