/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import noppes.npcs.blocks.tiles.TileBuilder;
import noppes.npcs.client.renderer.MarkRenderer;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketPlayerSoundPlays;
import noppes.npcs.schematics.SchematicWrapper;
import noppes.npcs.shared.common.util.LogWriter;

public class ClientEventHandler {
    private VertexBuffer cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRenderTick(MatrixStack matrixStack, BlockPos rpos, TileEntity te) {
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (rpos == null || rpos == BlockPos.field_177992_a || rpos.func_177951_i((Vector3i)player.func_233580_cy_()) > 1000000.0) {
            return;
        }
        TileBuilder tile = (TileBuilder)te;
        SchematicWrapper schem = tile.getSchematic();
        if (schem == null) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(1.0, (double)tile.yOffest, 1.0);
        if (!TileBuilder.Compiled) {
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            try {
                for (int i = 0; i < schem.size && i < 25000; ++i) {
                    BlockState state = schem.schema.getBlockState(i);
                    if (state.func_185901_i() == BlockRenderType.INVISIBLE || state.func_185901_i() != BlockRenderType.MODEL) continue;
                    int posX = i % schem.schema.getWidth();
                    int posZ = (i - posX) / schem.schema.getWidth() % schem.schema.getLength();
                    int posY = ((i - posX) / schem.schema.getWidth() - posZ) / schem.schema.getLength();
                    BlockPos pos = schem.rotatePos(posX, posY, posZ, tile.rotation);
                    matrixStack.func_227860_a_();
                    matrixStack.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    state = schem.rotationState(state, tile.rotation);
                    try {
                        IBakedModel ibakedmodel = dispatcher.func_184389_a(state);
                        BufferBuilder builder = (BufferBuilder)buffer.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)state, (boolean)false));
                        dispatcher.func_175019_b().renderModel(matrixStack.func_227866_c_(), (IVertexBuilder)builder, state, ibakedmodel, 1.0f, 1.0f, 1.0f, 10000, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    finally {
                        matrixStack.func_227865_b_();
                    }
                }
            }
            catch (Exception e) {
                LogWriter.error("Error preview builder block", e);
            }
        }
        if (tile.rotation % 2 == 0) {
            ClientEventHandler.drawSelectionBox(matrixStack, (IRenderTypeBuffer)buffer, new BlockPos((int)schem.schema.getWidth(), (int)schem.schema.getHeight(), (int)schem.schema.getLength()));
        } else {
            ClientEventHandler.drawSelectionBox(matrixStack, (IRenderTypeBuffer)buffer, new BlockPos((int)schem.schema.getLength(), (int)schem.schema.getHeight(), (int)schem.schema.getWidth()));
        }
        matrixStack.func_227865_b_();
    }

    @SubscribeEvent
    public void post(RenderLivingEvent.Post event) {
        MarkData data = MarkData.get(event.getEntity());
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        for (MarkData.Mark m : data.marks) {
            if (m.getType() == 0 || !m.availability.isAvailable((PlayerEntity)player)) continue;
            MarkRenderer.render(event, m);
            break;
        }
    }

    @SubscribeEvent
    public void playSound(PlaySoundEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71441_e == null || mc.func_147114_u() == null) {
            return;
        }
        ISound sound = event.getSound();
        Packets.sendServer(new SPacketPlayerSoundPlays(sound.func_147650_b().toString(), sound.func_184365_d().func_187948_a(), sound.func_147657_c()));
    }

    public static void drawSelectionBox(MatrixStack matrixStack, IRenderTypeBuffer buffer, BlockPos pos) {
        matrixStack.func_227860_a_();
        AxisAlignedBB bb = new AxisAlignedBB(BlockPos.field_177992_a, pos);
        matrixStack.func_227861_a_((double)0.001f, (double)0.001f, (double)0.001f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)buffer.getBuffer(RenderType.func_228659_m_()), (AxisAlignedBB)bb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        matrixStack.func_227865_b_();
    }
}

