/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.ISpawnWorldInfo;
import net.minecraftforge.registries.ForgeRegistries;
import noppes.npcs.EventHooks;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IDimension;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IScoreboard;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.DimensionWrapper;
import noppes.npcs.api.wrapper.ScoreboardWrapper;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketPlaySound;

public class WorldWrapper
implements IWorld {
    public static Map<String, Object> tempData = new HashMap<String, Object>();
    public ServerWorld level;
    public IDimension dimension;
    private IData tempdata = new IData(){

        @Override
        public void put(String key, Object value) {
            tempData.put(key, value);
        }

        @Override
        public Object get(String key) {
            return tempData.get(key);
        }

        @Override
        public void remove(String key) {
            tempData.remove(key);
        }

        @Override
        public boolean has(String key) {
            return tempData.containsKey(key);
        }

        @Override
        public void clear() {
            tempData.clear();
        }

        @Override
        public String[] getKeys() {
            return tempData.keySet().toArray(new String[tempData.size()]);
        }
    };
    private IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            CompoundNBT compound = ScriptController.Instance.compound;
            if (value instanceof Number) {
                compound.func_74780_a(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                compound.func_74778_a(key, (String)value);
            }
            ScriptController.Instance.shouldSave = true;
        }

        @Override
        public Object get(String key) {
            CompoundNBT compound = ScriptController.Instance.compound;
            if (!compound.func_74764_b(key)) {
                return null;
            }
            INBT base = compound.func_74781_a(key);
            if (base instanceof NumberNBT) {
                return ((NumberNBT)base).func_150286_g();
            }
            return base.func_150285_a_();
        }

        @Override
        public void remove(String key) {
            ScriptController.Instance.compound.func_82580_o(key);
            ScriptController.Instance.shouldSave = true;
        }

        @Override
        public boolean has(String key) {
            return ScriptController.Instance.compound.func_74764_b(key);
        }

        @Override
        public void clear() {
            ScriptController.Instance.compound = new CompoundNBT();
            ScriptController.Instance.shouldSave = true;
        }

        @Override
        public String[] getKeys() {
            return ScriptController.Instance.compound.func_150296_c().toArray(new String[ScriptController.Instance.compound.func_150296_c().size()]);
        }
    };

    private WorldWrapper(World level) {
        this.level = (ServerWorld)level;
        this.dimension = new DimensionWrapper(level.func_234923_W_().func_240901_a_(), level.func_230315_m_());
    }

    @Override
    public ServerWorld getMCWorld() {
        return this.level;
    }

    @Override
    public IEntity[] getNearbyEntities(int x, int y, int z, int range, int type) {
        return this.getNearbyEntities(new BlockPosWrapper(new BlockPos(x, y, z)), range, type);
    }

    @Override
    public IEntity[] getNearbyEntities(IPos pos, int range, int type) {
        AxisAlignedBB bb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(pos.getMCBlockPos()).func_72314_b((double)range, (double)range, (double)range);
        List entities = this.level.func_217357_a(this.getClassForType(type), bb);
        ArrayList<IEntity> list = new ArrayList<IEntity>();
        for (Entity living : entities) {
            list.add(NpcAPI.Instance().getIEntity(living));
        }
        return list.toArray(new IEntity[list.size()]);
    }

    @Override
    public IEntity[] getAllEntities(int type) {
        List<Entity> entities = this.getEntities(this.getClassForType(type), EntityPredicates.field_180132_d);
        ArrayList<IEntity> list = new ArrayList<IEntity>();
        for (Entity living : entities) {
            list.add(NpcAPI.Instance().getIEntity(living));
        }
        return list.toArray(new IEntity[list.size()]);
    }

    public List<Entity> getEntities(Class<?> entityTypeIn, Predicate<? super Entity> predicateIn) {
        ArrayList list = Lists.newArrayList();
        ServerChunkProvider serverchunkprovider = this.level.func_72863_F();
        for (Entity entity : this.level.func_241136_z_()) {
            if (!entityTypeIn.isAssignableFrom(entity.getClass()) || !serverchunkprovider.func_73149_a(MathHelper.func_76128_c((double)entity.func_226277_ct_()) >> 4, MathHelper.func_76128_c((double)entity.func_226281_cx_()) >> 4) || !predicateIn.test((Entity)entity)) continue;
            list.add(entity);
        }
        return list;
    }

    @Override
    public IEntity getClosestEntity(int x, int y, int z, int range, int type) {
        return this.getClosestEntity(new BlockPosWrapper(new BlockPos(x, y, z)), range, type);
    }

    @Override
    public IEntity getClosestEntity(IPos pos, int range, int type) {
        AxisAlignedBB bb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(pos.getMCBlockPos()).func_72314_b((double)range, (double)range, (double)range);
        List entities = this.level.func_217357_a(this.getClassForType(type), bb);
        double distance = range * range * range;
        Entity entity = null;
        for (Entity e : entities) {
            double r = pos.getMCBlockPos().func_177951_i((Vector3i)e.func_233580_cy_());
            if (entity == null) {
                distance = r;
                entity = e;
                continue;
            }
            if (r >= distance) continue;
            distance = r;
            entity = e;
        }
        return NpcAPI.Instance().getIEntity(entity);
    }

    @Override
    public IEntity getEntity(String uuid) {
        try {
            UUID id = UUID.fromString(uuid);
            Entity e = this.level.func_217461_a(id);
            if (e == null) {
                e = this.level.func_217371_b(id);
            }
            if (e == null) {
                return null;
            }
            return NpcAPI.Instance().getIEntity(e);
        }
        catch (Exception e2) {
            throw new CustomNPCsException("Given uuid was invalid " + uuid, new Object[0]);
        }
    }

    @Override
    public IEntity createEntityFromNBT(INbt nbt) {
        Entity entity = EntityType.func_220330_a((CompoundNBT)nbt.getMCNBT(), (World)this.level).orElse(null);
        if (entity == null) {
            throw new CustomNPCsException("Failed to create an entity from given NBT", new Object[0]);
        }
        return NpcAPI.Instance().getIEntity(entity);
    }

    @Override
    public IEntity createEntity(String id) {
        ResourceLocation resource = new ResourceLocation(id);
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(resource);
        Entity entity = type.func_200721_a((World)this.level);
        if (entity == null) {
            throw new CustomNPCsException("Failed to create an entity from given id: " + id, new Object[0]);
        }
        entity.func_70107_b(0.0, 1.0, 0.0);
        return NpcAPI.Instance().getIEntity(entity);
    }

    @Override
    public IPlayer getPlayer(String name) {
        for (PlayerEntity entityplayer : this.level.func_217369_A()) {
            if (!name.equals(entityplayer.func_200200_C_().getString())) continue;
            return (IPlayer)NpcAPI.Instance().getIEntity((Entity)entityplayer);
        }
        return null;
    }

    private Class getClassForType(int type) {
        if (type == -1) {
            return Entity.class;
        }
        if (type == 5) {
            return LivingEntity.class;
        }
        if (type == 1) {
            return PlayerEntity.class;
        }
        if (type == 4) {
            return AnimalEntity.class;
        }
        if (type == 3) {
            return MonsterEntity.class;
        }
        if (type == 2) {
            return EntityNPCInterface.class;
        }
        if (type == 6) {
            return ItemEntity.class;
        }
        if (type == 7) {
            return EntityProjectile.class;
        }
        if (type == 11) {
            return ThrowableEntity.class;
        }
        if (type == 10) {
            return AbstractArrowEntity.class;
        }
        if (type == 8) {
            return PixelmonHelper.getPixelmonClass();
        }
        if (type == 9) {
            return VillagerEntity.class;
        }
        return Entity.class;
    }

    @Override
    public long getTime() {
        return this.level.func_72820_D();
    }

    @Override
    public void setTime(long time) {
        this.level.func_241114_a_(time);
    }

    @Override
    public long getTotalTime() {
        return this.level.func_82737_E();
    }

    @Override
    public IBlock getBlock(int x, int y, int z) {
        return NpcAPI.Instance().getIBlock((World)this.level, new BlockPos(x, y, z));
    }

    @Override
    public IBlock getBlock(IPos pos) {
        return NpcAPI.Instance().getIBlock((World)this.level, pos.getMCBlockPos());
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.level.func_72863_F().func_73149_a(x >> 4, z >> 4);
    }

    @Override
    public void setBlock(int x, int y, int z, String name, int meta) {
        this.setBlock(NpcAPI.Instance().getIPos(x, y, z), name);
    }

    @Override
    public IBlock setBlock(IPos pos, String name) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
        if (block == null) {
            throw new CustomNPCsException("There is no such block: %s", name);
        }
        this.level.func_180501_a(pos.getMCBlockPos(), block.func_176223_P(), 2);
        return NpcAPI.Instance().getIBlock((World)this.level, pos.getMCBlockPos());
    }

    @Override
    public void removeBlock(int x, int y, int z) {
        this.level.func_217377_a(new BlockPos(x, y, z), false);
    }

    @Override
    public void removeBlock(IPos pos) {
        this.level.func_217377_a(pos.getMCBlockPos(), false);
    }

    @Override
    public float getLightValue(int x, int y, int z) {
        return (float)this.level.func_217298_h(new BlockPos(x, y, z)) / 16.0f;
    }

    public float getLightLevel(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        int blockLight = this.level.func_226658_a_(LightType.BLOCK, pos);
        int skyLight = this.level.func_226658_a_(LightType.SKY, pos);
        int skyDarken = this.level.func_175657_ab();
        float skyLightValue = (11.0f - (float)skyDarken) * 15.0f / 11.0f;
        return Math.max((float)blockLight, (float)skyLight / 15.0f * skyLightValue);
    }

    @Override
    public IBlock getSpawnPoint() {
        BlockPos pos = this.level.func_241135_u_();
        return NpcAPI.Instance().getIBlock((World)this.level, pos);
    }

    @Override
    public void setSpawnPoint(IBlock block) {
        ISpawnWorldInfo info = (ISpawnWorldInfo)this.level.func_72912_H();
        info.func_176143_a(new BlockPos(block.getX(), block.getY(), block.getZ()), 0.0f);
    }

    @Override
    public boolean isDay() {
        return this.level.func_72820_D() % 24000L < 12000L;
    }

    @Override
    public boolean isRaining() {
        return this.level.func_72912_H().func_76059_o();
    }

    @Override
    public void setRaining(boolean bo) {
        IServerWorldInfo data = (IServerWorldInfo)this.level.func_72912_H();
        if (bo) {
            data.func_76084_b(true);
            data.func_76080_g(120000000);
        } else {
            data.func_76084_b(false);
            data.func_76080_g(0);
        }
    }

    @Override
    public void thunderStrike(double x, double y, double z) {
        LightningBoltEntity bolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a((World)this.level);
        bolt.func_225653_b_(x, y, z);
        bolt.func_233623_a_(false);
        this.level.func_217376_c((Entity)bolt);
    }

    @Override
    public void spawnParticle(String particle, double x, double y, double z, double dx, double dy, double dz, double speed, int count) {
        ParticleType type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(particle));
        if (type == null) {
            throw new CustomNPCsException("Unknown particle type: " + particle, new Object[0]);
        }
        this.level.func_195598_a((IParticleData)type, x, y, z, count, dx, dy, dz, speed);
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public IItemStack createItem(String name, int size) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            throw new CustomNPCsException("Unknown item id: " + name, new Object[0]);
        }
        return NpcAPI.Instance().getIItemStack(new ItemStack((IItemProvider)item, size));
    }

    @Override
    public IItemStack createItemFromNbt(INbt nbt) {
        ItemStack item = ItemStack.func_199557_a((CompoundNBT)nbt.getMCNBT());
        if (item.func_190926_b()) {
            throw new CustomNPCsException("Failed to create an item from given NBT", new Object[0]);
        }
        return NpcAPI.Instance().getIItemStack(item);
    }

    @Override
    public void explode(double x, double y, double z, float range, boolean fire, boolean grief) {
        this.level.func_217398_a(null, x, y, z, range, fire, grief ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
    }

    @Override
    public IPlayer[] getAllPlayers() {
        List list = this.level.func_73046_m().func_184103_al().func_181057_v();
        IPlayer[] arr = new IPlayer[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = (IPlayer)NpcAPI.Instance().getIEntity((Entity)list.get(i));
        }
        return arr;
    }

    @Override
    public String getBiomeName(int x, int z) {
        return this.level.func_226691_t_(new BlockPos(x, 0, z)).getRegistryName().toString();
    }

    @Override
    public IEntity spawnClone(double x, double y, double z, int tab, String name) {
        return NpcAPI.Instance().getClones().spawn(x, y, z, tab, name, this);
    }

    @Override
    public void spawnEntity(IEntity entity) {
        if (entity == null) {
            throw new CustomNPCsException("Entity given was null", new Object[0]);
        }
        Object e = entity.getMCEntity();
        if (this.level.func_217461_a(e.func_110124_au()) != null) {
            throw new CustomNPCsException("Entity with this UUID already exists", new Object[0]);
        }
        e.func_70107_b(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
        this.level.func_217376_c(e);
    }

    @Override
    public IEntity getClone(int tab, String name) {
        return NpcAPI.Instance().getClones().get(tab, name, this);
    }

    @Override
    public IScoreboard getScoreboard() {
        return new ScoreboardWrapper(this.level.func_73046_m());
    }

    @Override
    public void broadcast(String message) {
        StringTextComponent text = new StringTextComponent(message);
        for (PlayerEntity p : this.level.func_217490_a(e -> true)) {
            p.func_145747_a((ITextComponent)text, Util.field_240973_b_);
        }
    }

    @Override
    public int getRedstonePower(int x, int y, int z) {
        return this.level.func_175676_y(new BlockPos(x, y, z));
    }

    @Deprecated
    public static WorldWrapper createNew(ServerWorld level) {
        return new WorldWrapper((World)level);
    }

    @Override
    public IDimension getDimension() {
        return this.dimension;
    }

    @Override
    public String getName() {
        return ((IServerWorldInfo)this.level.func_72912_H()).func_76065_j();
    }

    @Override
    public BlockPos getMCBlockPos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    @Override
    public void playSoundAt(IPos pos, String sound, float volume, float pitch) {
        BlockPos bp = pos.getMCBlockPos();
        Packets.sendNearby((World)this.level, bp, 16, new PacketPlaySound(sound, bp, volume, pitch));
    }

    @Override
    public void trigger(int id, Object ... arguments) {
        EventHooks.onScriptTriggerEvent(ScriptController.Instance.forgeScripts, id, this, BlockPosWrapper.ZERO, null, arguments);
    }
}

