/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import com.google.common.collect.Multimap;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.item.WritableBookItem;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import noppes.npcs.ItemStackEmptyWrapper;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IMob;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemArmorWrapper;
import noppes.npcs.api.wrapper.ItemBlockWrapper;
import noppes.npcs.api.wrapper.ItemBookWrapper;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemScripted;

public class ItemStackWrapper
implements IItemStack,
ICapabilitySerializable<CompoundNBT> {
    private Map<String, Object> tempData = new HashMap<String, Object>();
    @CapabilityInject(value=ItemStackWrapper.class)
    public static Capability<ItemStackWrapper> ITEMSCRIPTEDDATA_CAPABILITY = null;
    private LazyOptional<ItemStackWrapper> instance = LazyOptional.of(() -> this);
    private static final EquipmentSlotType[] VALID_EQUIPMENT_SLOTS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    public ItemStack item;
    private CompoundNBT storedData = new CompoundNBT();
    public static ItemStackWrapper AIR = new ItemStackEmptyWrapper();
    private final IData tempdata = new IData(){

        @Override
        public void put(String key, Object value) {
            ItemStackWrapper.this.tempData.put(key, value);
        }

        @Override
        public Object get(String key) {
            return ItemStackWrapper.this.tempData.get(key);
        }

        @Override
        public void remove(String key) {
            ItemStackWrapper.this.tempData.remove(key);
        }

        @Override
        public boolean has(String key) {
            return ItemStackWrapper.this.tempData.containsKey(key);
        }

        @Override
        public void clear() {
            ItemStackWrapper.this.tempData.clear();
        }

        @Override
        public String[] getKeys() {
            return ItemStackWrapper.this.tempData.keySet().toArray(new String[ItemStackWrapper.this.tempData.size()]);
        }
    };
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            if (value instanceof Number) {
                ItemStackWrapper.this.storedData.func_74780_a(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                ItemStackWrapper.this.storedData.func_74778_a(key, (String)value);
            }
        }

        @Override
        public Object get(String key) {
            if (!ItemStackWrapper.this.storedData.func_74764_b(key)) {
                return null;
            }
            INBT base = ItemStackWrapper.this.storedData.func_74781_a(key);
            if (base instanceof NumberNBT) {
                return ((NumberNBT)base).func_150286_g();
            }
            return base.func_150285_a_();
        }

        @Override
        public void remove(String key) {
            ItemStackWrapper.this.storedData.func_82580_o(key);
        }

        @Override
        public boolean has(String key) {
            return ItemStackWrapper.this.storedData.func_74764_b(key);
        }

        @Override
        public void clear() {
            ItemStackWrapper.this.storedData = new CompoundNBT();
        }

        @Override
        public String[] getKeys() {
            return ItemStackWrapper.this.storedData.func_150296_c().toArray(new String[ItemStackWrapper.this.storedData.func_150296_c().size()]);
        }
    };
    private static final ResourceLocation key = new ResourceLocation("customnpcs", "itemscripteddata");

    protected ItemStackWrapper(ItemStack item) {
        this.item = item;
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public int getStackSize() {
        return this.item.func_190916_E();
    }

    @Override
    public void setStackSize(int size) {
        if (size > this.getMaxStackSize()) {
            throw new CustomNPCsException("Can't set the stacksize bigger than MaxStacksize", new Object[0]);
        }
        this.item.func_190920_e(size);
    }

    @Override
    public void setAttribute(String name, double value) {
        this.setAttribute(name, value, -1);
    }

    @Override
    public void setAttribute(String name, double value, int slot) {
        if (slot < -1 || slot > 5) {
            throw new CustomNPCsException("Slot has to be between -1 and 5, given was: " + slot, new Object[0]);
        }
        CompoundNBT compound = this.item.func_77978_p();
        if (compound == null) {
            compound = new CompoundNBT();
            this.item.func_77982_d(compound);
        }
        ListNBT nbttaglist = compound.func_150295_c("AttributeModifiers", 10);
        ListNBT newList = new ListNBT();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundNBT c = nbttaglist.func_150305_b(i);
            if (c.func_74779_i("AttributeName").equals(name)) continue;
            newList.add((Object)c);
        }
        if (value != 0.0) {
            CompoundNBT nbttagcompound = new AttributeModifier(name, value, AttributeModifier.Operation.ADDITION).func_233801_e_();
            nbttagcompound.func_74778_a("AttributeName", name);
            if (slot >= 0) {
                nbttagcompound.func_74778_a("Slot", EquipmentSlotType.values()[slot].func_188450_d());
            }
            newList.add((Object)nbttagcompound);
        }
        compound.func_218657_a("AttributeModifiers", (INBT)newList);
    }

    @Override
    public double getAttribute(String name) {
        CompoundNBT compound = this.item.func_77978_p();
        if (compound == null) {
            return 0.0;
        }
        Multimap map = this.item.func_111283_C(EquipmentSlotType.MAINHAND);
        for (Map.Entry entry : map.entries()) {
            if (!((Attribute)entry.getKey()).func_233754_c_().equals(name)) continue;
            AttributeModifier mod = (AttributeModifier)entry.getValue();
            return mod.func_111164_d();
        }
        return 0.0;
    }

    @Override
    public boolean hasAttribute(String name) {
        CompoundNBT compound = this.item.func_77978_p();
        if (compound == null) {
            return false;
        }
        ListNBT nbttaglist = compound.func_150295_c("AttributeModifiers", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundNBT c = nbttaglist.func_150305_b(i);
            if (!c.func_74779_i("AttributeName").equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addEnchantment(String id, int strenght) {
        Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(id));
        if (ench == null) {
            throw new CustomNPCsException("Unknown enchant id:" + id, new Object[0]);
        }
        this.enchant(this.item, ench, strenght);
    }

    public int getEnchantmentLevel(String id) {
        Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(id));
        if (ench == null) {
            throw new CustomNPCsException("Unknown enchant id:" + id, new Object[0]);
        }
        if (!this.isEnchanted()) {
            return 0;
        }
        if (!this.item.func_196082_o().func_150297_b("Enchantments", 9)) {
            this.item.func_196082_o().func_218657_a("Enchantments", (INBT)new ListNBT());
        }
        ListNBT listnbt = this.item.func_196082_o().func_150295_c("Enchantments", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compound = listnbt.func_150305_b(i);
            if (!compound.func_74779_i("id").equals(String.valueOf(Registry.field_212628_q.func_177774_c((Object)ench)))) continue;
            return compound.func_74762_e("lvl");
        }
        return 0;
    }

    public void enchant(ItemStack stack, Enchantment p_77966_1_, int p_77966_2_) {
        if (!stack.func_196082_o().func_150297_b("Enchantments", 9)) {
            stack.func_196082_o().func_218657_a("Enchantments", (INBT)new ListNBT());
        }
        ListNBT listnbt = stack.func_196082_o().func_150295_c("Enchantments", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compound = listnbt.func_150305_b(i);
            if (!compound.func_74779_i("id").equals(String.valueOf(Registry.field_212628_q.func_177774_c((Object)p_77966_1_)))) continue;
            compound.func_74777_a("lvl", (short)((byte)p_77966_2_));
            return;
        }
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("id", String.valueOf(Registry.field_212628_q.func_177774_c((Object)p_77966_1_)));
        compoundnbt.func_74777_a("lvl", (short)((byte)p_77966_2_));
        listnbt.add((Object)compoundnbt);
    }

    @Override
    public boolean isEnchanted() {
        return this.item.func_77948_v();
    }

    @Override
    public boolean hasEnchant(String id) {
        Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(id));
        if (ench == null) {
            throw new CustomNPCsException("Unknown enchant id:" + id, new Object[0]);
        }
        if (!this.isEnchanted()) {
            return false;
        }
        ListNBT list = this.item.func_77986_q();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT compound = list.func_150305_b(i);
            if (!compound.func_74779_i("id").equalsIgnoreCase(String.valueOf(Registry.field_212628_q.func_177774_c((Object)ench)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEnchant(String id) {
        Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(id));
        if (ench == null) {
            throw new CustomNPCsException("Unknown enchant id:" + id, new Object[0]);
        }
        if (!this.isEnchanted()) {
            return false;
        }
        ListNBT list = this.item.func_77986_q();
        ListNBT newList = new ListNBT();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT compound = list.func_150305_b(i);
            if (compound.func_74779_i("id").equalsIgnoreCase(String.valueOf(Registry.field_212628_q.func_177774_c((Object)ench)))) continue;
            newList.add((Object)compound);
        }
        if (list.size() == newList.size()) {
            return false;
        }
        this.item.func_196082_o().func_218657_a("ench", (INBT)newList);
        return true;
    }

    @Override
    public boolean isBlock() {
        Block block = Block.func_149634_a((Item)this.item.func_77973_b());
        return block != Blocks.field_150350_a;
    }

    @Override
    public boolean hasCustomName() {
        return this.item.func_82837_s();
    }

    @Override
    public void setCustomName(String name) {
        this.item.func_200302_a((ITextComponent)new TranslationTextComponent(name));
    }

    @Override
    public String getDisplayName() {
        return this.item.func_200301_q().getString();
    }

    @Override
    public String getItemName() {
        return this.item.func_77973_b().func_200295_i(this.item).getString();
    }

    @Override
    public String getName() {
        return ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.item.func_77973_b()).toString();
    }

    @Override
    public INbt getNbt() {
        CompoundNBT compound = this.item.func_77978_p();
        if (compound == null) {
            compound = new CompoundNBT();
            this.item.func_77982_d(compound);
        }
        return NpcAPI.Instance().getINbt(compound);
    }

    @Override
    public boolean hasNbt() {
        CompoundNBT compound = this.item.func_77978_p();
        return compound != null && !compound.isEmpty();
    }

    @Override
    public ItemStack getMCItemStack() {
        return this.item;
    }

    public static ItemStack MCItem(IItemStack item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return item.getMCItemStack();
    }

    @Override
    public void damageItem(int damage, IMob living) {
        if (living != null) {
            this.item.func_222118_a(damage, living == null ? null : (LivingEntity)living.getMCEntity(), e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        } else if (this.item.func_77984_f()) {
            if (this.item.func_77952_i() <= damage) {
                this.item.func_190918_g(1);
                this.item.func_196085_b(0);
            } else {
                this.item.func_196085_b(this.item.func_77952_i() - damage);
            }
        }
    }

    @Override
    public boolean isBook() {
        return false;
    }

    @Override
    public int getFoodLevel() {
        if (this.item.func_77973_b().func_219967_s() != null) {
            return this.item.func_77973_b().func_219967_s().func_221466_a();
        }
        return 0;
    }

    @Override
    public IItemStack copy() {
        return ItemStackWrapper.createNew(this.item.func_77946_l());
    }

    @Override
    public int getMaxStackSize() {
        return this.item.func_77976_d();
    }

    @Override
    public boolean isDamageable() {
        return this.item.func_77984_f();
    }

    @Override
    public int getDamage() {
        return this.item.func_77952_i();
    }

    @Override
    public void setDamage(int value) {
        this.item.func_196085_b(value);
    }

    @Deprecated
    public int getItemDamage() {
        return this.item.func_77952_i();
    }

    @Deprecated
    public void setItemDamage(int value) {
        this.item.func_196085_b(value);
    }

    @Override
    public int getMaxDamage() {
        return this.item.func_77958_k();
    }

    @Override
    public INbt getItemNbt() {
        CompoundNBT compound = new CompoundNBT();
        this.item.func_77955_b(compound);
        return NpcAPI.Instance().getINbt(compound);
    }

    @Override
    public double getAttackDamage() {
        Multimap map = this.item.func_111283_C(EquipmentSlotType.MAINHAND);
        double damage = 0.0;
        for (Map.Entry entry : map.entries()) {
            if (entry.getKey() != Attributes.field_233823_f_) continue;
            AttributeModifier mod = (AttributeModifier)entry.getValue();
            damage = mod.func_111164_d();
        }
        return damage + (double)EnchantmentHelper.func_152377_a((ItemStack)this.item, (CreatureAttribute)CreatureAttribute.field_223222_a_);
    }

    @Override
    public boolean isEmpty() {
        return this.item.func_190926_b();
    }

    @Override
    public int getType() {
        if (this.item.func_77973_b() instanceof IPlantable) {
            return 5;
        }
        if (this.item.func_77973_b() instanceof SwordItem) {
            return 4;
        }
        return 0;
    }

    @Override
    public boolean isWearable() {
        for (EquipmentSlotType slot : VALID_EQUIPMENT_SLOTS) {
            if (!this.item.func_77973_b().canEquip(this.item, slot, (Entity)EntityNPCInterface.CommandPlayer)) continue;
            return true;
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == ITEMSCRIPTEDDATA_CAPABILITY) {
            return this.instance.cast();
        }
        return LazyOptional.empty();
    }

    public static void register(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStackWrapper wrapper = ItemStackWrapper.createNew((ItemStack)event.getObject());
        event.addCapability(key, (ICapabilityProvider)wrapper);
    }

    private static ItemStackWrapper createNew(ItemStack item) {
        if (item == null || item.func_190926_b()) {
            return AIR;
        }
        if (item.func_77973_b() instanceof ItemScripted) {
            return new ItemScriptedWrapper(item);
        }
        if (item.func_77973_b() == Items.field_151164_bB || item.func_77973_b() == Items.field_151099_bA || item.func_77973_b() instanceof WritableBookItem || item.func_77973_b() instanceof WrittenBookItem) {
            return new ItemBookWrapper(item);
        }
        if (item.func_77973_b() instanceof ArmorItem) {
            return new ItemArmorWrapper(item);
        }
        Block block = Block.func_149634_a((Item)item.func_77973_b());
        if (block != Blocks.field_150350_a) {
            return new ItemBlockWrapper(item);
        }
        return new ItemStackWrapper(item);
    }

    @Override
    public String[] getLore() {
        CompoundNBT compound = this.item.func_179543_a("display");
        if (compound == null || compound.func_150299_b("Lore") != 9) {
            return new String[0];
        }
        ListNBT nbttaglist = compound.func_150295_c("Lore", 8);
        if (nbttaglist.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> lore = new ArrayList<String>();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            lore.add(nbttaglist.func_150307_f(i));
        }
        return lore.toArray(new String[lore.size()]);
    }

    @Override
    public void setLore(String[] lore) {
        CompoundNBT compound = this.item.func_190925_c("display");
        if (lore == null || lore.length == 0) {
            compound.func_82580_o("Lore");
            return;
        }
        ListNBT nbtlist = new ListNBT();
        for (String s : lore) {
            try {
                ITextComponent.Serializer.func_240643_a_((String)s);
            }
            catch (JsonParseException jsonparseexception) {
                s = ITextComponent.Serializer.func_150696_a((ITextComponent)new TranslationTextComponent(s));
            }
            nbtlist.add((Object)StringNBT.func_229705_a_((String)s));
        }
        compound.func_218657_a("Lore", (INBT)nbtlist);
    }

    public CompoundNBT serializeNBT() {
        return this.getMCNbt();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setMCNbt(nbt);
    }

    public CompoundNBT getMCNbt() {
        CompoundNBT compound = new CompoundNBT();
        if (!this.storedData.isEmpty()) {
            compound.func_218657_a("StoredData", (INBT)this.storedData);
        }
        return compound;
    }

    public void setMCNbt(CompoundNBT compound) {
        this.storedData = compound.func_74775_l("StoredData");
    }

    @Override
    public void removeNbt() {
        this.item.func_77982_d(null);
    }

    @Override
    public boolean compare(IItemStack item, boolean ignoreNBT) {
        if (item == null) {
            item = AIR;
        }
        return NoppesUtilPlayer.compareItems(this.getMCItemStack(), item.getMCItemStack(), false, ignoreNBT);
    }
}

