/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.Hand;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAIRangedAttack
extends Goal {
    private final EntityNPCInterface npc;
    private LivingEntity attackTarget;
    private int rangedAttackTime = 0;
    private int moveTries = 0;
    private int burstCount = 0;
    private int attackTick = 0;
    private boolean hasFired = false;

    public EntityAIRangedAttack(IRangedAttackMob par1IRangedAttackMob) {
        if (!(par1IRangedAttackMob instanceof LivingEntity)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.npc = (EntityNPCInterface)par1IRangedAttackMob;
        this.rangedAttackTime = this.npc.stats.ranged.getDelayMin() / 2;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        this.attackTarget = this.npc.func_70638_az();
        if (this.attackTarget == null || !this.attackTarget.func_70089_S() || !this.npc.isInRange((Entity)this.attackTarget, this.npc.stats.aggroRange) || this.npc.inventory.getProjectile() == null) {
            return false;
        }
        return this.npc.stats.ranged.getMeleeRange() < 1 || !this.npc.isInRange((Entity)this.attackTarget, this.npc.stats.ranged.getMeleeRange());
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.npc.func_70624_b(null);
        this.npc.func_70661_as().func_75499_g();
        this.moveTries = 0;
        this.hasFired = false;
        this.rangedAttackTime = this.npc.stats.ranged.getDelayMin() / 2;
    }

    public void func_75246_d() {
        this.npc.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        double var1 = this.npc.func_70092_e(this.attackTarget.func_226277_ct_(), this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.func_226281_cx_());
        float range = this.npc.stats.ranged.getRange() * this.npc.stats.ranged.getRange();
        if (this.npc.ais.directLOS) {
            this.moveTries = this.npc.func_70635_at().func_75522_a((Entity)this.attackTarget) ? ++this.moveTries : 0;
            int v = 15;
            if (var1 <= (double)range && this.moveTries >= v) {
                this.npc.func_70661_as().func_75499_g();
            } else {
                this.npc.func_70661_as().func_75497_a((Entity)this.attackTarget, 1.0);
            }
        }
        if (this.rangedAttackTime-- <= 0 && var1 <= (double)range && (this.npc.func_70635_at().func_75522_a((Entity)this.attackTarget) || this.npc.stats.ranged.getFireType() == 2)) {
            if (this.burstCount++ <= this.npc.stats.ranged.getBurst()) {
                this.rangedAttackTime = this.npc.stats.ranged.getBurstDelay();
            } else {
                this.burstCount = 0;
                this.hasFired = true;
                this.rangedAttackTime = this.npc.stats.ranged.getDelayRNG();
            }
            if (this.burstCount > 1) {
                boolean indirect = false;
                switch (this.npc.stats.ranged.getFireType()) {
                    case 1: {
                        indirect = var1 > (double)range / 2.0;
                        break;
                    }
                    case 2: {
                        indirect = !this.npc.func_70635_at().func_75522_a((Entity)this.attackTarget);
                    }
                }
                this.npc.func_82196_d(this.attackTarget, indirect ? 1.0f : 0.0f);
                if (this.npc.currentAnimation != 6) {
                    this.npc.func_184609_a(Hand.MAIN_HAND);
                }
            }
        }
    }

    public boolean hasFired() {
        return this.hasFired;
    }
}

