/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import noppes.npcs.CustomContainer;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerDialogData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketDialog;
import noppes.npcs.packets.client.PacketDialogDummy;
import noppes.npcs.packets.client.PacketGuiClose;
import noppes.npcs.packets.client.PacketGuiError;
import noppes.npcs.packets.client.PacketGuiScrollData;
import noppes.npcs.packets.client.PacketNpcEdit;
import noppes.npcs.packets.client.PacketParticle;
import noppes.npcs.packets.server.SPacketGuiOpen;
import noppes.npcs.shared.common.util.LogWriter;

public class NoppesUtilServer {
    private static HashMap<UUID, Quest> editingQuests = new HashMap();
    private static HashMap<UUID, Quest> editingQuestsClient = new HashMap();

    public static void setEditingNpc(PlayerEntity player, EntityNPCInterface npc) {
        PlayerData data = PlayerData.get(player);
        data.editingNpc = npc;
        if (npc != null) {
            Packets.send((ServerPlayerEntity)player, new PacketNpcEdit(npc.func_145782_y()));
        }
    }

    public static EntityNPCInterface getEditingNpc(PlayerEntity player) {
        PlayerData data = PlayerData.get(player);
        return data.editingNpc;
    }

    public static void setEditingQuest(PlayerEntity player, Quest quest) {
        if (player.field_70170_p.field_72995_K) {
            editingQuestsClient.put(player.func_110124_au(), quest);
        } else {
            editingQuests.put(player.func_110124_au(), quest);
        }
    }

    public static Quest getEditingQuest(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return editingQuestsClient.get(player.func_110124_au());
        }
        return editingQuests.get(player.func_110124_au());
    }

    public static void openDialog(PlayerEntity player, EntityNPCInterface npc, Dialog dia) {
        Dialog dialog = dia.copy(player);
        PlayerData playerdata = PlayerData.get(player);
        if (EventHooks.onNPCDialog(npc, player, dialog)) {
            playerdata.dialogId = -1;
            return;
        }
        playerdata.dialogId = dialog.id;
        if (npc instanceof EntityDialogNpc || dia.id < 0) {
            dialog.hideNPC = true;
            Packets.send((ServerPlayerEntity)player, new PacketDialogDummy(npc.func_200200_C_().getString(), dialog.save(new CompoundNBT())));
        } else {
            Packets.send((ServerPlayerEntity)player, new PacketDialog(npc.func_145782_y(), dialog.id));
        }
        dia.factionOptions.addPoints(player);
        if (dialog.hasQuest()) {
            PlayerQuestController.addActiveQuest(dialog.getQuest(), player);
        }
        if (!dialog.command.isEmpty()) {
            NoppesUtilServer.runCommand((Entity)npc, npc.func_200200_C_().getString(), dialog.command, player);
        }
        if (dialog.mail.isValid()) {
            PlayerDataController.instance.addPlayerMessage(player.func_184102_h(), player.func_200200_C_().getString(), dialog.mail);
        }
        PlayerDialogData data = playerdata.dialogData;
        if (!data.dialogsRead.contains(dialog.id) && dialog.id >= 0) {
            data.dialogsRead.add(dialog.id);
            playerdata.updateClient = true;
        }
        NoppesUtilServer.setEditingNpc(player, npc);
        playerdata.questData.checkQuestCompletion(player, 1);
    }

    public static String runCommand(Entity executer, String name, String command, PlayerEntity player) {
        return NoppesUtilServer.runCommand(executer.func_130014_f_(), executer.func_233580_cy_(), name, command, player, executer);
    }

    public static String runCommand(final World level, BlockPos pos, String name, String command, PlayerEntity player, Entity executer) {
        if (!level.func_73046_m().func_82356_Z()) {
            NoppesUtilServer.NotifyOPs("Cant run commands if CommandBlocks are disabled", new Object[0]);
            LogWriter.warn("Cant run commands if CommandBlocks are disabled");
            return "Cant run commands if CommandBlocks are disabled";
        }
        if (player != null) {
            command = command.replace("@dp", player.func_200200_C_().getString());
        }
        command = command.replace("@npc", name);
        final StringTextComponent output = new StringTextComponent("");
        RConConsoleSource icommandsender = new RConConsoleSource(level.func_73046_m()){

            public void func_145747_a(ITextComponent component, UUID senderUUID) {
                output.func_230529_a_(component);
            }

            public boolean func_195039_a() {
                return false;
            }

            public boolean func_195041_r_() {
                return level.func_82736_K().func_223586_b(GameRules.field_223605_h);
            }

            public boolean func_195040_b() {
                return true;
            }
        };
        int permLvl = CustomNpcs.NpcUseOpCommands ? 4 : 2;
        Vector3d point = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        CommandSource commandSource = new CommandSource((ICommandSource)icommandsender, point, Vector2f.field_189974_a, (ServerWorld)level, permLvl, "@CustomNPCs-" + name, (ITextComponent)new StringTextComponent("@CustomNPCs-" + name), level.func_73046_m(), executer){

            public void func_197021_a(ITextComponent text) {
                super.func_197021_a(text);
                NoppesUtilServer.NotifyOPs((TextComponent)(text instanceof TextComponent ? (TextComponent)text : new TranslationTextComponent(text.getString())));
            }
        };
        Commands icommandmanager = level.func_73046_m().func_195571_aL();
        icommandmanager.func_197059_a(commandSource, command);
        if (output.getString().isEmpty()) {
            return null;
        }
        return output.getString();
    }

    public static void consumeItemStack(int i, PlayerEntity player) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (player.field_71075_bZ.field_75098_d || item.func_190926_b()) {
            return;
        }
        item.func_190918_g(1);
        if (item.func_190916_E() <= 0) {
            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        }
    }

    public static DataOutputStream getDataOutputStream(ByteArrayOutputStream stream) throws IOException {
        return new DataOutputStream(new GZIPOutputStream(stream));
    }

    public static void sendOpenGui(PlayerEntity player, EnumGuiType gui, EntityNPCInterface npc) {
        SPacketGuiOpen.sendOpenGui(player, gui, npc, BlockPos.field_177992_a);
    }

    private static ContainerType getType(EnumGuiType gui) {
        if (gui == EnumGuiType.PlayerAnvil) {
            return CustomContainer.container_carpentrybench;
        }
        if (gui == EnumGuiType.CustomGui) {
            return CustomContainer.container_customgui;
        }
        if (gui == EnumGuiType.PlayerBankUnlock) {
            return CustomContainer.container_bankunlock;
        }
        if (gui == EnumGuiType.PlayerBankLarge) {
            return CustomContainer.container_banklarge;
        }
        if (gui == EnumGuiType.PlayerBankUprade) {
            return CustomContainer.container_bankupgrade;
        }
        if (gui == EnumGuiType.PlayerBankSmall) {
            return CustomContainer.container_banksmall;
        }
        if (gui == EnumGuiType.PlayerMailman) {
            return CustomContainer.container_mail;
        }
        if (gui == EnumGuiType.MainMenuInv) {
            return CustomContainer.container_inv;
        }
        if (gui == EnumGuiType.QuestItem) {
            return CustomContainer.container_questtypeitem;
        }
        if (gui == EnumGuiType.QuestReward) {
            return CustomContainer.container_questreward;
        }
        if (gui == EnumGuiType.CompanionInv) {
            return CustomContainer.container_companion;
        }
        if (gui == EnumGuiType.PlayerTrader) {
            return CustomContainer.container_trader;
        }
        if (gui == EnumGuiType.PlayerFollower) {
            return CustomContainer.container_follower;
        }
        if (gui == EnumGuiType.PlayerFollowerHire) {
            return CustomContainer.container_followerhire;
        }
        if (gui == EnumGuiType.SetupTrader) {
            return CustomContainer.container_tradersetup;
        }
        if (gui == EnumGuiType.SetupFollower) {
            return CustomContainer.container_followersetup;
        }
        if (gui == EnumGuiType.SetupItemGiver) {
            return CustomContainer.container_itemgiver;
        }
        if (gui == EnumGuiType.ManageBanks) {
            return CustomContainer.container_managebanks;
        }
        return null;
    }

    public static void openContainerGui(ServerPlayerEntity player, final EnumGuiType gui, Consumer<PacketBuffer> extraDataWriter) {
        final ContainerType type = NoppesUtilServer.getType(gui);
        final PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        extraDataWriter.accept(buffer);
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            @Nullable
            public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
                return type.create(p_createMenu_1_, p_createMenu_2_, buffer);
            }

            public ITextComponent func_145748_c_() {
                return new StringTextComponent(gui.name());
            }
        }, extraDataWriter);
    }

    public static void spawnParticle(Entity entity, String particle, int dimension) {
        Packets.sendNearby(entity, new PacketParticle(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.func_213302_cg(), entity.func_213311_cf(), particle));
    }

    public static void sendScrollData(ServerPlayerEntity player, Map<String, Integer> map) {
        Packets.send(player, new PacketGuiScrollData(map));
    }

    public static void sendGuiError(PlayerEntity player, int i) {
        Packets.send((ServerPlayerEntity)player, new PacketGuiError(i, new CompoundNBT()));
    }

    public static void sendGuiClose(ServerPlayerEntity player, int i, CompoundNBT comp) {
        Packets.send(player, new PacketGuiClose(comp));
    }

    public static boolean isOp(PlayerEntity player) {
        return player.func_184102_h().func_184103_al().func_152596_g(player.func_146103_bH());
    }

    public static void GivePlayerItem(Entity entity, PlayerEntity player, ItemStack item) {
        if (entity.field_70170_p.field_72995_K || item == null || item.func_190926_b()) {
            return;
        }
        item = item.func_77946_l();
        float f = 0.7f;
        double d = (double)(entity.field_70170_p.field_73012_v.nextFloat() * 0.7f) + (double)0.3f;
        double d2 = (double)(entity.field_70170_p.field_73012_v.nextFloat() * 0.7f) + (double)0.3f;
        double d3 = (double)(entity.field_70170_p.field_73012_v.nextFloat() * 0.7f) + (double)0.3f;
        ItemEntity entityitem = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_() + d, entity.func_226278_cu_() + d2, entity.func_226281_cx_() + d3, item);
        entityitem.func_174867_a(2);
        entity.field_70170_p.func_217376_c((Entity)entityitem);
        if (player.field_71071_by.func_70441_a(item)) {
            entity.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.func_71001_a((Entity)entityitem, item.func_190916_E());
            PlayerQuestData playerdata = PlayerData.get((PlayerEntity)player).questData;
            playerdata.checkQuestCompletion(player, 0);
            if (item.func_190916_E() <= 0) {
                entityitem.func_70106_y();
            }
        }
    }

    public static BlockPos GetClosePos(BlockPos origin, World level) {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 2; y >= -2; --y) {
                    BlockPos pos = origin.func_177982_a(x, y, z);
                    BlockState state = level.func_180495_p(pos.func_177984_a());
                    if (!state.func_215686_e((IBlockReader)level, pos) || !level.func_175623_d(pos.func_177984_a()) || !level.func_175623_d(pos.func_177981_b(2))) continue;
                    return pos.func_177984_a();
                }
            }
        }
        return level.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, origin);
    }

    public static void NotifyOPs(String message, Object ... obs) {
        NoppesUtilServer.NotifyOPs((TextComponent)new TranslationTextComponent(message, obs));
    }

    public static void NotifyOPs(TextComponent message) {
        IFormattableTextComponent chatcomponenttranslation = message.func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC});
        for (PlayerEntity entityplayer : CustomNpcs.Server.func_184103_al().func_181057_v()) {
            if (!entityplayer.func_195041_r_() || !NoppesUtilServer.isOp(entityplayer)) continue;
            entityplayer.func_145747_a((ITextComponent)chatcomponenttranslation, Util.field_240973_b_);
        }
        if (CustomNpcs.Server.func_71218_a(World.field_234918_g_).func_82736_K().func_223586_b(GameRules.field_223608_k)) {
            LogWriter.info(chatcomponenttranslation.getString());
        }
    }

    public static void playSound(LivingEntity entity, SoundEvent sound, float volume, float pitch) {
        entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), sound, SoundCategory.NEUTRAL, volume, pitch);
    }

    public static void playSound(World level, BlockPos pos, SoundEvent sound, SoundCategory cat, float volume, float pitch) {
        level.func_184133_a(null, pos, sound, cat, volume, pitch);
    }

    public static PlayerEntity getPlayer(MinecraftServer minecraftserver, UUID id) {
        List list = minecraftserver.func_184103_al().func_181057_v();
        for (PlayerEntity player : list) {
            if (!id.equals(player.func_110124_au())) continue;
            return player;
        }
        return null;
    }

    public static Entity GetDamageSourcee(DamageSource damagesource) {
        Entity entity = damagesource.func_76346_g();
        if (entity == null) {
            entity = damagesource.func_76364_f();
        }
        if (entity instanceof EntityProjectile && ((EntityProjectile)entity).func_234616_v_() instanceof LivingEntity) {
            entity = ((AbstractArrowEntity)entity).func_234616_v_();
        } else if (entity instanceof ThrowableEntity) {
            entity = ((ThrowableEntity)entity).func_234616_v_();
        }
        return entity;
    }

    public static boolean IsItemStackNull(ItemStack is) {
        return is == null || is.func_190926_b() || is == ItemStack.field_190927_a;
    }

    public static ItemStack ChangeItemStack(ItemStack is, Item item) {
        CompoundNBT comp = is.func_77955_b(new CompoundNBT());
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
        comp.func_74778_a("id", resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        return ItemStack.func_199557_a((CompoundNBT)comp);
    }
}

