/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.items.capsules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kamkeel.npcdbc.config.ConfigCapsules;
import kamkeel.npcdbc.constants.enums.EnumStaminaCapsules;
import kamkeel.npcdbc.controllers.CapsuleController;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.scripted.DBCEventHooks;
import kamkeel.npcdbc.scripted.DBCPlayerEvent;
import kamkeel.npcdbc.util.PlayerDataUtil;
import kamkeel.npcdbc.util.Utility;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;

public class ItemStaminaCapsule
extends Item {
    protected IIcon[] icons;

    public ItemStaminaCapsule() {
        this.func_77625_d(ConfigCapsules.RegenCapsuleMaxStack);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a((CreativeTabs)CustomItems.tabMisc);
    }

    public String func_77667_c(ItemStack stack) {
        int metadata = stack.func_77960_j();
        EnumStaminaCapsules staminacapsules = EnumStaminaCapsules.values()[metadata];
        return "item.npcdbc:" + staminacapsules.getName().toLowerCase() + "_staminacapsule";
    }

    public void func_94581_a(IIconRegister reg) {
        this.icons = new IIcon[EnumStaminaCapsules.count()];
        String prefix = "npcdbc:staminacapsules/";
        for (EnumStaminaCapsules staminaCapsule : EnumStaminaCapsules.values()) {
            this.icons[staminaCapsule.getMeta()] = reg.func_94245_a(prefix + staminaCapsule.getName().toLowerCase());
        }
    }

    public IIcon func_77617_a(int meta) {
        if (meta >= 0 && meta < EnumStaminaCapsules.count()) {
            return this.icons[meta];
        }
        return this.icons[0];
    }

    public EnumRarity func_77613_e(ItemStack item) {
        if (item.func_77960_j() == 0 || item.func_77960_j() == 1) {
            return EnumRarity.uncommon;
        }
        if (item.func_77960_j() == 2 || item.func_77960_j() == 3) {
            return EnumRarity.rare;
        }
        return EnumRarity.epic;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (EnumStaminaCapsules staminaCapsules : EnumStaminaCapsules.values()) {
            list.add(new ItemStack(item, 1, staminaCapsules.getMeta()));
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        UUID playerUUID;
        long remainingTime;
        player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        if (world.field_72995_K) {
            return itemStack;
        }
        int meta = itemStack.func_77960_j();
        if (meta < 0 || meta >= EnumStaminaCapsules.count()) {
            meta = 0;
        }
        if ((remainingTime = CapsuleController.canUseStaminaCapsule(playerUUID = Utility.getUUID((Entity)player), meta)) > 0L) {
            player.func_146105_b((IChatComponent)new ChatComponentText("\u00a7fCapsule is on cooldown for " + remainingTime + " seconds"));
            return itemStack;
        }
        if (DBCEventHooks.onCapsuleUsedEvent(new DBCPlayerEvent.CapsuleUsedEvent(PlayerDataUtil.getIPlayer(player), 3, meta))) {
            return itemStack;
        }
        EnumStaminaCapsules staminaCapsules = EnumStaminaCapsules.values()[meta];
        int staminaRestored = staminaCapsules.getStrength();
        DBCData.get((EntityPlayer)player).stats.restoreStaminaPercent(staminaRestored);
        itemStack.func_77979_a(1);
        if (itemStack.field_77994_a <= 0) {
            player.func_71028_bD();
        }
        CapsuleController.setStaminaCapsule(playerUUID, meta);
        return itemStack;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 100;
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par1ItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        int meta = itemStack.func_77960_j();
        if (meta < 0 || meta >= EnumStaminaCapsules.count()) {
            meta = 0;
        }
        HashMap<Integer, Integer> staminaStrength = CapsuleController.Instance.capsuleStrength.get(3);
        HashMap<Integer, Integer> staminaCooldown = CapsuleController.Instance.capsuleCooldowns.get(3);
        par3List.add(StatCollector.func_74837_a((String)"capsule.restore", (Object[])new Object[]{staminaStrength.get(meta) + "%", StatCollector.func_74838_a((String)"capsule.stamina")}));
        par3List.add(StatCollector.func_74837_a((String)"capsule.cooldown", (Object[])new Object[]{staminaCooldown.get(meta)}));
    }
}

