/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.npc;

import kamkeel.npcdbc.api.npc.IKiWeaponData;
import kamkeel.npcdbc.client.utils.Color;
import kamkeel.npcdbc.constants.enums.EnumAuraTypes3D;
import kamkeel.npcdbc.data.aura.AuraDisplay;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class KiWeaponData
implements IKiWeaponData {
    public byte weaponType;
    public Color color = new Color(-1, 0.6f);
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;

    public void readFromNBT(NBTTagCompound compound, String name) {
        NBTTagCompound weapon = compound.func_74775_l(name);
        this.weaponType = weapon.func_74771_c("weaponType");
        this.color.readFromNBT(weapon, "color");
        this.offsetX = weapon.func_74760_g("offsetX");
        this.offsetY = weapon.func_74760_g("offsetY");
        this.offsetZ = weapon.func_74760_g("offsetZ");
        this.scaleX = weapon.func_74760_g("scaleX");
        this.scaleY = weapon.func_74760_g("scaleY");
        this.scaleZ = weapon.func_74760_g("scaleZ");
    }

    public void saveToNBT(NBTTagCompound comp, String name) {
        NBTTagCompound weapon = new NBTTagCompound();
        weapon.func_74774_a("weaponType", this.weaponType);
        this.color.writeToNBT(weapon, "color");
        weapon.func_74776_a("offsetX", this.offsetX);
        weapon.func_74776_a("offsetY", this.offsetY);
        weapon.func_74776_a("offsetZ", this.offsetZ);
        NBTTagCompound scale = new NBTTagCompound();
        weapon.func_74776_a("scaleX", this.scaleX);
        weapon.func_74776_a("scaleY", this.scaleY);
        weapon.func_74776_a("scaleZ", this.scaleZ);
        comp.func_74782_a(name, (NBTBase)weapon);
    }

    @Override
    public boolean isEnabled() {
        return this.weaponType != 0;
    }

    @Override
    public void setWeaponType(int type) {
        if (type < 0 || type > 2) {
            return;
        }
        this.weaponType = (byte)type;
    }

    @Override
    public int getWeaponType() {
        return this.weaponType;
    }

    @Override
    public void setColor(int color, float alpha) {
        this.color.setColor(color, alpha);
    }

    @Override
    public int getColor() {
        return this.color.color;
    }

    @Override
    public void setXOffset(float offset) {
        this.offsetX = offset;
    }

    @Override
    public void setYOffset(float offset) {
        this.offsetY = offset;
    }

    @Override
    public void setZOffset(float offset) {
        this.offsetZ = offset;
    }

    @Override
    public float getXOffset() {
        return this.offsetX;
    }

    @Override
    public float getYOffset() {
        return this.offsetY;
    }

    @Override
    public float getZOffset() {
        return this.offsetZ;
    }

    @Override
    public void setXScale(float scale) {
        if (scale < 0.0f) {
            scale = 0.0f;
        }
        this.scaleX = scale;
    }

    @Override
    public void setYScale(float scale) {
        if (scale < 0.0f) {
            scale = 0.0f;
        }
        this.scaleY = scale;
    }

    @Override
    public void setZScale(float scale) {
        if (scale < 0.0f) {
            scale = 0.0f;
        }
        this.scaleZ = scale;
    }

    @Override
    public float getXScale() {
        return this.scaleX;
    }

    @Override
    public float getYScale() {
        return this.scaleY;
    }

    @Override
    public float getZScale() {
        return this.scaleZ;
    }

    public static int getColorByAuraType(AuraDisplay auraDisplay) {
        if (auraDisplay == null) {
            return KiWeaponData.getColorByAuraTypeName("");
        }
        if (auraDisplay.color1 == -1) {
            if (auraDisplay.type != EnumAuraTypes3D.None && auraDisplay.type != EnumAuraTypes3D.Base) {
                return KiWeaponData.getColorByAuraTypeName(auraDisplay.type.getName());
            }
            return KiWeaponData.getColorByAuraTypeName(auraDisplay.type2D.getName());
        }
        return auraDisplay.color1;
    }

    public static int getColorByAuraTypeName(String name) {
        switch (name) {
            case "ssgod": {
                return 16761125;
            }
            case "ssb": {
                return 2805230;
            }
            case "shinka": {
                return Short.MAX_VALUE;
            }
            case "ssrose": {
                return 7536661;
            }
            case "ssroseevo": {
                return 14030412;
            }
            case "ultimate": {
                return 16430355;
            }
            case "mui": 
            case "ui": {
                return 0xF0F0F0;
            }
            case "godofdestructiontoppo": 
            case "godofdestruction": {
                return 12464847;
            }
            case "jiren": {
                return 0xDD0000;
            }
        }
        return 0xA8FFFF;
    }
}

