/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.controllers;

import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;

public class EntityLightController {
    public final Entity entity;
    public HashMap<Vec3, Block> litPositions = new HashMap();
    public int lightLevel = 15;
    public int maxDistance = 15;

    public EntityLightController(Entity entity) {
        this.entity = entity;
    }

    public EntityLightController(Entity entity, int lightLevel) {
        this(entity);
        this.lightLevel = lightLevel;
    }

    public void addLitBlockUnder() {
        this.addLitBlock((int)this.entity.field_70165_t, (int)(this.entity.field_70163_u - (double)this.entity.field_70129_M - 1.0), (int)this.entity.field_70161_v);
    }

    public void addLitBlock(int posX, int posY, int posZ) {
        Block block = this.entity.field_70170_p.func_147439_a(posX, posY, posZ);
        if (this.litPositions.containsKey(this.getVector(posX, posY, posZ)) || block.func_149688_o() == Material.field_151579_a) {
            return;
        }
        this.litPositions.put(Vec3.func_72443_a((double)posX, (double)posY, (double)posZ), block);
        this.entity.field_70170_p.func_72915_b(EnumSkyBlock.Block, posX, posY, posZ, this.lightLevel);
        this.entity.field_70170_p.func_147458_c(posX, posY, posX, 12, 12, 12);
        this.entity.field_70170_p.func_147471_g(posX, posY, posZ);
        this.entity.field_70170_p.func_147463_c(EnumSkyBlock.Block, posX, posY + 1, posZ);
        this.entity.field_70170_p.func_147463_c(EnumSkyBlock.Block, posX, posY - 1, posZ);
        this.entity.field_70170_p.func_147463_c(EnumSkyBlock.Block, posX + 1, posY, posZ);
        this.entity.field_70170_p.func_147463_c(EnumSkyBlock.Block, posX - 1, posY, posZ);
        this.entity.field_70170_p.func_147463_c(EnumSkyBlock.Block, posX, posY, posZ + 1);
        this.entity.field_70170_p.func_147463_c(EnumSkyBlock.Block, posX, posY, posZ - 1);
    }

    public void onUpdate() {
        this.maxDistance = 8;
        Iterator<Vec3> iter = this.litPositions.keySet().iterator();
        while (iter.hasNext()) {
            Vec3 pos = iter.next();
            double distance = pos.func_72438_d(Vec3.func_72443_a((double)this.entity.field_70165_t, (double)this.entity.field_70163_u, (double)this.entity.field_70161_v));
            if (!(distance >= (double)this.maxDistance)) continue;
            this.removeLitBlock((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c);
            iter.remove();
        }
    }

    public Vec3 getVector(int posX, int posY, int posZ) {
        for (Vec3 pos : this.litPositions.keySet()) {
            if (pos.field_72450_a != (double)posX || pos.field_72448_b != (double)posY || pos.field_72449_c != (double)posZ) continue;
            return pos;
        }
        return null;
    }

    public void removeLitBlock(int posX, int posY, int posZ) {
        this.entity.field_70170_p.func_147463_c(EnumSkyBlock.Block, posX, posY, posZ);
    }
}

