/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.controllers;

import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kamkeel.npcdbc.api.effect.IDBCEffectHandler;
import kamkeel.npcdbc.config.ConfigDBCEffects;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.effects.AddonEffect;
import kamkeel.npcdbc.data.effects.DamageTracker;
import kamkeel.npcdbc.data.effects.SenzuConsumptionData;
import kamkeel.npcdbc.data.effects.types.Bloated;
import kamkeel.npcdbc.data.effects.types.Chocolated;
import kamkeel.npcdbc.data.effects.types.Darkness;
import kamkeel.npcdbc.data.effects.types.Exhausted;
import kamkeel.npcdbc.data.effects.types.FruitOfMight;
import kamkeel.npcdbc.data.effects.types.HumanSpirit;
import kamkeel.npcdbc.data.effects.types.Meditation;
import kamkeel.npcdbc.data.effects.types.NamekRegen;
import kamkeel.npcdbc.data.effects.types.Overpower;
import kamkeel.npcdbc.data.effects.types.PotaraFusion;
import kamkeel.npcdbc.data.effects.types.RegenHealth;
import kamkeel.npcdbc.data.effects.types.RegenKi;
import kamkeel.npcdbc.data.effects.types.RegenStamina;
import kamkeel.npcdbc.data.effects.types.Zenkai;
import kamkeel.npcdbc.network.NetworkUtility;
import kamkeel.npcdbc.util.Utility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.controllers.CustomEffectController;
import noppes.npcs.controllers.data.EffectKey;
import noppes.npcs.controllers.data.PlayerEffect;

public class DBCEffectController
implements IDBCEffectHandler {
    public static int DBC_EFFECT_INDEX = 1;
    public static DBCEffectController Instance = new DBCEffectController();
    public HashMap<Integer, AddonEffect> standardEffects = new HashMap();
    private final ConcurrentHashMap<UUID, DamageTracker> damageTrackers = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, SenzuConsumptionData> playerSenzuConsumption = new ConcurrentHashMap();

    public static DBCEffectController getInstance() {
        return Instance;
    }

    public void load() {
        this.standardEffects.put(1, new RegenHealth());
        this.standardEffects.put(2, new RegenKi());
        this.standardEffects.put(3, new RegenStamina());
        this.standardEffects.put(4, new NamekRegen());
        this.standardEffects.put(5, new FruitOfMight());
        this.standardEffects.put(8, new Overpower());
        this.standardEffects.put(9, new Chocolated());
        this.standardEffects.put(7, new Meditation());
        this.standardEffects.put(6, new Bloated());
        this.standardEffects.put(10, new Darkness());
        this.standardEffects.put(11, new Zenkai());
        this.standardEffects.put(12, new PotaraFusion());
        this.standardEffects.put(14, new HumanSpirit());
        this.standardEffects.put(13, new Exhausted());
        CustomEffectController.getInstance().registerEffectMap(DBC_EFFECT_INDEX, this.standardEffects);
    }

    public boolean hasEffect(EntityPlayer player, int id) {
        return CustomEffectController.getInstance().hasEffect(player, id, DBC_EFFECT_INDEX);
    }

    public void applyEffect(EntityPlayer player, int id) {
        AddonEffect addonEffect = this.standardEffects.get(id);
        if (addonEffect == null) {
            return;
        }
        CustomEffectController.getInstance().applyEffect(player, id, addonEffect.length, (byte)1, DBC_EFFECT_INDEX);
    }

    public AddonEffect get(int id) {
        return this.standardEffects.get(id);
    }

    public void applyEffect(EntityPlayer player, int id, int duration) {
        CustomEffectController.getInstance().applyEffect(player, id, duration, (byte)1, DBC_EFFECT_INDEX);
    }

    public void applyEffect(EntityPlayer player, int id, int duration, byte level) {
        CustomEffectController.getInstance().applyEffect(player, id, duration, level, DBC_EFFECT_INDEX);
    }

    public void clearDBCEffects(EntityPlayer player) {
        ConcurrentHashMap map = CustomEffectController.getInstance().getPlayerEffects(player);
        map.keySet().removeIf(key -> key.getIndex() == DBC_EFFECT_INDEX);
    }

    public void removeEffect(EntityPlayer player, int id) {
        ConcurrentHashMap map = CustomEffectController.getInstance().getPlayerEffects(player);
        map.keySet().removeIf(key -> key.getIndex() == DBC_EFFECT_INDEX && key.getId() == id);
    }

    public int getEffectDuration(EntityPlayer player, int id) {
        return CustomEffectController.getInstance().getEffectDuration(player, id, DBC_EFFECT_INDEX);
    }

    public int getEffectLevel(EntityPlayer player, int id) {
        PlayerEffect effect = (PlayerEffect)CustomEffectController.getInstance().getPlayerEffects(player).get(new EffectKey(id, DBC_EFFECT_INDEX));
        return effect != null ? (int)effect.level : -1;
    }

    public boolean allowSenzuConsumption(EntityPlayer player) {
        if (this.hasEffect(player, 6)) {
            return false;
        }
        if (!ConfigDBCEffects.AUTO_BLOATED) {
            return true;
        }
        UUID playerId = Utility.getUUID((Entity)player);
        SenzuConsumptionData consumptionData = this.getPlayerSenzuData(player);
        long currentTime = System.currentTimeMillis();
        consumptionData.cleanOldConsumption(currentTime, ConfigDBCEffects.DECREASE_TIME);
        consumptionData.addConsumption(currentTime);
        int excessConsumption = consumptionData.getExcessConsumption(ConfigDBCEffects.BLOATED_THRESHOLD);
        if (excessConsumption > 0 && excessConsumption < ConfigDBCEffects.MAX_THRESHOLD_EXCEED) {
            NetworkUtility.sendServerMessage(player, "\u00a7c", "npcdbc.full");
        }
        if (excessConsumption >= ConfigDBCEffects.MAX_THRESHOLD_EXCEED) {
            this.applyEffect(player, 6, ConfigDBCEffects.BLOATED_TIME);
            NetworkUtility.sendServerMessage(player, "\u00a74", "npcdbc.bloated");
            return false;
        }
        this.playerSenzuConsumption.put(playerId, consumptionData);
        return true;
    }

    public void decreaseSenzuConsumption(EntityPlayer player) {
        SenzuConsumptionData data = this.getPlayerSenzuData(player);
        data.decreaseConsumption(ConfigDBCEffects.DECREASE_TIME);
    }

    private SenzuConsumptionData getPlayerSenzuData(EntityPlayer player) {
        UUID playerId = Utility.getUUID((Entity)player);
        return this.playerSenzuConsumption.computeIfAbsent(playerId, k -> new SenzuConsumptionData());
    }

    public void recordDamage(EntityPlayer player, double damageAmount) {
        UUID playerId = Utility.getUUID((Entity)player);
        this.damageTrackers.computeIfAbsent(playerId, k -> new DamageTracker(playerId)).recordDamage(damageAmount);
    }

    public void checkHumanSpirit(EntityPlayer player) {
        UUID playerId = Utility.getUUID((Entity)player);
        if (this.hasEffect(player, 14)) {
            return;
        }
        if (ConfigDBCEffects.EXHAUST_HUMANSPIRIT && this.hasEffect(player, 13)) {
            return;
        }
        DamageTracker tracker = this.damageTrackers.get(playerId);
        DBCData dbcData = DBCData.get(player);
        int maxHealth = dbcData.stats.getMaxBody();
        if (tracker != null && tracker.checkForHumanSpirit(maxHealth)) {
            this.applyEffect(player, 14);
            NetworkUtility.sendServerMessage(player, "\u00a7d", "npcdbc.humanSpiritMessage");
            tracker.cleanOldEntries(System.currentTimeMillis());
        }
    }

    @Override
    public boolean hasEffect(IPlayer player, int id) {
        if (player == null || !(player.getMCEntity() instanceof EntityPlayer)) {
            return false;
        }
        return this.hasEffect((EntityPlayer)player.getMCEntity(), id);
    }

    @Override
    public void applyEffect(IPlayer player, int id) {
        if (player == null || !(player.getMCEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)player.getMCEntity();
        this.applyEffect(entityPlayer, id);
    }

    @Override
    public void applyEffect(IPlayer player, int id, int duration) {
        if (player == null || !(player.getMCEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)player.getMCEntity();
        this.applyEffect(entityPlayer, id, duration);
    }

    @Override
    public void applyEffect(IPlayer player, int id, int duration, byte level) {
        if (player == null || !(player.getMCEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)player.getMCEntity();
        this.applyEffect(entityPlayer, id, duration, level);
    }

    @Override
    public void clearDBCEffects(IPlayer player) {
        if (player == null || !(player.getMCEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)player.getMCEntity();
        this.clearDBCEffects(entityPlayer);
    }

    @Override
    public void removeEffect(IPlayer player, int id) {
        if (player == null || !(player.getMCEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)player.getMCEntity();
        this.removeEffect(entityPlayer, id);
    }

    @Override
    public int getEffectDuration(IPlayer player, int id) {
        if (player == null || !(player.getMCEntity() instanceof EntityPlayer)) {
            return -1;
        }
        return this.getEffectDuration((EntityPlayer)player.getMCEntity(), id);
    }

    @Override
    public int getEffectLevel(IPlayer player, int id) {
        if (player == null || !(player.getMCEntity() instanceof EntityPlayer)) {
            return -1;
        }
        return this.getEffectLevel((EntityPlayer)player.getMCEntity(), id);
    }
}

